/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.mock.tag;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;

public class MockTag
implements PlcTag {
    private final String address;
    private final PlcValueType type;
    private static final Pattern PATTERN = Pattern.compile("%(?<address>[a-zA-Z_.0-9]+(?:\\[[0-9]*])?):?(?<type>[A-Z]*)");

    public static MockTag of(String addressString) throws PlcInvalidTagException {
        Matcher matcher = PATTERN.matcher(addressString);
        if (matcher.matches()) {
            String address = matcher.group("address");
            PlcValueType type = PlcValueType.valueOf((String)matcher.group("type"));
            return new MockTag(address, type);
        }
        return null;
    }

    public MockTag(String address) {
        this.address = address;
        this.type = null;
    }

    public MockTag(String address, PlcValueType type) {
        this.address = address;
        this.type = type;
    }

    public MockTag(String address, PlcValue plcValue) {
        this.address = address;
        this.type = plcValue.getPlcValueType();
    }

    public String getAddressString() {
        return this.address;
    }

    public PlcValueType getPlcValueType() {
        return this.type;
    }

    public List<ArrayInfo> getArrayInfo() {
        return Collections.emptyList();
    }

    public String toString() {
        return "mock tag: " + this.address;
    }

    public boolean equals(Object o) {
        return o instanceof MockTag && ((MockTag)o).address.equals(this.address);
    }

    public int hashCode() {
        return this.address.hashCode();
    }
}

