/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.mock.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.HexDump;
import org.apache.commons.lang3.StringUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;

public class Assert {
    public static void assertByteEquals(byte expected, byte actual) {
        String expectedHex = "0x" + StringUtils.leftPad((String)Integer.toHexString(expected), (int)2, (char)'0');
        String actualHex = "0x" + StringUtils.leftPad((String)Integer.toHexString(actual), (int)2, (char)'0');
        Assertions.assertEquals((Object)expectedHex, (Object)actualHex);
    }

    public static void assertByteEquals(byte[] expected, byte[] actual) throws IOException {
        String expectedHex = Assert.cleanHexDump(Assert.dump(expected));
        String actualHex = Assert.cleanHexDump(Assert.dump(actual));
        Assertions.assertEquals((Object)expectedHex, (Object)actualHex);
    }

    public static Matcher<byte[]> byteArrayEqualsTo(final byte[] expected) {
        return new IsEqual<byte[]>(expected){

            public void describeTo(Description description) {
                try {
                    String dump = Assert.dump(expected);
                    description.appendText("\n").appendText(Assert.cleanHexDump(dump));
                }
                catch (IOException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
            }

            public void describeMismatch(Object item, Description description) {
                if (item == null || !(item instanceof byte[])) {
                    super.describeMismatch(item, description);
                    return;
                }
                try {
                    String dump = Assert.dump((byte[])item);
                    description.appendText("was ").appendText("\n").appendText(Assert.cleanHexDump(dump));
                }
                catch (IOException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
            }
        };
    }

    private static String cleanHexDump(String in) {
        return in.replaceAll("@.*\\{", "@XXXXXXXX{");
    }

    private static String dump(byte[] bytes) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            HexDump.dump((byte[])bytes, (long)0L, (OutputStream)byteArrayOutputStream, (int)0);
            return String.valueOf(HexDump.EOL) + byteArrayOutputStream;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

