/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.rtu;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusRtuADU;
import org.apache.plc4x.java.modbus.rtu.config.ModbusRtuConfiguration;
import org.apache.plc4x.java.modbus.rtu.context.ModbusRtuContext;
import org.apache.plc4x.java.modbus.rtu.protocol.ModbusRtuProtocolLogic;
import org.apache.plc4x.java.modbus.tcp.config.ModbusTcpTransportConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;

public class ModbusRtuDriver
extends GeneratedDriverBase<ModbusRtuADU> {
    public String getProtocolCode() {
        return "modbus-rtu";
    }

    public String getProtocolName() {
        return "Modbus RTU";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return ModbusRtuConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(ModbusTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("serial");
    }

    protected List<String> getSupportedTransportCodes() {
        return Arrays.asList("tcp", "serial");
    }

    protected boolean awaitSetupComplete() {
        return false;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canPing() {
        return true;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    protected ProtocolStackConfigurer<ModbusRtuADU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(ModbusRtuADU.class, io -> (ModbusRtuADU)ModbusRtuADU.staticParse(io, DriverType.MODBUS_RTU, true)).withProtocol(ModbusRtuProtocolLogic.class).withDriverContext(ModbusRtuContext.class).withPacketSizeEstimator(ByteLengthEstimator.class).build();
    }

    public ModbusTag prepareTag(String tagAddress) {
        return ModbusTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 4) {
                byte[] buf = new byte[byteBuf.readableBytes()];
                byteBuf.getBytes(byteBuf.readerIndex(), buf);
                ReadBufferByteBased reader = new ReadBufferByteBased(buf);
                try {
                    ModbusADU modbusADU = ModbusRtuADU.staticParse((ReadBuffer)reader, DriverType.MODBUS_RTU, true);
                    return modbusADU.getLengthInBytes();
                }
                catch (ParseException e) {
                    return -1;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    byteBuf.discardReadBytes();
                    return -1;
                }
            }
            return -1;
        }
    }
}

