/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.tcp;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.messages.PlcDiscoveryRequest;
import org.apache.plc4x.java.modbus.base.optimizer.ModbusOptimizer;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusTcpADU;
import org.apache.plc4x.java.modbus.tcp.config.ModbusTcpConfiguration;
import org.apache.plc4x.java.modbus.tcp.config.ModbusTcpTransportConfiguration;
import org.apache.plc4x.java.modbus.tcp.context.ModbusTcpContext;
import org.apache.plc4x.java.modbus.tcp.discovery.ModbusPlcDiscoverer;
import org.apache.plc4x.java.modbus.tcp.protocol.ModbusTcpProtocolLogic;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.messages.DefaultPlcDiscoveryRequest;
import org.apache.plc4x.java.spi.messages.PlcDiscoverer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;

public class ModbusTcpDriver
extends GeneratedDriverBase<ModbusTcpADU> {
    public String getProtocolCode() {
        return "modbus-tcp";
    }

    public String getProtocolName() {
        return "Modbus TCP";
    }

    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return ModbusTcpConfiguration.class;
    }

    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(ModbusTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("tcp");
    }

    protected List<String> getSupportedTransportCodes() {
        return Collections.singletonList("tcp");
    }

    public PlcDiscoveryRequest.Builder discoveryRequestBuilder() {
        return new DefaultPlcDiscoveryRequest.Builder((PlcDiscoverer)new ModbusPlcDiscoverer());
    }

    protected boolean awaitSetupComplete() {
        return false;
    }

    protected boolean awaitDisconnectComplete() {
        return false;
    }

    protected boolean canDiscover() {
        return true;
    }

    protected boolean canPing() {
        return true;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected BaseOptimizer getOptimizer() {
        return new ModbusOptimizer();
    }

    protected ProtocolStackConfigurer<ModbusTcpADU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(ModbusTcpADU.class, io -> (ModbusTcpADU)ModbusTcpADU.staticParse(io, DriverType.MODBUS_TCP, true)).withProtocol(ModbusTcpProtocolLogic.class).withDriverContext(ModbusTcpContext.class).withPacketSizeEstimator(ByteLengthEstimator.class).build();
    }

    public ModbusTag prepareTag(String tagAddress) {
        return ModbusTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 6) {
                return byteBuf.getUnsignedShort(byteBuf.readerIndex() + 4) + 6;
            }
            return -1;
        }
    }
}

