/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AddNodesRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "488";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final int noOfNodesToAdd;
  protected final List<ExtensionObjectDefinition> nodesToAdd;

  public AddNodesRequest(
      ExtensionObjectDefinition requestHeader,
      int noOfNodesToAdd,
      List<ExtensionObjectDefinition> nodesToAdd) {
    super();
    this.requestHeader = requestHeader;
    this.noOfNodesToAdd = noOfNodesToAdd;
    this.nodesToAdd = nodesToAdd;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public int getNoOfNodesToAdd() {
    return noOfNodesToAdd;
  }

  public List<ExtensionObjectDefinition> getNodesToAdd() {
    return nodesToAdd;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AddNodesRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfNodesToAdd)
    writeSimpleField("noOfNodesToAdd", noOfNodesToAdd, writeSignedInt(writeBuffer, 32));

    // Array Field (nodesToAdd)
    writeComplexTypeArrayField("nodesToAdd", nodesToAdd, writeBuffer);

    writeBuffer.popContext("AddNodesRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AddNodesRequest _value = this;

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (noOfNodesToAdd)
    lengthInBits += 32;

    // Array field
    if (nodesToAdd != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : nodesToAdd) {
        boolean last = ++i >= nodesToAdd.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static AddNodesRequestBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("AddNodesRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    int noOfNodesToAdd = readSimpleField("noOfNodesToAdd", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> nodesToAdd =
        readCountArrayField(
            "nodesToAdd",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("378")),
                readBuffer),
            noOfNodesToAdd);

    readBuffer.closeContext("AddNodesRequest");
    // Create the instance
    return new AddNodesRequestBuilder(requestHeader, noOfNodesToAdd, nodesToAdd);
  }

  public static class AddNodesRequestBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final int noOfNodesToAdd;
    private final List<ExtensionObjectDefinition> nodesToAdd;

    public AddNodesRequestBuilder(
        ExtensionObjectDefinition requestHeader,
        int noOfNodesToAdd,
        List<ExtensionObjectDefinition> nodesToAdd) {

      this.requestHeader = requestHeader;
      this.noOfNodesToAdd = noOfNodesToAdd;
      this.nodesToAdd = nodesToAdd;
    }

    public AddNodesRequest build() {
      AddNodesRequest addNodesRequest =
          new AddNodesRequest(requestHeader, noOfNodesToAdd, nodesToAdd);
      return addNodesRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AddNodesRequest)) {
      return false;
    }
    AddNodesRequest that = (AddNodesRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getNoOfNodesToAdd() == that.getNoOfNodesToAdd())
        && (getNodesToAdd() == that.getNodesToAdd())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRequestHeader(), getNoOfNodesToAdd(), getNodesToAdd());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
