/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AliasNameDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "23470";
  }

  // Properties.
  protected final QualifiedName aliasName;
  protected final int noOfReferencedNodes;
  protected final List<ExpandedNodeId> referencedNodes;

  public AliasNameDataType(
      QualifiedName aliasName, int noOfReferencedNodes, List<ExpandedNodeId> referencedNodes) {
    super();
    this.aliasName = aliasName;
    this.noOfReferencedNodes = noOfReferencedNodes;
    this.referencedNodes = referencedNodes;
  }

  public QualifiedName getAliasName() {
    return aliasName;
  }

  public int getNoOfReferencedNodes() {
    return noOfReferencedNodes;
  }

  public List<ExpandedNodeId> getReferencedNodes() {
    return referencedNodes;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AliasNameDataType");

    // Simple Field (aliasName)
    writeSimpleField("aliasName", aliasName, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfReferencedNodes)
    writeSimpleField("noOfReferencedNodes", noOfReferencedNodes, writeSignedInt(writeBuffer, 32));

    // Array Field (referencedNodes)
    writeComplexTypeArrayField("referencedNodes", referencedNodes, writeBuffer);

    writeBuffer.popContext("AliasNameDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AliasNameDataType _value = this;

    // Simple field (aliasName)
    lengthInBits += aliasName.getLengthInBits();

    // Simple field (noOfReferencedNodes)
    lengthInBits += 32;

    // Array field
    if (referencedNodes != null) {
      int i = 0;
      for (ExpandedNodeId element : referencedNodes) {
        boolean last = ++i >= referencedNodes.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static AliasNameDataTypeBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("AliasNameDataType");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    QualifiedName aliasName =
        readSimpleField(
            "aliasName",
            new DataReaderComplexDefault<>(
                () -> QualifiedName.staticParse(readBuffer), readBuffer));

    int noOfReferencedNodes = readSimpleField("noOfReferencedNodes", readSignedInt(readBuffer, 32));

    List<ExpandedNodeId> referencedNodes =
        readCountArrayField(
            "referencedNodes",
            new DataReaderComplexDefault<>(
                () -> ExpandedNodeId.staticParse(readBuffer), readBuffer),
            noOfReferencedNodes);

    readBuffer.closeContext("AliasNameDataType");
    // Create the instance
    return new AliasNameDataTypeBuilder(aliasName, noOfReferencedNodes, referencedNodes);
  }

  public static class AliasNameDataTypeBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final QualifiedName aliasName;
    private final int noOfReferencedNodes;
    private final List<ExpandedNodeId> referencedNodes;

    public AliasNameDataTypeBuilder(
        QualifiedName aliasName, int noOfReferencedNodes, List<ExpandedNodeId> referencedNodes) {

      this.aliasName = aliasName;
      this.noOfReferencedNodes = noOfReferencedNodes;
      this.referencedNodes = referencedNodes;
    }

    public AliasNameDataType build() {
      AliasNameDataType aliasNameDataType =
          new AliasNameDataType(aliasName, noOfReferencedNodes, referencedNodes);
      return aliasNameDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AliasNameDataType)) {
      return false;
    }
    AliasNameDataType that = (AliasNameDataType) o;
    return (getAliasName() == that.getAliasName())
        && (getNoOfReferencedNodes() == that.getNoOfReferencedNodes())
        && (getReferencedNodes() == that.getReferencedNodes())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getAliasName(), getNoOfReferencedNodes(), getReferencedNodes());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
