/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AxisInformation extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "12081";
  }

  // Properties.
  protected final ExtensionObjectDefinition engineeringUnits;
  protected final ExtensionObjectDefinition eURange;
  protected final LocalizedText title;
  protected final AxisScaleEnumeration axisScaleType;
  protected final int noOfAxisSteps;
  protected final List<Double> axisSteps;

  public AxisInformation(
      ExtensionObjectDefinition engineeringUnits,
      ExtensionObjectDefinition eURange,
      LocalizedText title,
      AxisScaleEnumeration axisScaleType,
      int noOfAxisSteps,
      List<Double> axisSteps) {
    super();
    this.engineeringUnits = engineeringUnits;
    this.eURange = eURange;
    this.title = title;
    this.axisScaleType = axisScaleType;
    this.noOfAxisSteps = noOfAxisSteps;
    this.axisSteps = axisSteps;
  }

  public ExtensionObjectDefinition getEngineeringUnits() {
    return engineeringUnits;
  }

  public ExtensionObjectDefinition getEURange() {
    return eURange;
  }

  public LocalizedText getTitle() {
    return title;
  }

  public AxisScaleEnumeration getAxisScaleType() {
    return axisScaleType;
  }

  public int getNoOfAxisSteps() {
    return noOfAxisSteps;
  }

  public List<Double> getAxisSteps() {
    return axisSteps;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("AxisInformation");

    // Simple Field (engineeringUnits)
    writeSimpleField(
        "engineeringUnits", engineeringUnits, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (eURange)
    writeSimpleField("eURange", eURange, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (title)
    writeSimpleField("title", title, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (axisScaleType)
    writeSimpleEnumField(
        "axisScaleType",
        "AxisScaleEnumeration",
        axisScaleType,
        new DataWriterEnumDefault<>(
            AxisScaleEnumeration::getValue,
            AxisScaleEnumeration::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (noOfAxisSteps)
    writeSimpleField("noOfAxisSteps", noOfAxisSteps, writeSignedInt(writeBuffer, 32));

    // Array Field (axisSteps)
    writeSimpleTypeArrayField("axisSteps", axisSteps, writeDouble(writeBuffer, 64));

    writeBuffer.popContext("AxisInformation");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AxisInformation _value = this;

    // Simple field (engineeringUnits)
    lengthInBits += engineeringUnits.getLengthInBits();

    // Simple field (eURange)
    lengthInBits += eURange.getLengthInBits();

    // Simple field (title)
    lengthInBits += title.getLengthInBits();

    // Simple field (axisScaleType)
    lengthInBits += 32;

    // Simple field (noOfAxisSteps)
    lengthInBits += 32;

    // Array field
    if (axisSteps != null) {
      lengthInBits += 64 * axisSteps.size();
    }

    return lengthInBits;
  }

  public static AxisInformationBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("AxisInformation");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition engineeringUnits =
        readSimpleField(
            "engineeringUnits",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("889")),
                readBuffer));

    ExtensionObjectDefinition eURange =
        readSimpleField(
            "eURange",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("886")),
                readBuffer));

    LocalizedText title =
        readSimpleField(
            "title",
            new DataReaderComplexDefault<>(
                () -> LocalizedText.staticParse(readBuffer), readBuffer));

    AxisScaleEnumeration axisScaleType =
        readEnumField(
            "axisScaleType",
            "AxisScaleEnumeration",
            new DataReaderEnumDefault<>(
                AxisScaleEnumeration::enumForValue, readUnsignedLong(readBuffer, 32)));

    int noOfAxisSteps = readSimpleField("noOfAxisSteps", readSignedInt(readBuffer, 32));

    List<Double> axisSteps =
        readCountArrayField("axisSteps", readDouble(readBuffer, 64), noOfAxisSteps);

    readBuffer.closeContext("AxisInformation");
    // Create the instance
    return new AxisInformationBuilder(
        engineeringUnits, eURange, title, axisScaleType, noOfAxisSteps, axisSteps);
  }

  public static class AxisInformationBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition engineeringUnits;
    private final ExtensionObjectDefinition eURange;
    private final LocalizedText title;
    private final AxisScaleEnumeration axisScaleType;
    private final int noOfAxisSteps;
    private final List<Double> axisSteps;

    public AxisInformationBuilder(
        ExtensionObjectDefinition engineeringUnits,
        ExtensionObjectDefinition eURange,
        LocalizedText title,
        AxisScaleEnumeration axisScaleType,
        int noOfAxisSteps,
        List<Double> axisSteps) {

      this.engineeringUnits = engineeringUnits;
      this.eURange = eURange;
      this.title = title;
      this.axisScaleType = axisScaleType;
      this.noOfAxisSteps = noOfAxisSteps;
      this.axisSteps = axisSteps;
    }

    public AxisInformation build() {
      AxisInformation axisInformation =
          new AxisInformation(
              engineeringUnits, eURange, title, axisScaleType, noOfAxisSteps, axisSteps);
      return axisInformation;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AxisInformation)) {
      return false;
    }
    AxisInformation that = (AxisInformation) o;
    return (getEngineeringUnits() == that.getEngineeringUnits())
        && (getEURange() == that.getEURange())
        && (getTitle() == that.getTitle())
        && (getAxisScaleType() == that.getAxisScaleType())
        && (getNoOfAxisSteps() == that.getNoOfAxisSteps())
        && (getAxisSteps() == that.getAxisSteps())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getEngineeringUnits(),
        getEURange(),
        getTitle(),
        getAxisScaleType(),
        getNoOfAxisSteps(),
        getAxisSteps());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
