/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BrowseRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "527";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final ExtensionObjectDefinition view;
  protected final long requestedMaxReferencesPerNode;
  protected final int noOfNodesToBrowse;
  protected final List<ExtensionObjectDefinition> nodesToBrowse;

  public BrowseRequest(
      ExtensionObjectDefinition requestHeader,
      ExtensionObjectDefinition view,
      long requestedMaxReferencesPerNode,
      int noOfNodesToBrowse,
      List<ExtensionObjectDefinition> nodesToBrowse) {
    super();
    this.requestHeader = requestHeader;
    this.view = view;
    this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
    this.noOfNodesToBrowse = noOfNodesToBrowse;
    this.nodesToBrowse = nodesToBrowse;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public ExtensionObjectDefinition getView() {
    return view;
  }

  public long getRequestedMaxReferencesPerNode() {
    return requestedMaxReferencesPerNode;
  }

  public int getNoOfNodesToBrowse() {
    return noOfNodesToBrowse;
  }

  public List<ExtensionObjectDefinition> getNodesToBrowse() {
    return nodesToBrowse;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("BrowseRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (view)
    writeSimpleField("view", view, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (requestedMaxReferencesPerNode)
    writeSimpleField(
        "requestedMaxReferencesPerNode",
        requestedMaxReferencesPerNode,
        writeUnsignedLong(writeBuffer, 32));

    // Simple Field (noOfNodesToBrowse)
    writeSimpleField("noOfNodesToBrowse", noOfNodesToBrowse, writeSignedInt(writeBuffer, 32));

    // Array Field (nodesToBrowse)
    writeComplexTypeArrayField("nodesToBrowse", nodesToBrowse, writeBuffer);

    writeBuffer.popContext("BrowseRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BrowseRequest _value = this;

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (view)
    lengthInBits += view.getLengthInBits();

    // Simple field (requestedMaxReferencesPerNode)
    lengthInBits += 32;

    // Simple field (noOfNodesToBrowse)
    lengthInBits += 32;

    // Array field
    if (nodesToBrowse != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : nodesToBrowse) {
        boolean last = ++i >= nodesToBrowse.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static BrowseRequestBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("BrowseRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    ExtensionObjectDefinition view =
        readSimpleField(
            "view",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("513")),
                readBuffer));

    long requestedMaxReferencesPerNode =
        readSimpleField("requestedMaxReferencesPerNode", readUnsignedLong(readBuffer, 32));

    int noOfNodesToBrowse = readSimpleField("noOfNodesToBrowse", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> nodesToBrowse =
        readCountArrayField(
            "nodesToBrowse",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("516")),
                readBuffer),
            noOfNodesToBrowse);

    readBuffer.closeContext("BrowseRequest");
    // Create the instance
    return new BrowseRequestBuilder(
        requestHeader, view, requestedMaxReferencesPerNode, noOfNodesToBrowse, nodesToBrowse);
  }

  public static class BrowseRequestBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final ExtensionObjectDefinition view;
    private final long requestedMaxReferencesPerNode;
    private final int noOfNodesToBrowse;
    private final List<ExtensionObjectDefinition> nodesToBrowse;

    public BrowseRequestBuilder(
        ExtensionObjectDefinition requestHeader,
        ExtensionObjectDefinition view,
        long requestedMaxReferencesPerNode,
        int noOfNodesToBrowse,
        List<ExtensionObjectDefinition> nodesToBrowse) {

      this.requestHeader = requestHeader;
      this.view = view;
      this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
      this.noOfNodesToBrowse = noOfNodesToBrowse;
      this.nodesToBrowse = nodesToBrowse;
    }

    public BrowseRequest build() {
      BrowseRequest browseRequest =
          new BrowseRequest(
              requestHeader, view, requestedMaxReferencesPerNode, noOfNodesToBrowse, nodesToBrowse);
      return browseRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BrowseRequest)) {
      return false;
    }
    BrowseRequest that = (BrowseRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getView() == that.getView())
        && (getRequestedMaxReferencesPerNode() == that.getRequestedMaxReferencesPerNode())
        && (getNoOfNodesToBrowse() == that.getNoOfNodesToBrowse())
        && (getNodesToBrowse() == that.getNodesToBrowse())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getView(),
        getRequestedMaxReferencesPerNode(),
        getNoOfNodesToBrowse(),
        getNodesToBrowse());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
