/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BrowseResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "524";
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final PascalByteString continuationPoint;
  protected final int noOfReferences;
  protected final List<ExtensionObjectDefinition> references;

  public BrowseResult(
      StatusCode statusCode,
      PascalByteString continuationPoint,
      int noOfReferences,
      List<ExtensionObjectDefinition> references) {
    super();
    this.statusCode = statusCode;
    this.continuationPoint = continuationPoint;
    this.noOfReferences = noOfReferences;
    this.references = references;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public PascalByteString getContinuationPoint() {
    return continuationPoint;
  }

  public int getNoOfReferences() {
    return noOfReferences;
  }

  public List<ExtensionObjectDefinition> getReferences() {
    return references;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("BrowseResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (continuationPoint)
    writeSimpleField(
        "continuationPoint", continuationPoint, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfReferences)
    writeSimpleField("noOfReferences", noOfReferences, writeSignedInt(writeBuffer, 32));

    // Array Field (references)
    writeComplexTypeArrayField("references", references, writeBuffer);

    writeBuffer.popContext("BrowseResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BrowseResult _value = this;

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Simple field (continuationPoint)
    lengthInBits += continuationPoint.getLengthInBits();

    // Simple field (noOfReferences)
    lengthInBits += 32;

    // Array field
    if (references != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : references) {
        boolean last = ++i >= references.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static BrowseResultBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier)
      throws ParseException {
    readBuffer.pullContext("BrowseResult");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    StatusCode statusCode =
        readSimpleField(
            "statusCode",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer));

    PascalByteString continuationPoint =
        readSimpleField(
            "continuationPoint",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    int noOfReferences = readSimpleField("noOfReferences", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> references =
        readCountArrayField(
            "references",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("520")),
                readBuffer),
            noOfReferences);

    readBuffer.closeContext("BrowseResult");
    // Create the instance
    return new BrowseResultBuilder(statusCode, continuationPoint, noOfReferences, references);
  }

  public static class BrowseResultBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final PascalByteString continuationPoint;
    private final int noOfReferences;
    private final List<ExtensionObjectDefinition> references;

    public BrowseResultBuilder(
        StatusCode statusCode,
        PascalByteString continuationPoint,
        int noOfReferences,
        List<ExtensionObjectDefinition> references) {

      this.statusCode = statusCode;
      this.continuationPoint = continuationPoint;
      this.noOfReferences = noOfReferences;
      this.references = references;
    }

    public BrowseResult build() {
      BrowseResult browseResult =
          new BrowseResult(statusCode, continuationPoint, noOfReferences, references);
      return browseResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BrowseResult)) {
      return false;
    }
    BrowseResult that = (BrowseResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getContinuationPoint() == that.getContinuationPoint())
        && (getNoOfReferences() == that.getNoOfReferences())
        && (getReferences() == that.getReferences())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getStatusCode(),
        getContinuationPoint(),
        getNoOfReferences(),
        getReferences());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
