/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ChannelSecurityToken extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "443";
  }

  // Properties.
  protected final long channelId;
  protected final long tokenId;
  protected final long createdAt;
  protected final long revisedLifetime;

  public ChannelSecurityToken(long channelId, long tokenId, long createdAt, long revisedLifetime) {
    super();
    this.channelId = channelId;
    this.tokenId = tokenId;
    this.createdAt = createdAt;
    this.revisedLifetime = revisedLifetime;
  }

  public long getChannelId() {
    return channelId;
  }

  public long getTokenId() {
    return tokenId;
  }

  public long getCreatedAt() {
    return createdAt;
  }

  public long getRevisedLifetime() {
    return revisedLifetime;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("ChannelSecurityToken");

    // Simple Field (channelId)
    writeSimpleField("channelId", channelId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (tokenId)
    writeSimpleField("tokenId", tokenId, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (createdAt)
    writeSimpleField("createdAt", createdAt, writeSignedLong(writeBuffer, 64));

    // Simple Field (revisedLifetime)
    writeSimpleField("revisedLifetime", revisedLifetime, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("ChannelSecurityToken");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ChannelSecurityToken _value = this;

    // Simple field (channelId)
    lengthInBits += 32;

    // Simple field (tokenId)
    lengthInBits += 32;

    // Simple field (createdAt)
    lengthInBits += 64;

    // Simple field (revisedLifetime)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static ChannelSecurityTokenBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("ChannelSecurityToken");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    long channelId = readSimpleField("channelId", readUnsignedLong(readBuffer, 32));

    long tokenId = readSimpleField("tokenId", readUnsignedLong(readBuffer, 32));

    long createdAt = readSimpleField("createdAt", readSignedLong(readBuffer, 64));

    long revisedLifetime = readSimpleField("revisedLifetime", readUnsignedLong(readBuffer, 32));

    readBuffer.closeContext("ChannelSecurityToken");
    // Create the instance
    return new ChannelSecurityTokenBuilder(channelId, tokenId, createdAt, revisedLifetime);
  }

  public static class ChannelSecurityTokenBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long channelId;
    private final long tokenId;
    private final long createdAt;
    private final long revisedLifetime;

    public ChannelSecurityTokenBuilder(
        long channelId, long tokenId, long createdAt, long revisedLifetime) {

      this.channelId = channelId;
      this.tokenId = tokenId;
      this.createdAt = createdAt;
      this.revisedLifetime = revisedLifetime;
    }

    public ChannelSecurityToken build() {
      ChannelSecurityToken channelSecurityToken =
          new ChannelSecurityToken(channelId, tokenId, createdAt, revisedLifetime);
      return channelSecurityToken;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ChannelSecurityToken)) {
      return false;
    }
    ChannelSecurityToken that = (ChannelSecurityToken) o;
    return (getChannelId() == that.getChannelId())
        && (getTokenId() == that.getTokenId())
        && (getCreatedAt() == that.getCreatedAt())
        && (getRevisedLifetime() == that.getRevisedLifetime())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getChannelId(), getTokenId(), getCreatedAt(), getRevisedLifetime());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
