/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DataTypeDescription extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "14527";
  }

  // Properties.
  protected final NodeId dataTypeId;
  protected final QualifiedName name;

  public DataTypeDescription(NodeId dataTypeId, QualifiedName name) {
    super();
    this.dataTypeId = dataTypeId;
    this.name = name;
  }

  public NodeId getDataTypeId() {
    return dataTypeId;
  }

  public QualifiedName getName() {
    return name;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("DataTypeDescription");

    // Simple Field (dataTypeId)
    writeSimpleField("dataTypeId", dataTypeId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (name)
    writeSimpleField("name", name, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("DataTypeDescription");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DataTypeDescription _value = this;

    // Simple field (dataTypeId)
    lengthInBits += dataTypeId.getLengthInBits();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    return lengthInBits;
  }

  public static DataTypeDescriptionBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("DataTypeDescription");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    NodeId dataTypeId =
        readSimpleField(
            "dataTypeId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    QualifiedName name =
        readSimpleField(
            "name",
            new DataReaderComplexDefault<>(
                () -> QualifiedName.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("DataTypeDescription");
    // Create the instance
    return new DataTypeDescriptionBuilder(dataTypeId, name);
  }

  public static class DataTypeDescriptionBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId dataTypeId;
    private final QualifiedName name;

    public DataTypeDescriptionBuilder(NodeId dataTypeId, QualifiedName name) {

      this.dataTypeId = dataTypeId;
      this.name = name;
    }

    public DataTypeDescription build() {
      DataTypeDescription dataTypeDescription = new DataTypeDescription(dataTypeId, name);
      return dataTypeDescription;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DataTypeDescription)) {
      return false;
    }
    DataTypeDescription that = (DataTypeDescription) o;
    return (getDataTypeId() == that.getDataTypeId())
        && (getName() == that.getName())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getDataTypeId(), getName());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
