/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DeleteReferencesItem extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "387";
  }

  // Properties.
  protected final NodeId sourceNodeId;
  protected final NodeId referenceTypeId;
  protected final boolean isForward;
  protected final ExpandedNodeId targetNodeId;
  protected final boolean deleteBidirectional;
  // Reserved Fields
  private Short reservedField0;
  private Short reservedField1;

  public DeleteReferencesItem(
      NodeId sourceNodeId,
      NodeId referenceTypeId,
      boolean isForward,
      ExpandedNodeId targetNodeId,
      boolean deleteBidirectional) {
    super();
    this.sourceNodeId = sourceNodeId;
    this.referenceTypeId = referenceTypeId;
    this.isForward = isForward;
    this.targetNodeId = targetNodeId;
    this.deleteBidirectional = deleteBidirectional;
  }

  public NodeId getSourceNodeId() {
    return sourceNodeId;
  }

  public NodeId getReferenceTypeId() {
    return referenceTypeId;
  }

  public boolean getIsForward() {
    return isForward;
  }

  public ExpandedNodeId getTargetNodeId() {
    return targetNodeId;
  }

  public boolean getDeleteBidirectional() {
    return deleteBidirectional;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("DeleteReferencesItem");

    // Simple Field (sourceNodeId)
    writeSimpleField("sourceNodeId", sourceNodeId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (referenceTypeId)
    writeSimpleField(
        "referenceTypeId", referenceTypeId, new DataWriterComplexDefault<>(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (isForward)
    writeSimpleField("isForward", isForward, writeBoolean(writeBuffer));

    // Simple Field (targetNodeId)
    writeSimpleField("targetNodeId", targetNodeId, new DataWriterComplexDefault<>(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (deleteBidirectional)
    writeSimpleField("deleteBidirectional", deleteBidirectional, writeBoolean(writeBuffer));

    writeBuffer.popContext("DeleteReferencesItem");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DeleteReferencesItem _value = this;

    // Simple field (sourceNodeId)
    lengthInBits += sourceNodeId.getLengthInBits();

    // Simple field (referenceTypeId)
    lengthInBits += referenceTypeId.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (isForward)
    lengthInBits += 1;

    // Simple field (targetNodeId)
    lengthInBits += targetNodeId.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (deleteBidirectional)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static DeleteReferencesItemBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("DeleteReferencesItem");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    NodeId sourceNodeId =
        readSimpleField(
            "sourceNodeId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    NodeId referenceTypeId =
        readSimpleField(
            "referenceTypeId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean isForward = readSimpleField("isForward", readBoolean(readBuffer));

    ExpandedNodeId targetNodeId =
        readSimpleField(
            "targetNodeId",
            new DataReaderComplexDefault<>(
                () -> ExpandedNodeId.staticParse(readBuffer), readBuffer));

    Short reservedField1 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean deleteBidirectional = readSimpleField("deleteBidirectional", readBoolean(readBuffer));

    readBuffer.closeContext("DeleteReferencesItem");
    // Create the instance
    return new DeleteReferencesItemBuilder(
        sourceNodeId,
        referenceTypeId,
        isForward,
        targetNodeId,
        deleteBidirectional,
        reservedField0,
        reservedField1);
  }

  public static class DeleteReferencesItemBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final NodeId sourceNodeId;
    private final NodeId referenceTypeId;
    private final boolean isForward;
    private final ExpandedNodeId targetNodeId;
    private final boolean deleteBidirectional;
    private final Short reservedField0;
    private final Short reservedField1;

    public DeleteReferencesItemBuilder(
        NodeId sourceNodeId,
        NodeId referenceTypeId,
        boolean isForward,
        ExpandedNodeId targetNodeId,
        boolean deleteBidirectional,
        Short reservedField0,
        Short reservedField1) {
      this.sourceNodeId = sourceNodeId;
      this.referenceTypeId = referenceTypeId;
      this.isForward = isForward;
      this.targetNodeId = targetNodeId;
      this.deleteBidirectional = deleteBidirectional;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
    }

    public DeleteReferencesItem build() {
      DeleteReferencesItem deleteReferencesItem =
          new DeleteReferencesItem(
              sourceNodeId, referenceTypeId, isForward, targetNodeId, deleteBidirectional);
      deleteReferencesItem.reservedField0 = reservedField0;
      deleteReferencesItem.reservedField1 = reservedField1;
      return deleteReferencesItem;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DeleteReferencesItem)) {
      return false;
    }
    DeleteReferencesItem that = (DeleteReferencesItem) o;
    return (getSourceNodeId() == that.getSourceNodeId())
        && (getReferenceTypeId() == that.getReferenceTypeId())
        && (getIsForward() == that.getIsForward())
        && (getTargetNodeId() == that.getTargetNodeId())
        && (getDeleteBidirectional() == that.getDeleteBidirectional())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSourceNodeId(),
        getReferenceTypeId(),
        getIsForward(),
        getTargetNodeId(),
        getDeleteBidirectional());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
