/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HistoryUpdateResult extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "697";
  }

  // Properties.
  protected final StatusCode statusCode;
  protected final int noOfOperationResults;
  protected final List<StatusCode> operationResults;
  protected final int noOfDiagnosticInfos;
  protected final List<DiagnosticInfo> diagnosticInfos;

  public HistoryUpdateResult(
      StatusCode statusCode,
      int noOfOperationResults,
      List<StatusCode> operationResults,
      int noOfDiagnosticInfos,
      List<DiagnosticInfo> diagnosticInfos) {
    super();
    this.statusCode = statusCode;
    this.noOfOperationResults = noOfOperationResults;
    this.operationResults = operationResults;
    this.noOfDiagnosticInfos = noOfDiagnosticInfos;
    this.diagnosticInfos = diagnosticInfos;
  }

  public StatusCode getStatusCode() {
    return statusCode;
  }

  public int getNoOfOperationResults() {
    return noOfOperationResults;
  }

  public List<StatusCode> getOperationResults() {
    return operationResults;
  }

  public int getNoOfDiagnosticInfos() {
    return noOfDiagnosticInfos;
  }

  public List<DiagnosticInfo> getDiagnosticInfos() {
    return diagnosticInfos;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("HistoryUpdateResult");

    // Simple Field (statusCode)
    writeSimpleField("statusCode", statusCode, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfOperationResults)
    writeSimpleField("noOfOperationResults", noOfOperationResults, writeSignedInt(writeBuffer, 32));

    // Array Field (operationResults)
    writeComplexTypeArrayField("operationResults", operationResults, writeBuffer);

    // Simple Field (noOfDiagnosticInfos)
    writeSimpleField("noOfDiagnosticInfos", noOfDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (diagnosticInfos)
    writeComplexTypeArrayField("diagnosticInfos", diagnosticInfos, writeBuffer);

    writeBuffer.popContext("HistoryUpdateResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    HistoryUpdateResult _value = this;

    // Simple field (statusCode)
    lengthInBits += statusCode.getLengthInBits();

    // Simple field (noOfOperationResults)
    lengthInBits += 32;

    // Array field
    if (operationResults != null) {
      int i = 0;
      for (StatusCode element : operationResults) {
        boolean last = ++i >= operationResults.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (diagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : diagnosticInfos) {
        boolean last = ++i >= diagnosticInfos.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static HistoryUpdateResultBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("HistoryUpdateResult");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    StatusCode statusCode =
        readSimpleField(
            "statusCode",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer));

    int noOfOperationResults =
        readSimpleField("noOfOperationResults", readSignedInt(readBuffer, 32));

    List<StatusCode> operationResults =
        readCountArrayField(
            "operationResults",
            new DataReaderComplexDefault<>(() -> StatusCode.staticParse(readBuffer), readBuffer),
            noOfOperationResults);

    int noOfDiagnosticInfos = readSimpleField("noOfDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> diagnosticInfos =
        readCountArrayField(
            "diagnosticInfos",
            new DataReaderComplexDefault<>(
                () -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfDiagnosticInfos);

    readBuffer.closeContext("HistoryUpdateResult");
    // Create the instance
    return new HistoryUpdateResultBuilder(
        statusCode, noOfOperationResults, operationResults, noOfDiagnosticInfos, diagnosticInfos);
  }

  public static class HistoryUpdateResultBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final StatusCode statusCode;
    private final int noOfOperationResults;
    private final List<StatusCode> operationResults;
    private final int noOfDiagnosticInfos;
    private final List<DiagnosticInfo> diagnosticInfos;

    public HistoryUpdateResultBuilder(
        StatusCode statusCode,
        int noOfOperationResults,
        List<StatusCode> operationResults,
        int noOfDiagnosticInfos,
        List<DiagnosticInfo> diagnosticInfos) {

      this.statusCode = statusCode;
      this.noOfOperationResults = noOfOperationResults;
      this.operationResults = operationResults;
      this.noOfDiagnosticInfos = noOfDiagnosticInfos;
      this.diagnosticInfos = diagnosticInfos;
    }

    public HistoryUpdateResult build() {
      HistoryUpdateResult historyUpdateResult =
          new HistoryUpdateResult(
              statusCode,
              noOfOperationResults,
              operationResults,
              noOfDiagnosticInfos,
              diagnosticInfos);
      return historyUpdateResult;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HistoryUpdateResult)) {
      return false;
    }
    HistoryUpdateResult that = (HistoryUpdateResult) o;
    return (getStatusCode() == that.getStatusCode())
        && (getNoOfOperationResults() == that.getNoOfOperationResults())
        && (getOperationResults() == that.getOperationResults())
        && (getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos())
        && (getDiagnosticInfos() == that.getDiagnosticInfos())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getStatusCode(),
        getNoOfOperationResults(),
        getOperationResults(),
        getNoOfDiagnosticInfos(),
        getDiagnosticInfos());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
