/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NetworkGroupDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "11946";
  }

  // Properties.
  protected final PascalString serverUri;
  protected final int noOfNetworkPaths;
  protected final List<ExtensionObjectDefinition> networkPaths;

  public NetworkGroupDataType(
      PascalString serverUri, int noOfNetworkPaths, List<ExtensionObjectDefinition> networkPaths) {
    super();
    this.serverUri = serverUri;
    this.noOfNetworkPaths = noOfNetworkPaths;
    this.networkPaths = networkPaths;
  }

  public PascalString getServerUri() {
    return serverUri;
  }

  public int getNoOfNetworkPaths() {
    return noOfNetworkPaths;
  }

  public List<ExtensionObjectDefinition> getNetworkPaths() {
    return networkPaths;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("NetworkGroupDataType");

    // Simple Field (serverUri)
    writeSimpleField("serverUri", serverUri, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfNetworkPaths)
    writeSimpleField("noOfNetworkPaths", noOfNetworkPaths, writeSignedInt(writeBuffer, 32));

    // Array Field (networkPaths)
    writeComplexTypeArrayField("networkPaths", networkPaths, writeBuffer);

    writeBuffer.popContext("NetworkGroupDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NetworkGroupDataType _value = this;

    // Simple field (serverUri)
    lengthInBits += serverUri.getLengthInBits();

    // Simple field (noOfNetworkPaths)
    lengthInBits += 32;

    // Array field
    if (networkPaths != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : networkPaths) {
        boolean last = ++i >= networkPaths.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static NetworkGroupDataTypeBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("NetworkGroupDataType");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    PascalString serverUri =
        readSimpleField(
            "serverUri",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    int noOfNetworkPaths = readSimpleField("noOfNetworkPaths", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> networkPaths =
        readCountArrayField(
            "networkPaths",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("11945")),
                readBuffer),
            noOfNetworkPaths);

    readBuffer.closeContext("NetworkGroupDataType");
    // Create the instance
    return new NetworkGroupDataTypeBuilder(serverUri, noOfNetworkPaths, networkPaths);
  }

  public static class NetworkGroupDataTypeBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString serverUri;
    private final int noOfNetworkPaths;
    private final List<ExtensionObjectDefinition> networkPaths;

    public NetworkGroupDataTypeBuilder(
        PascalString serverUri,
        int noOfNetworkPaths,
        List<ExtensionObjectDefinition> networkPaths) {

      this.serverUri = serverUri;
      this.noOfNetworkPaths = noOfNetworkPaths;
      this.networkPaths = networkPaths;
    }

    public NetworkGroupDataType build() {
      NetworkGroupDataType networkGroupDataType =
          new NetworkGroupDataType(serverUri, noOfNetworkPaths, networkPaths);
      return networkGroupDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NetworkGroupDataType)) {
      return false;
    }
    NetworkGroupDataType that = (NetworkGroupDataType) o;
    return (getServerUri() == that.getServerUri())
        && (getNoOfNetworkPaths() == that.getNoOfNetworkPaths())
        && (getNetworkPaths() == that.getNetworkPaths())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getServerUri(), getNoOfNetworkPaths(), getNetworkPaths());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
