/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NotificationMessage extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "805";
  }

  // Properties.
  protected final long sequenceNumber;
  protected final long publishTime;
  protected final int noOfNotificationData;
  protected final List<ExtensionObject> notificationData;

  public NotificationMessage(
      long sequenceNumber,
      long publishTime,
      int noOfNotificationData,
      List<ExtensionObject> notificationData) {
    super();
    this.sequenceNumber = sequenceNumber;
    this.publishTime = publishTime;
    this.noOfNotificationData = noOfNotificationData;
    this.notificationData = notificationData;
  }

  public long getSequenceNumber() {
    return sequenceNumber;
  }

  public long getPublishTime() {
    return publishTime;
  }

  public int getNoOfNotificationData() {
    return noOfNotificationData;
  }

  public List<ExtensionObject> getNotificationData() {
    return notificationData;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("NotificationMessage");

    // Simple Field (sequenceNumber)
    writeSimpleField("sequenceNumber", sequenceNumber, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (publishTime)
    writeSimpleField("publishTime", publishTime, writeSignedLong(writeBuffer, 64));

    // Simple Field (noOfNotificationData)
    writeSimpleField("noOfNotificationData", noOfNotificationData, writeSignedInt(writeBuffer, 32));

    // Array Field (notificationData)
    writeComplexTypeArrayField("notificationData", notificationData, writeBuffer);

    writeBuffer.popContext("NotificationMessage");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NotificationMessage _value = this;

    // Simple field (sequenceNumber)
    lengthInBits += 32;

    // Simple field (publishTime)
    lengthInBits += 64;

    // Simple field (noOfNotificationData)
    lengthInBits += 32;

    // Array field
    if (notificationData != null) {
      int i = 0;
      for (ExtensionObject element : notificationData) {
        boolean last = ++i >= notificationData.size();
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static NotificationMessageBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("NotificationMessage");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    long sequenceNumber = readSimpleField("sequenceNumber", readUnsignedLong(readBuffer, 32));

    long publishTime = readSimpleField("publishTime", readSignedLong(readBuffer, 64));

    int noOfNotificationData =
        readSimpleField("noOfNotificationData", readSignedInt(readBuffer, 32));

    List<ExtensionObject> notificationData =
        readCountArrayField(
            "notificationData",
            new DataReaderComplexDefault<>(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer),
            noOfNotificationData);

    readBuffer.closeContext("NotificationMessage");
    // Create the instance
    return new NotificationMessageBuilder(
        sequenceNumber, publishTime, noOfNotificationData, notificationData);
  }

  public static class NotificationMessageBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long sequenceNumber;
    private final long publishTime;
    private final int noOfNotificationData;
    private final List<ExtensionObject> notificationData;

    public NotificationMessageBuilder(
        long sequenceNumber,
        long publishTime,
        int noOfNotificationData,
        List<ExtensionObject> notificationData) {

      this.sequenceNumber = sequenceNumber;
      this.publishTime = publishTime;
      this.noOfNotificationData = noOfNotificationData;
      this.notificationData = notificationData;
    }

    public NotificationMessage build() {
      NotificationMessage notificationMessage =
          new NotificationMessage(
              sequenceNumber, publishTime, noOfNotificationData, notificationData);
      return notificationMessage;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NotificationMessage)) {
      return false;
    }
    NotificationMessage that = (NotificationMessage) o;
    return (getSequenceNumber() == that.getSequenceNumber())
        && (getPublishTime() == that.getPublishTime())
        && (getNoOfNotificationData() == that.getNoOfNotificationData())
        && (getNotificationData() == that.getNotificationData())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSequenceNumber(),
        getPublishTime(),
        getNoOfNotificationData(),
        getNotificationData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
