/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SetPublishingModeRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "799";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final boolean publishingEnabled;
  protected final int noOfSubscriptionIds;
  protected final List<Long> subscriptionIds;
  // Reserved Fields
  private Short reservedField0;

  public SetPublishingModeRequest(
      ExtensionObjectDefinition requestHeader,
      boolean publishingEnabled,
      int noOfSubscriptionIds,
      List<Long> subscriptionIds) {
    super();
    this.requestHeader = requestHeader;
    this.publishingEnabled = publishingEnabled;
    this.noOfSubscriptionIds = noOfSubscriptionIds;
    this.subscriptionIds = subscriptionIds;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public boolean getPublishingEnabled() {
    return publishingEnabled;
  }

  public int getNoOfSubscriptionIds() {
    return noOfSubscriptionIds;
  }

  public List<Long> getSubscriptionIds() {
    return subscriptionIds;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("SetPublishingModeRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 7));

    // Simple Field (publishingEnabled)
    writeSimpleField("publishingEnabled", publishingEnabled, writeBoolean(writeBuffer));

    // Simple Field (noOfSubscriptionIds)
    writeSimpleField("noOfSubscriptionIds", noOfSubscriptionIds, writeSignedInt(writeBuffer, 32));

    // Array Field (subscriptionIds)
    writeSimpleTypeArrayField(
        "subscriptionIds", subscriptionIds, writeUnsignedLong(writeBuffer, 32));

    writeBuffer.popContext("SetPublishingModeRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SetPublishingModeRequest _value = this;

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (publishingEnabled)
    lengthInBits += 1;

    // Simple field (noOfSubscriptionIds)
    lengthInBits += 32;

    // Array field
    if (subscriptionIds != null) {
      lengthInBits += 32 * subscriptionIds.size();
    }

    return lengthInBits;
  }

  public static SetPublishingModeRequestBuilder staticParseBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("SetPublishingModeRequest");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    Short reservedField0 =
        readReservedField("reserved", readUnsignedShort(readBuffer, 7), (short) 0x00);

    boolean publishingEnabled = readSimpleField("publishingEnabled", readBoolean(readBuffer));

    int noOfSubscriptionIds = readSimpleField("noOfSubscriptionIds", readSignedInt(readBuffer, 32));

    List<Long> subscriptionIds =
        readCountArrayField(
            "subscriptionIds", readUnsignedLong(readBuffer, 32), noOfSubscriptionIds);

    readBuffer.closeContext("SetPublishingModeRequest");
    // Create the instance
    return new SetPublishingModeRequestBuilder(
        requestHeader, publishingEnabled, noOfSubscriptionIds, subscriptionIds, reservedField0);
  }

  public static class SetPublishingModeRequestBuilder
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final boolean publishingEnabled;
    private final int noOfSubscriptionIds;
    private final List<Long> subscriptionIds;
    private final Short reservedField0;

    public SetPublishingModeRequestBuilder(
        ExtensionObjectDefinition requestHeader,
        boolean publishingEnabled,
        int noOfSubscriptionIds,
        List<Long> subscriptionIds,
        Short reservedField0) {
      this.requestHeader = requestHeader;
      this.publishingEnabled = publishingEnabled;
      this.noOfSubscriptionIds = noOfSubscriptionIds;
      this.subscriptionIds = subscriptionIds;
      this.reservedField0 = reservedField0;
    }

    public SetPublishingModeRequest build() {
      SetPublishingModeRequest setPublishingModeRequest =
          new SetPublishingModeRequest(
              requestHeader, publishingEnabled, noOfSubscriptionIds, subscriptionIds);
      setPublishingModeRequest.reservedField0 = reservedField0;
      return setPublishingModeRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SetPublishingModeRequest)) {
      return false;
    }
    SetPublishingModeRequest that = (SetPublishingModeRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getPublishingEnabled() == that.getPublishingEnabled())
        && (getNoOfSubscriptionIds() == that.getNoOfSubscriptionIds())
        && (getSubscriptionIds() == that.getSubscriptionIds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getPublishingEnabled(),
        getNoOfSubscriptionIds(),
        getSubscriptionIds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
