/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class Variant implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getVariantType();

  // Properties.
  protected final boolean arrayLengthSpecified;
  protected final boolean arrayDimensionsSpecified;
  protected final Integer noOfArrayDimensions;
  protected final List<Boolean> arrayDimensions;

  public Variant(
      boolean arrayLengthSpecified,
      boolean arrayDimensionsSpecified,
      Integer noOfArrayDimensions,
      List<Boolean> arrayDimensions) {
    super();
    this.arrayLengthSpecified = arrayLengthSpecified;
    this.arrayDimensionsSpecified = arrayDimensionsSpecified;
    this.noOfArrayDimensions = noOfArrayDimensions;
    this.arrayDimensions = arrayDimensions;
  }

  public boolean getArrayLengthSpecified() {
    return arrayLengthSpecified;
  }

  public boolean getArrayDimensionsSpecified() {
    return arrayDimensionsSpecified;
  }

  public Integer getNoOfArrayDimensions() {
    return noOfArrayDimensions;
  }

  public List<Boolean> getArrayDimensions() {
    return arrayDimensions;
  }

  protected abstract void serializeVariantChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    int startPos = positionAware.getPos();
    writeBuffer.pushContext("Variant");

    // Simple Field (arrayLengthSpecified)
    writeSimpleField("arrayLengthSpecified", arrayLengthSpecified, writeBoolean(writeBuffer));

    // Simple Field (arrayDimensionsSpecified)
    writeSimpleField(
        "arrayDimensionsSpecified", arrayDimensionsSpecified, writeBoolean(writeBuffer));

    // Discriminator Field (VariantType) (Used as input to a switch field)
    writeDiscriminatorField("VariantType", getVariantType(), writeUnsignedShort(writeBuffer, 6));

    // Switch field (Serialize the sub-type)
    serializeVariantChild(writeBuffer);

    // Optional Field (noOfArrayDimensions) (Can be skipped, if the value is null)
    writeOptionalField(
        "noOfArrayDimensions",
        noOfArrayDimensions,
        writeSignedInt(writeBuffer, 32),
        getArrayDimensionsSpecified());

    // Array Field (arrayDimensions)
    writeSimpleTypeArrayField("arrayDimensions", arrayDimensions, writeBoolean(writeBuffer));

    writeBuffer.popContext("Variant");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    Variant _value = this;

    // Simple field (arrayLengthSpecified)
    lengthInBits += 1;

    // Simple field (arrayDimensionsSpecified)
    lengthInBits += 1;

    // Discriminator Field (VariantType)
    lengthInBits += 6;

    // Length of sub-type elements will be added by sub-type...

    // Optional Field (noOfArrayDimensions)
    if (noOfArrayDimensions != null) {
      lengthInBits += 32;
    }

    // Array field
    if (arrayDimensions != null) {
      lengthInBits += 1 * arrayDimensions.size();
    }

    return lengthInBits;
  }

  public static Variant staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static Variant staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("Variant");
    PositionAware positionAware = readBuffer;
    int startPos = positionAware.getPos();
    int curPos;

    boolean arrayLengthSpecified = readSimpleField("arrayLengthSpecified", readBoolean(readBuffer));

    boolean arrayDimensionsSpecified =
        readSimpleField("arrayDimensionsSpecified", readBoolean(readBuffer));

    short VariantType = readDiscriminatorField("VariantType", readUnsignedShort(readBuffer, 6));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    VariantBuilder builder = null;
    if (EvaluationHelper.equals(VariantType, (short) 1)) {
      builder = VariantBoolean.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 2)) {
      builder = VariantSByte.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 3)) {
      builder = VariantByte.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 4)) {
      builder = VariantInt16.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 5)) {
      builder = VariantUInt16.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 6)) {
      builder = VariantInt32.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 7)) {
      builder = VariantUInt32.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 8)) {
      builder = VariantInt64.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 9)) {
      builder = VariantUInt64.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 10)) {
      builder = VariantFloat.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 11)) {
      builder = VariantDouble.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 12)) {
      builder = VariantString.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 13)) {
      builder = VariantDateTime.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 14)) {
      builder = VariantGuid.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 15)) {
      builder = VariantByteString.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 16)) {
      builder = VariantXmlElement.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 17)) {
      builder = VariantNodeId.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 18)) {
      builder = VariantExpandedNodeId.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 19)) {
      builder = VariantStatusCode.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 20)) {
      builder = VariantQualifiedName.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 21)) {
      builder = VariantLocalizedText.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 22)) {
      builder = VariantExtensionObject.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 23)) {
      builder = VariantDataValue.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 24)) {
      builder = VariantVariant.staticParseBuilder(readBuffer, arrayLengthSpecified);
    } else if (EvaluationHelper.equals(VariantType, (short) 25)) {
      builder = VariantDiagnosticInfo.staticParseBuilder(readBuffer, arrayLengthSpecified);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "VariantType="
              + VariantType
              + " "
              + "arrayLengthSpecified="
              + arrayLengthSpecified
              + "]");
    }

    Integer noOfArrayDimensions =
        readOptionalField(
            "noOfArrayDimensions", readSignedInt(readBuffer, 32), arrayDimensionsSpecified);

    List<Boolean> arrayDimensions =
        readCountArrayField(
            "arrayDimensions",
            readBoolean(readBuffer),
            (((noOfArrayDimensions) == (null)) ? 0 : noOfArrayDimensions));

    readBuffer.closeContext("Variant");
    // Create the instance
    Variant _variant =
        builder.build(
            arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
    return _variant;
  }

  public static interface VariantBuilder {
    Variant build(
        boolean arrayLengthSpecified,
        boolean arrayDimensionsSpecified,
        Integer noOfArrayDimensions,
        List<Boolean> arrayDimensions);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Variant)) {
      return false;
    }
    Variant that = (Variant) o;
    return (getArrayLengthSpecified() == that.getArrayLengthSpecified())
        && (getArrayDimensionsSpecified() == that.getArrayDimensionsSpecified())
        && (getNoOfArrayDimensions() == that.getNoOfArrayDimensions())
        && (getArrayDimensions() == that.getArrayDimensions())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getArrayLengthSpecified(),
        getArrayDimensionsSpecified(),
        getNoOfArrayDimensions(),
        getArrayDimensions());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
