/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua;

import io.netty.buffer.ByteBuf;
import java.util.ServiceLoader;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.PlcConnection;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.field.OpcuaField;
import org.apache.plc4x.java.opcua.field.OpcuaPlcFieldHandler;
import org.apache.plc4x.java.opcua.optimizer.OpcuaOptimizer;
import org.apache.plc4x.java.opcua.protocol.OpcuaProtocolLogic;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.connection.DefaultNettyPlcConnection;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.PlcFieldHandler;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.spi.values.IEC61131ValueHandler;

public class OpcuaPlcDriver
extends GeneratedDriverBase<OpcuaAPU> {
    public static final Pattern INET_ADDRESS_PATTERN = Pattern.compile("(:(?<transportCode>[a-z0-9]*))?://(?<transportHost>[\\w.-]+)(:(?<transportPort>\\d*))?");
    public static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>opcua)" + INET_ADDRESS_PATTERN + "(?<transportEndpoint>[\\w/=]*)[\\?]?(?<paramString>([^\\=]+\\=[^\\=&]+[&]?)*)");
    private boolean isEncrypted;

    public String getProtocolCode() {
        return "opcua";
    }

    public String getProtocolName() {
        return "Opcua";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return OpcuaConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "tcp";
    }

    protected boolean awaitSetupComplete() {
        return true;
    }

    protected boolean awaitDiscoverComplete() {
        return this.isEncrypted;
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected boolean canBrowse() {
        return false;
    }

    protected OpcuaOptimizer getOptimizer() {
        return new OpcuaOptimizer();
    }

    protected OpcuaPlcFieldHandler getFieldHandler() {
        return new OpcuaPlcFieldHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new IEC61131ValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return true;
    }

    protected ProtocolStackConfigurer<OpcuaAPU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(OpcuaAPU.class, OpcuaAPU::staticParse).withProtocol(OpcuaProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(new Object[]{true}).littleEndian().build();
    }

    public PlcConnection getConnection(String connectionString) throws PlcConnectionException {
        Matcher matcher = URI_PATTERN.matcher(connectionString);
        if (!matcher.matches()) {
            throw new PlcConnectionException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-host}(:{transport-port})(/{transport-endpoint})(?{parameter-string)?'");
        }
        String protocolCode = matcher.group("protocolCode");
        String transportCode = matcher.group("transportCode") != null ? matcher.group("transportCode") : this.getDefaultTransport();
        String transportHost = matcher.group("transportHost");
        String transportPort = matcher.group("transportPort");
        String transportEndpoint = matcher.group("transportEndpoint");
        String paramString = matcher.group("paramString");
        if (!protocolCode.equals(this.getProtocolCode())) {
            throw new PlcConnectionException("This driver is not suited to handle this connection string");
        }
        OpcuaConfiguration configuration = (OpcuaConfiguration)new ConfigurationFactory().createConfiguration(this.getConfigurationType(), paramString);
        if (configuration == null) {
            throw new PlcConnectionException("Unsupported configuration");
        }
        configuration.setTransportCode(transportCode);
        configuration.setHost(transportHost);
        configuration.setPort(transportPort);
        configuration.setTransportEndpoint(transportEndpoint);
        configuration.setEndpoint("opc." + transportCode + "://" + transportHost + ":" + transportPort + "" + transportEndpoint);
        Transport transport = null;
        ServiceLoader<Transport> transportLoader = ServiceLoader.load(Transport.class, Thread.currentThread().getContextClassLoader());
        for (Transport curTransport : transportLoader) {
            if (!curTransport.getTransportCode().equals(transportCode)) continue;
            transport = curTransport;
            break;
        }
        if (transport == null) {
            throw new PlcConnectionException("Unsupported transport " + transportCode);
        }
        ConfigurationFactory.configure((Configuration)configuration, transport);
        ChannelFactory channelFactory = transport.createChannelFactory(transportHost + ":" + transportPort);
        if (channelFactory == null) {
            throw new PlcConnectionException("Unable to get channel factory from url " + transportHost + ":" + transportPort);
        }
        ConfigurationFactory.configure((Configuration)configuration, (Object)channelFactory);
        this.initializePipeline(channelFactory);
        boolean awaitSetupComplete = this.awaitSetupComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_SETUP_COMPLETE") != null) {
            awaitSetupComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_SETUP_COMPLETE"));
        }
        boolean awaitDisconnectComplete = this.awaitDisconnectComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE") != null) {
            awaitDisconnectComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_DISCONNECT_COMPLETE"));
        }
        if (configuration.getSecurityPolicy() != null && !configuration.getSecurityPolicy().equals("None")) {
            try {
                configuration.openKeyStore();
            }
            catch (Exception e) {
                throw new PlcConnectionException("Unable to open keystore, please confirm you have the correct permissions");
            }
        }
        this.isEncrypted = configuration.isEncrypted();
        boolean awaitDiscoverComplete = this.awaitDiscoverComplete();
        if (System.getProperty("PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE") != null) {
            awaitDiscoverComplete = Boolean.parseBoolean(System.getProperty("PLC4X_FORCE_AWAIT_DISCOVER_COMPLETE"));
        }
        return new DefaultNettyPlcConnection(this.canRead(), this.canWrite(), this.canSubscribe(), this.canBrowse(), (PlcFieldHandler)this.getFieldHandler(), this.getValueHandler(), (Configuration)configuration, channelFactory, awaitSetupComplete, awaitDisconnectComplete, awaitDiscoverComplete, this.getStackConfigurer(), (BaseOptimizer)this.getOptimizer(), null);
    }

    public OpcuaField prepareField(String query) {
        return OpcuaField.of(query);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 8) {
                return Integer.reverseBytes(byteBuf.getInt(byteBuf.readerIndex() + 4));
            }
            return -1;
        }
    }
}

