/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CallMethodResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final int noOfInputArgumentResults;
    protected final List<StatusCode> inputArgumentResults;
    protected final int noOfInputArgumentDiagnosticInfos;
    protected final List<DiagnosticInfo> inputArgumentDiagnosticInfos;
    protected final int noOfOutputArguments;
    protected final List<Variant> outputArguments;

    @Override
    public String getIdentifier() {
        return "709";
    }

    public CallMethodResult(StatusCode statusCode, int noOfInputArgumentResults, List<StatusCode> inputArgumentResults, int noOfInputArgumentDiagnosticInfos, List<DiagnosticInfo> inputArgumentDiagnosticInfos, int noOfOutputArguments, List<Variant> outputArguments) {
        this.statusCode = statusCode;
        this.noOfInputArgumentResults = noOfInputArgumentResults;
        this.inputArgumentResults = inputArgumentResults;
        this.noOfInputArgumentDiagnosticInfos = noOfInputArgumentDiagnosticInfos;
        this.inputArgumentDiagnosticInfos = inputArgumentDiagnosticInfos;
        this.noOfOutputArguments = noOfOutputArguments;
        this.outputArguments = outputArguments;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public int getNoOfInputArgumentResults() {
        return this.noOfInputArgumentResults;
    }

    public List<StatusCode> getInputArgumentResults() {
        return this.inputArgumentResults;
    }

    public int getNoOfInputArgumentDiagnosticInfos() {
        return this.noOfInputArgumentDiagnosticInfos;
    }

    public List<DiagnosticInfo> getInputArgumentDiagnosticInfos() {
        return this.inputArgumentDiagnosticInfos;
    }

    public int getNoOfOutputArguments() {
        return this.noOfOutputArguments;
    }

    public List<Variant> getOutputArguments() {
        return this.outputArguments;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("CallMethodResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfInputArgumentResults", (Object)this.noOfInputArgumentResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"inputArgumentResults", this.inputArgumentResults, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfInputArgumentDiagnosticInfos", (Object)this.noOfInputArgumentDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"inputArgumentDiagnosticInfos", this.inputArgumentDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfOutputArguments", (Object)this.noOfOutputArguments, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"outputArguments", this.outputArguments, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CallMethodResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        boolean last;
        int i;
        int lengthInBits = super.getLengthInBits();
        CallMethodResult _value = this;
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.inputArgumentResults != null) {
            i = 0;
            for (StatusCode statusCode : this.inputArgumentResults) {
                last = ++i >= this.inputArgumentResults.size();
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.inputArgumentDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.inputArgumentDiagnosticInfos) {
                last = ++i >= this.inputArgumentDiagnosticInfos.size();
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.outputArguments != null) {
            i = 0;
            for (Variant variant : this.outputArguments) {
                last = ++i >= this.outputArguments.size();
                lengthInBits += variant.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static CallMethodResultBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("CallMethodResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)new DataReaderComplexDefault(() -> StatusCode.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfInputArgumentResults = (Integer)FieldReaderFactory.readSimpleField((String)"noOfInputArgumentResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List inputArgumentResults = FieldReaderFactory.readCountArrayField((String)"inputArgumentResults", (DataReader)new DataReaderComplexDefault(() -> StatusCode.staticParse(readBuffer), readBuffer), (long)noOfInputArgumentResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfInputArgumentDiagnosticInfos = (Integer)FieldReaderFactory.readSimpleField((String)"noOfInputArgumentDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List inputArgumentDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"inputArgumentDiagnosticInfos", (DataReader)new DataReaderComplexDefault(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), (long)noOfInputArgumentDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfOutputArguments = (Integer)FieldReaderFactory.readSimpleField((String)"noOfOutputArguments", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List outputArguments = FieldReaderFactory.readCountArrayField((String)"outputArguments", (DataReader)new DataReaderComplexDefault(() -> Variant.staticParse(readBuffer), readBuffer), (long)noOfOutputArguments, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CallMethodResult", new WithReaderArgs[0]);
        return new CallMethodResultBuilder(statusCode, noOfInputArgumentResults, inputArgumentResults, noOfInputArgumentDiagnosticInfos, inputArgumentDiagnosticInfos, noOfOutputArguments, outputArguments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallMethodResult)) {
            return false;
        }
        CallMethodResult that = (CallMethodResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getNoOfInputArgumentResults() == that.getNoOfInputArgumentResults() && this.getInputArgumentResults() == that.getInputArgumentResults() && this.getNoOfInputArgumentDiagnosticInfos() == that.getNoOfInputArgumentDiagnosticInfos() && this.getInputArgumentDiagnosticInfos() == that.getInputArgumentDiagnosticInfos() && this.getNoOfOutputArguments() == that.getNoOfOutputArguments() && this.getOutputArguments() == that.getOutputArguments() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getNoOfInputArgumentResults(), this.getInputArgumentResults(), this.getNoOfInputArgumentDiagnosticInfos(), this.getInputArgumentDiagnosticInfos(), this.getNoOfOutputArguments(), this.getOutputArguments());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CallMethodResultBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final int noOfInputArgumentResults;
        private final List<StatusCode> inputArgumentResults;
        private final int noOfInputArgumentDiagnosticInfos;
        private final List<DiagnosticInfo> inputArgumentDiagnosticInfos;
        private final int noOfOutputArguments;
        private final List<Variant> outputArguments;

        public CallMethodResultBuilder(StatusCode statusCode, int noOfInputArgumentResults, List<StatusCode> inputArgumentResults, int noOfInputArgumentDiagnosticInfos, List<DiagnosticInfo> inputArgumentDiagnosticInfos, int noOfOutputArguments, List<Variant> outputArguments) {
            this.statusCode = statusCode;
            this.noOfInputArgumentResults = noOfInputArgumentResults;
            this.inputArgumentResults = inputArgumentResults;
            this.noOfInputArgumentDiagnosticInfos = noOfInputArgumentDiagnosticInfos;
            this.inputArgumentDiagnosticInfos = inputArgumentDiagnosticInfos;
            this.noOfOutputArguments = noOfOutputArguments;
            this.outputArguments = outputArguments;
        }

        @Override
        public CallMethodResult build() {
            CallMethodResult callMethodResult = new CallMethodResult(this.statusCode, this.noOfInputArgumentResults, this.inputArgumentResults, this.noOfInputArgumentDiagnosticInfos, this.inputArgumentDiagnosticInfos, this.noOfOutputArguments, this.outputArguments);
            return callMethodResult;
        }
    }
}

