/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ContentFilter
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfElements;
    protected final List<ExtensionObjectDefinition> elements;

    @Override
    public String getIdentifier() {
        return "588";
    }

    public ContentFilter(int noOfElements, List<ExtensionObjectDefinition> elements) {
        this.noOfElements = noOfElements;
        this.elements = elements;
    }

    public int getNoOfElements() {
        return this.noOfElements;
    }

    public List<ExtensionObjectDefinition> getElements() {
        return this.elements;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ContentFilter", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfElements", (Object)this.noOfElements, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"elements", this.elements, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ContentFilter", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ContentFilter _value = this;
        lengthInBits += 32;
        if (this.elements != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.elements) {
                boolean last = ++i >= this.elements.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ContentFilterBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ContentFilter", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        int noOfElements = (Integer)FieldReaderFactory.readSimpleField((String)"noOfElements", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List elements = FieldReaderFactory.readCountArrayField((String)"elements", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "585"), readBuffer), (long)noOfElements, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ContentFilter", new WithReaderArgs[0]);
        return new ContentFilterBuilder(noOfElements, elements);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentFilter)) {
            return false;
        }
        ContentFilter that = (ContentFilter)o;
        return this.getNoOfElements() == that.getNoOfElements() && this.getElements() == that.getElements() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfElements(), this.getElements());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ContentFilterBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfElements;
        private final List<ExtensionObjectDefinition> elements;

        public ContentFilterBuilder(int noOfElements, List<ExtensionObjectDefinition> elements) {
            this.noOfElements = noOfElements;
            this.elements = elements;
        }

        @Override
        public ContentFilter build() {
            ContentFilter contentFilter = new ContentFilter(this.noOfElements, this.elements);
            return contentFilter;
        }
    }
}

