/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTypeDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ExpandedNodeId
implements Message {
    protected final boolean namespaceURISpecified;
    protected final boolean serverIndexSpecified;
    protected final NodeIdTypeDefinition nodeId;
    protected final PascalString namespaceURI;
    protected final Long serverIndex;

    public ExpandedNodeId(boolean namespaceURISpecified, boolean serverIndexSpecified, NodeIdTypeDefinition nodeId, PascalString namespaceURI, Long serverIndex) {
        this.namespaceURISpecified = namespaceURISpecified;
        this.serverIndexSpecified = serverIndexSpecified;
        this.nodeId = nodeId;
        this.namespaceURI = namespaceURI;
        this.serverIndex = serverIndex;
    }

    public boolean getNamespaceURISpecified() {
        return this.namespaceURISpecified;
    }

    public boolean getServerIndexSpecified() {
        return this.serverIndexSpecified;
    }

    public NodeIdTypeDefinition getNodeId() {
        return this.nodeId;
    }

    public PascalString getNamespaceURI() {
        return this.namespaceURI;
    }

    public Long getServerIndex() {
        return this.serverIndex;
    }

    public String getIdentifier() {
        return String.valueOf(this.getNodeId().getIdentifier());
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("ExpandedNodeId", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"namespaceURISpecified", (Object)this.namespaceURISpecified, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serverIndexSpecified", (Object)this.serverIndexSpecified, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"nodeId", (Object)this.nodeId, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", (Object)identifier, new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"namespaceURI", (Object)this.namespaceURI, (DataWriter)new DataWriterComplexDefault(writeBuffer), (boolean)this.getNamespaceURISpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"serverIndex", (Object)this.serverIndex, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (boolean)this.getServerIndexSpecified(), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ExpandedNodeId", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        ExpandedNodeId _value = this;
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += this.nodeId.getLengthInBits();
        if (this.namespaceURI != null) {
            lengthInBits += this.namespaceURI.getLengthInBits();
        }
        if (this.serverIndex != null) {
            lengthInBits += 32;
        }
        return lengthInBits;
    }

    public static ExpandedNodeId staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return ExpandedNodeId.staticParse(readBuffer);
    }

    public static ExpandedNodeId staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ExpandedNodeId", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        boolean namespaceURISpecified = (Boolean)FieldReaderFactory.readSimpleField((String)"namespaceURISpecified", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        boolean serverIndexSpecified = (Boolean)FieldReaderFactory.readSimpleField((String)"serverIndexSpecified", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeIdTypeDefinition nodeId = (NodeIdTypeDefinition)FieldReaderFactory.readSimpleField((String)"nodeId", (DataReader)new DataReaderComplexDefault(() -> NodeIdTypeDefinition.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        String identifier = (String)FieldReaderFactory.readVirtualField((String)"identifier", String.class, (Object)nodeId.getIdentifier(), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString namespaceURI = (PascalString)FieldReaderFactory.readOptionalField((String)"namespaceURI", (DataReader)new DataReaderComplexDefault(() -> PascalString.staticParse(readBuffer), readBuffer), (boolean)namespaceURISpecified, (WithReaderArgs[])new WithReaderArgs[0]);
        Long serverIndex = (Long)FieldReaderFactory.readOptionalField((String)"serverIndex", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (boolean)serverIndexSpecified, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ExpandedNodeId", new WithReaderArgs[0]);
        ExpandedNodeId _expandedNodeId = new ExpandedNodeId(namespaceURISpecified, serverIndexSpecified, nodeId, namespaceURI, serverIndex);
        return _expandedNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExpandedNodeId)) {
            return false;
        }
        ExpandedNodeId that = (ExpandedNodeId)o;
        return this.getNamespaceURISpecified() == that.getNamespaceURISpecified() && this.getServerIndexSpecified() == that.getServerIndexSpecified() && this.getNodeId() == that.getNodeId() && this.getNamespaceURI() == that.getNamespaceURI() && this.getServerIndex() == that.getServerIndex();
    }

    public int hashCode() {
        return Objects.hash(this.getNamespaceURISpecified(), this.getServerIndexSpecified(), this.getNodeId(), this.getNamespaceURI(), this.getServerIndex());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

