/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryReadResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final PascalByteString continuationPoint;
    protected final ExtensionObject historyData;

    @Override
    public String getIdentifier() {
        return "640";
    }

    public HistoryReadResult(StatusCode statusCode, PascalByteString continuationPoint, ExtensionObject historyData) {
        this.statusCode = statusCode;
        this.continuationPoint = continuationPoint;
        this.historyData = historyData;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public PascalByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public ExtensionObject getHistoryData() {
        return this.historyData;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("HistoryReadResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"continuationPoint", (Object)this.continuationPoint, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"historyData", (Object)this.historyData, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryReadResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryReadResult _value = this;
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += this.continuationPoint.getLengthInBits();
        return lengthInBits += this.historyData.getLengthInBits();
    }

    public static HistoryReadResultBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("HistoryReadResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)new DataReaderComplexDefault(() -> StatusCode.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString continuationPoint = (PascalByteString)FieldReaderFactory.readSimpleField((String)"continuationPoint", (DataReader)new DataReaderComplexDefault(() -> PascalByteString.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject historyData = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"historyData", (DataReader)new DataReaderComplexDefault(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryReadResult", new WithReaderArgs[0]);
        return new HistoryReadResultBuilder(statusCode, continuationPoint, historyData);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryReadResult)) {
            return false;
        }
        HistoryReadResult that = (HistoryReadResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getContinuationPoint() == that.getContinuationPoint() && this.getHistoryData() == that.getHistoryData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getContinuationPoint(), this.getHistoryData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryReadResultBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final PascalByteString continuationPoint;
        private final ExtensionObject historyData;

        public HistoryReadResultBuilder(StatusCode statusCode, PascalByteString continuationPoint, ExtensionObject historyData) {
            this.statusCode = statusCode;
            this.continuationPoint = continuationPoint;
            this.historyData = historyData;
        }

        @Override
        public HistoryReadResult build() {
            HistoryReadResult historyReadResult = new HistoryReadResult(this.statusCode, this.continuationPoint, this.historyData);
            return historyReadResult;
        }
    }
}

