/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PublishRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfSubscriptionAcknowledgements;
    protected final List<ExtensionObjectDefinition> subscriptionAcknowledgements;

    @Override
    public String getIdentifier() {
        return "826";
    }

    public PublishRequest(ExtensionObjectDefinition requestHeader, int noOfSubscriptionAcknowledgements, List<ExtensionObjectDefinition> subscriptionAcknowledgements) {
        this.requestHeader = requestHeader;
        this.noOfSubscriptionAcknowledgements = noOfSubscriptionAcknowledgements;
        this.subscriptionAcknowledgements = subscriptionAcknowledgements;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfSubscriptionAcknowledgements() {
        return this.noOfSubscriptionAcknowledgements;
    }

    public List<ExtensionObjectDefinition> getSubscriptionAcknowledgements() {
        return this.subscriptionAcknowledgements;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("PublishRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfSubscriptionAcknowledgements", (Object)this.noOfSubscriptionAcknowledgements, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"subscriptionAcknowledgements", this.subscriptionAcknowledgements, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PublishRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        PublishRequest _value = this;
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.subscriptionAcknowledgements != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.subscriptionAcknowledgements) {
                boolean last = ++i >= this.subscriptionAcknowledgements.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static PublishRequestBuilder staticParseBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("PublishRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        ExtensionObjectDefinition requestHeader = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSubscriptionAcknowledgements = (Integer)FieldReaderFactory.readSimpleField((String)"noOfSubscriptionAcknowledgements", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List subscriptionAcknowledgements = FieldReaderFactory.readCountArrayField((String)"subscriptionAcknowledgements", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "823"), readBuffer), (long)noOfSubscriptionAcknowledgements, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PublishRequest", new WithReaderArgs[0]);
        return new PublishRequestBuilder(requestHeader, noOfSubscriptionAcknowledgements, subscriptionAcknowledgements);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishRequest)) {
            return false;
        }
        PublishRequest that = (PublishRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfSubscriptionAcknowledgements() == that.getNoOfSubscriptionAcknowledgements() && this.getSubscriptionAcknowledgements() == that.getSubscriptionAcknowledgements() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfSubscriptionAcknowledgements(), this.getSubscriptionAcknowledgements());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PublishRequestBuilder
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfSubscriptionAcknowledgements;
        private final List<ExtensionObjectDefinition> subscriptionAcknowledgements;

        public PublishRequestBuilder(ExtensionObjectDefinition requestHeader, int noOfSubscriptionAcknowledgements, List<ExtensionObjectDefinition> subscriptionAcknowledgements) {
            this.requestHeader = requestHeader;
            this.noOfSubscriptionAcknowledgements = noOfSubscriptionAcknowledgements;
            this.subscriptionAcknowledgements = subscriptionAcknowledgements;
        }

        @Override
        public PublishRequest build() {
            PublishRequest publishRequest = new PublishRequest(this.requestHeader, this.noOfSubscriptionAcknowledgements, this.subscriptionAcknowledgements);
            return publishRequest;
        }
    }
}

