/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.QualifiedName;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class VariantQualifiedName
extends Variant
implements Message {
    protected final Integer arrayLength;
    protected final List<QualifiedName> value;

    @Override
    public Short getVariantType() {
        return (short)20;
    }

    public VariantQualifiedName(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions, Integer arrayLength, List<QualifiedName> value) {
        super(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
        this.arrayLength = arrayLength;
        this.value = value;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public List<QualifiedName> getValue() {
        return this.value;
    }

    @Override
    protected void serializeVariantChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        int startPos = positionAware.getPos();
        writeBuffer.pushContext("VariantQualifiedName", new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"arrayLength", (Object)this.arrayLength, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (boolean)this.arrayLengthSpecified, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"value", this.value, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("VariantQualifiedName", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        VariantQualifiedName _value = this;
        if (this.arrayLength != null) {
            lengthInBits += 32;
        }
        if (this.value != null) {
            int i = 0;
            for (QualifiedName element : this.value) {
                boolean last = ++i >= this.value.size();
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static VariantQualifiedNameBuilder staticParseBuilder(ReadBuffer readBuffer, Boolean arrayLengthSpecified) throws ParseException {
        readBuffer.pullContext("VariantQualifiedName", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        int startPos = positionAware.getPos();
        Integer arrayLength = (Integer)FieldReaderFactory.readOptionalField((String)"arrayLength", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (boolean)arrayLengthSpecified, (WithReaderArgs[])new WithReaderArgs[0]);
        List value = FieldReaderFactory.readCountArrayField((String)"value", (DataReader)new DataReaderComplexDefault(() -> QualifiedName.staticParse(readBuffer), readBuffer), (long)(arrayLength == null ? 1 : arrayLength), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("VariantQualifiedName", new WithReaderArgs[0]);
        return new VariantQualifiedNameBuilder(arrayLength, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariantQualifiedName)) {
            return false;
        }
        VariantQualifiedName that = (VariantQualifiedName)o;
        return this.getArrayLength() == that.getArrayLength() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getArrayLength(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class VariantQualifiedNameBuilder
    implements Variant.VariantBuilder {
        private final Integer arrayLength;
        private final List<QualifiedName> value;

        public VariantQualifiedNameBuilder(Integer arrayLength, List<QualifiedName> value) {
            this.arrayLength = arrayLength;
            this.value = value;
        }

        @Override
        public VariantQualifiedName build(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions) {
            VariantQualifiedName variantQualifiedName = new VariantQualifiedName(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions, this.arrayLength, this.value);
            return variantQualifiedName;
        }
    }
}

