/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ExtensionObjectEncodingMask implements Message {

  // Properties.
  protected final boolean typeIdSpecified;
  protected final boolean xmlbody;
  protected final boolean binaryBody;

  public ExtensionObjectEncodingMask(boolean typeIdSpecified, boolean xmlbody, boolean binaryBody) {
    super();
    this.typeIdSpecified = typeIdSpecified;
    this.xmlbody = xmlbody;
    this.binaryBody = binaryBody;
  }

  public boolean getTypeIdSpecified() {
    return typeIdSpecified;
  }

  public boolean getXmlbody() {
    return xmlbody;
  }

  public boolean getBinaryBody() {
    return binaryBody;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ExtensionObjectEncodingMask");

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeSignedByte(writeBuffer, 5));

    // Simple Field (typeIdSpecified)
    writeSimpleField("typeIdSpecified", typeIdSpecified, writeBoolean(writeBuffer));

    // Simple Field (xmlbody)
    writeSimpleField("xmlbody", xmlbody, writeBoolean(writeBuffer));

    // Simple Field (binaryBody)
    writeSimpleField("binaryBody", binaryBody, writeBoolean(writeBuffer));

    writeBuffer.popContext("ExtensionObjectEncodingMask");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    ExtensionObjectEncodingMask _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 5;

    // Simple field (typeIdSpecified)
    lengthInBits += 1;

    // Simple field (xmlbody)
    lengthInBits += 1;

    // Simple field (binaryBody)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static ExtensionObjectEncodingMask staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static ExtensionObjectEncodingMask staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("ExtensionObjectEncodingMask");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Byte reservedField0 = readReservedField("reserved", readSignedByte(readBuffer, 5), (byte) 0x00);

    boolean typeIdSpecified = readSimpleField("typeIdSpecified", readBoolean(readBuffer));

    boolean xmlbody = readSimpleField("xmlbody", readBoolean(readBuffer));

    boolean binaryBody = readSimpleField("binaryBody", readBoolean(readBuffer));

    readBuffer.closeContext("ExtensionObjectEncodingMask");
    // Create the instance
    ExtensionObjectEncodingMask _extensionObjectEncodingMask;
    _extensionObjectEncodingMask =
        new ExtensionObjectEncodingMask(typeIdSpecified, xmlbody, binaryBody);
    return _extensionObjectEncodingMask;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ExtensionObjectEncodingMask)) {
      return false;
    }
    ExtensionObjectEncodingMask that = (ExtensionObjectEncodingMask) o;
    return (getTypeIdSpecified() == that.getTypeIdSpecified())
        && (getXmlbody() == that.getXmlbody())
        && (getBinaryBody() == that.getBinaryBody())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getTypeIdSpecified(), getXmlbody(), getBinaryBody());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
