/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableType {
  BaseVariableType((int) 62L),
  BaseDataVariableType((int) 63L),
  PropertyType((int) 68L),
  DataTypeDescriptionType((int) 69L),
  DataTypeDictionaryType((int) 72L),
  ServerVendorCapabilityType((int) 2137L),
  ServerStatusType((int) 2138L),
  ServerDiagnosticsSummaryType((int) 2150L),
  SamplingIntervalDiagnosticsArrayType((int) 2164L),
  SamplingIntervalDiagnosticsType((int) 2165L),
  SubscriptionDiagnosticsArrayType((int) 2171L),
  SubscriptionDiagnosticsType((int) 2172L),
  SessionDiagnosticsArrayType((int) 2196L),
  SessionDiagnosticsVariableType((int) 2197L),
  SessionSecurityDiagnosticsArrayType((int) 2243L),
  SessionSecurityDiagnosticsType((int) 2244L),
  DataItemType((int) 2365L),
  AnalogItemType((int) 2368L),
  DiscreteItemType((int) 2372L),
  TwoStateDiscreteType((int) 2373L),
  MultiStateDiscreteType((int) 2376L),
  ProgramDiagnosticType((int) 2380L),
  StateVariableType((int) 2755L),
  FiniteStateVariableType((int) 2760L),
  TransitionVariableType((int) 2762L),
  FiniteTransitionVariableType((int) 2767L),
  BuildInfoType((int) 3051L),
  TwoStateVariableType((int) 8995L),
  ConditionVariableType((int) 9002L),
  MultiStateValueDiscreteType((int) 11238L),
  OptionSetType((int) 11487L),
  ArrayItemType((int) 12021L),
  YArrayItemType((int) 12029L),
  XYArrayItemType((int) 12038L),
  ImageItemType((int) 12047L),
  CubeItemType((int) 12057L),
  NDimensionArrayItemType((int) 12068L),
  GuardVariableType((int) 15113L),
  ExpressionGuardVariableType((int) 15128L),
  ElseGuardVariableType((int) 15317L),
  BaseAnalogType((int) 15318L),
  ProgramDiagnostic2Type((int) 15383L),
  SelectionListType((int) 16309L),
  AlarmRateVariableType((int) 17277L),
  AnalogUnitType((int) 17497L),
  AnalogUnitRangeType((int) 17570L),
  RationalNumberType((int) 17709L),
  VectorType((int) 17714L),
  ThreeDVectorType((int) 17716L),
  AudioVariableType((int) 17986L),
  CartesianCoordinatesType((int) 18772L),
  ThreeDCartesianCoordinatesType((int) 18774L),
  OrientationType((int) 18779L),
  ThreeDOrientationType((int) 18781L),
  FrameType((int) 18786L),
  ThreeDFrameType((int) 18791L),
  MultiStateDictionaryEntryDiscreteBaseType((int) 19077L),
  MultiStateDictionaryEntryDiscreteType((int) 19084L),
  PubSubDiagnosticsCounterType((int) 19725L),
  AlarmStateVariableType((int) 32244L),
  ReferenceDescriptionVariableType((int) 32657L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableType> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableType value : OpcuaNodeIdServicesVariableType.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableType enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
