/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpcuaOpenRequest extends MessagePDU implements Message {

  // Accessors for discriminator values.
  public String getMessageType() {
    return (String) "OPN";
  }

  public Boolean getResponse() {
    return (boolean) false;
  }

  // Properties.
  protected final String chunk;
  protected final int secureChannelId;
  protected final PascalString endpoint;
  protected final PascalByteString senderCertificate;
  protected final PascalByteString receiverCertificateThumbprint;
  protected final int sequenceNumber;
  protected final int requestId;
  protected final byte[] message;

  public OpcuaOpenRequest(
      String chunk,
      int secureChannelId,
      PascalString endpoint,
      PascalByteString senderCertificate,
      PascalByteString receiverCertificateThumbprint,
      int sequenceNumber,
      int requestId,
      byte[] message) {
    super();
    this.chunk = chunk;
    this.secureChannelId = secureChannelId;
    this.endpoint = endpoint;
    this.senderCertificate = senderCertificate;
    this.receiverCertificateThumbprint = receiverCertificateThumbprint;
    this.sequenceNumber = sequenceNumber;
    this.requestId = requestId;
    this.message = message;
  }

  public String getChunk() {
    return chunk;
  }

  public int getSecureChannelId() {
    return secureChannelId;
  }

  public PascalString getEndpoint() {
    return endpoint;
  }

  public PascalByteString getSenderCertificate() {
    return senderCertificate;
  }

  public PascalByteString getReceiverCertificateThumbprint() {
    return receiverCertificateThumbprint;
  }

  public int getSequenceNumber() {
    return sequenceNumber;
  }

  public int getRequestId() {
    return requestId;
  }

  public byte[] getMessage() {
    return message;
  }

  @Override
  protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpcuaOpenRequest");

    // Simple Field (chunk)
    writeSimpleField("chunk", chunk, writeString(writeBuffer, 8));

    // Implicit Field (messageSize) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int messageSize = (int) (getLengthInBytes());
    writeImplicitField("messageSize", messageSize, writeSignedInt(writeBuffer, 32));

    // Simple Field (secureChannelId)
    writeSimpleField("secureChannelId", secureChannelId, writeSignedInt(writeBuffer, 32));

    // Simple Field (endpoint)
    writeSimpleField("endpoint", endpoint, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (senderCertificate)
    writeSimpleField(
        "senderCertificate", senderCertificate, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (receiverCertificateThumbprint)
    writeSimpleField(
        "receiverCertificateThumbprint",
        receiverCertificateThumbprint,
        new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (sequenceNumber)
    writeSimpleField("sequenceNumber", sequenceNumber, writeSignedInt(writeBuffer, 32));

    // Simple Field (requestId)
    writeSimpleField("requestId", requestId, writeSignedInt(writeBuffer, 32));

    // Array Field (message)
    writeByteArrayField("message", message, writeByteArray(writeBuffer, 8));

    writeBuffer.popContext("OpcuaOpenRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpcuaOpenRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (chunk)
    lengthInBits += 8;

    // Implicit Field (messageSize)
    lengthInBits += 32;

    // Simple field (secureChannelId)
    lengthInBits += 32;

    // Simple field (endpoint)
    lengthInBits += endpoint.getLengthInBits();

    // Simple field (senderCertificate)
    lengthInBits += senderCertificate.getLengthInBits();

    // Simple field (receiverCertificateThumbprint)
    lengthInBits += receiverCertificateThumbprint.getLengthInBits();

    // Simple field (sequenceNumber)
    lengthInBits += 32;

    // Simple field (requestId)
    lengthInBits += 32;

    // Array field
    if (message != null) {
      lengthInBits += 8 * message.length;
    }

    return lengthInBits;
  }

  public static MessagePDUBuilder staticParseMessagePDUBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("OpcuaOpenRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    String chunk = readSimpleField("chunk", readString(readBuffer, 8));

    int messageSize = readImplicitField("messageSize", readSignedInt(readBuffer, 32));

    int secureChannelId = readSimpleField("secureChannelId", readSignedInt(readBuffer, 32));

    PascalString endpoint =
        readSimpleField(
            "endpoint",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    PascalByteString senderCertificate =
        readSimpleField(
            "senderCertificate",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    PascalByteString receiverCertificateThumbprint =
        readSimpleField(
            "receiverCertificateThumbprint",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    int sequenceNumber = readSimpleField("sequenceNumber", readSignedInt(readBuffer, 32));

    int requestId = readSimpleField("requestId", readSignedInt(readBuffer, 32));

    byte[] message =
        readBuffer.readByteArray(
            "message",
            Math.toIntExact(
                ((((messageSize)
                                - (((((endpoint.getStringLength()) == (-(1)))
                                    ? 0
                                    : endpoint.getStringLength()))))
                            - (((((senderCertificate.getStringLength()) == (-(1)))
                                ? 0
                                : senderCertificate.getStringLength()))))
                        - (((((receiverCertificateThumbprint.getStringLength()) == (-(1)))
                            ? 0
                            : receiverCertificateThumbprint.getStringLength()))))
                    - (32)));

    readBuffer.closeContext("OpcuaOpenRequest");
    // Create the instance
    return new OpcuaOpenRequestBuilderImpl(
        chunk,
        secureChannelId,
        endpoint,
        senderCertificate,
        receiverCertificateThumbprint,
        sequenceNumber,
        requestId,
        message);
  }

  public static class OpcuaOpenRequestBuilderImpl implements MessagePDU.MessagePDUBuilder {
    private final String chunk;
    private final int secureChannelId;
    private final PascalString endpoint;
    private final PascalByteString senderCertificate;
    private final PascalByteString receiverCertificateThumbprint;
    private final int sequenceNumber;
    private final int requestId;
    private final byte[] message;

    public OpcuaOpenRequestBuilderImpl(
        String chunk,
        int secureChannelId,
        PascalString endpoint,
        PascalByteString senderCertificate,
        PascalByteString receiverCertificateThumbprint,
        int sequenceNumber,
        int requestId,
        byte[] message) {
      this.chunk = chunk;
      this.secureChannelId = secureChannelId;
      this.endpoint = endpoint;
      this.senderCertificate = senderCertificate;
      this.receiverCertificateThumbprint = receiverCertificateThumbprint;
      this.sequenceNumber = sequenceNumber;
      this.requestId = requestId;
      this.message = message;
    }

    public OpcuaOpenRequest build() {
      OpcuaOpenRequest opcuaOpenRequest =
          new OpcuaOpenRequest(
              chunk,
              secureChannelId,
              endpoint,
              senderCertificate,
              receiverCertificateThumbprint,
              sequenceNumber,
              requestId,
              message);
      return opcuaOpenRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpcuaOpenRequest)) {
      return false;
    }
    OpcuaOpenRequest that = (OpcuaOpenRequest) o;
    return (getChunk() == that.getChunk())
        && (getSecureChannelId() == that.getSecureChannelId())
        && (getEndpoint() == that.getEndpoint())
        && (getSenderCertificate() == that.getSenderCertificate())
        && (getReceiverCertificateThumbprint() == that.getReceiverCertificateThumbprint())
        && (getSequenceNumber() == that.getSequenceNumber())
        && (getRequestId() == that.getRequestId())
        && (getMessage() == that.getMessage())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getChunk(),
        getSecureChannelId(),
        getEndpoint(),
        getSenderCertificate(),
        getReceiverCertificateThumbprint(),
        getSequenceNumber(),
        getRequestId(),
        getMessage());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
