/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua;

import io.netty.buffer.ByteBuf;
import java.util.function.ToIntFunction;
import org.apache.plc4x.java.api.value.PlcValueHandler;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.OpcuaDriverContext;
import org.apache.plc4x.java.opcua.optimizer.OpcuaOptimizer;
import org.apache.plc4x.java.opcua.protocol.OpcuaProtocolLogic;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.tag.OpcuaPlcTagHandler;
import org.apache.plc4x.java.opcua.tag.OpcuaTag;
import org.apache.plc4x.java.spi.configuration.Configuration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;

public class OpcuaPlcDriver
extends GeneratedDriverBase<OpcuaAPU> {
    public String getProtocolCode() {
        return "opcua";
    }

    public String getProtocolName() {
        return "Opcua";
    }

    protected Class<? extends Configuration> getConfigurationType() {
        return OpcuaConfiguration.class;
    }

    protected String getDefaultTransport() {
        return "tcp";
    }

    protected boolean canRead() {
        return true;
    }

    protected boolean canWrite() {
        return true;
    }

    protected boolean canSubscribe() {
        return true;
    }

    protected OpcuaOptimizer getOptimizer() {
        return new OpcuaOptimizer();
    }

    protected OpcuaPlcTagHandler getTagHandler() {
        return new OpcuaPlcTagHandler();
    }

    protected PlcValueHandler getValueHandler() {
        return new org.apache.plc4x.java.spi.values.PlcValueHandler();
    }

    protected boolean awaitDisconnectComplete() {
        return true;
    }

    protected ProtocolStackConfigurer<OpcuaAPU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(OpcuaAPU.class, (readBuffer, objectArray) -> OpcuaAPU.staticParse(readBuffer, objectArray)).withProtocol(OpcuaProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(new Object[]{true}).withDriverContext(OpcuaDriverContext.class).littleEndian().build();
    }

    public OpcuaTag prepareTag(String tagAddress) {
        return OpcuaTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 8) {
                return Integer.reverseBytes(byteBuf.getInt(byteBuf.readerIndex() + 4));
            }
            return -1;
        }
    }
}

