/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.FileSystems;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.CertificateGenerator;
import org.apache.plc4x.java.opcua.context.CertificateKeyPair;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaDriverContext
implements DriverContext,
HasConfiguration<OpcuaConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcuaDriverContext.class);
    public static final Pattern INET_ADDRESS_PATTERN = Pattern.compile("(:(?<transportCode>[a-z0-9]*))?://(?<transportHost>[\\w.-]+)(:(?<transportPort>\\d*))?");
    public static final Pattern URI_PATTERN = Pattern.compile("^(?<protocolCode>opcua)" + INET_ADDRESS_PATTERN + "(?<transportEndpoint>[\\w/=]*)[?]?" + "(?<paramString>([^=]+=[^=&]+&?)*)");
    private String code;
    private String host;
    private String port;
    private String endpoint;
    private String transportEndpoint;
    private Boolean isEncrypted = false;
    private PascalByteString thumbprint;
    private byte[] senderCertificate;
    private CertificateKeyPair certificateKeyPair;

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void openKeyStore(OpcuaConfiguration configuration) throws Exception {
        this.isEncrypted = true;
        String certDirectory = configuration.getCertDirectory();
        File securityTempDir = new File(certDirectory, "security");
        if (!securityTempDir.exists() && !securityTempDir.mkdirs()) {
            throw new PlcRuntimeException("Unable to create directory please confirm folder permissions on " + certDirectory);
        }
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        File serverKeyStore = securityTempDir.toPath().resolve(configuration.getKeyStoreFile()).toFile();
        File pkiDir = FileSystems.getDefault().getPath(certDirectory, new String[0]).resolve("pki").toFile();
        char[] password = configuration.getKeyStorePassword().toCharArray();
        if (!serverKeyStore.exists()) {
            this.certificateKeyPair = CertificateGenerator.generateCertificate();
            LOGGER.info("Creating new KeyStore at {}", (Object)serverKeyStore);
            keyStore.load(null, password);
            keyStore.setKeyEntry("plc4x-certificate-alias", this.certificateKeyPair.getKeyPair().getPrivate(), password, new X509Certificate[]{this.certificateKeyPair.getCertificate()});
            keyStore.store(new FileOutputStream(serverKeyStore), password);
        } else {
            LOGGER.info("Loading KeyStore at {}", (Object)serverKeyStore);
            keyStore.load(new FileInputStream(serverKeyStore), password);
            String alias = keyStore.aliases().nextElement();
            KeyPair kp = new KeyPair(keyStore.getCertificate(alias).getPublicKey(), (PrivateKey)keyStore.getKey(alias, password));
            this.certificateKeyPair = new CertificateKeyPair(kp, (X509Certificate)keyStore.getCertificate(alias));
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getTransportEndpoint() {
        return this.transportEndpoint;
    }

    public Boolean getEncrypted() {
        return this.isEncrypted;
    }

    public PascalByteString getThumbprint() {
        return this.thumbprint;
    }

    public void setThumbprint(PascalByteString thumbprint) {
        this.thumbprint = thumbprint;
    }

    public byte[] getSenderCertificate() {
        return this.senderCertificate;
    }

    public void setSenderCertificate(byte[] senderCertificate) {
        this.senderCertificate = senderCertificate;
    }

    public CertificateKeyPair getCertificateKeyPair() {
        return this.certificateKeyPair;
    }

    public void setConfiguration(OpcuaConfiguration configuration) {
        Matcher matcher = OpcuaDriverContext.getMatcher(configuration);
        this.code = matcher.group("transportCode");
        this.host = matcher.group("transportHost");
        this.port = matcher.group("transportPort");
        this.transportEndpoint = matcher.group("transportEndpoint");
        String portAddition = this.port != null ? ":" + this.port : "";
        this.endpoint = "opc." + this.code + "://" + this.host + portAddition + this.transportEndpoint;
        if (configuration.getSecurityPolicy() != null && !configuration.getSecurityPolicy().equals("None")) {
            try {
                this.openKeyStore(configuration);
            }
            catch (Exception e) {
                throw new PlcRuntimeException("Unable to open keystore, please confirm you have the correct permissions");
            }
        }
    }

    private static Matcher getMatcher(OpcuaConfiguration configuration) {
        String uri = String.valueOf(configuration.getProtocolCode()) + ":" + configuration.getTransportCode() + "://" + configuration.getTransportConfig();
        Matcher matcher = URI_PATTERN.matcher(uri);
        if (!matcher.matches()) {
            throw new PlcRuntimeException("Connection string doesn't match the format '{protocol-code}:({transport-code})?//{transport-host}(:{transport-port})(/{transport-endpoint})(?{parameter-string)?': " + uri);
        }
        return matcher;
    }
}

