/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.OpcuaDriverContext;
import org.apache.plc4x.java.opcua.context.SecureChannel;
import org.apache.plc4x.java.opcua.protocol.OpcuaSubscriptionHandle;
import org.apache.plc4x.java.opcua.readwrite.ByteStringArray;
import org.apache.plc4x.java.opcua.readwrite.CreateSubscriptionRequest;
import org.apache.plc4x.java.opcua.readwrite.CreateSubscriptionResponse;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.opcua.readwrite.GuidValue;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.NodeIdFourByte;
import org.apache.plc4x.java.opcua.readwrite.NodeIdGuid;
import org.apache.plc4x.java.opcua.readwrite.NodeIdNumeric;
import org.apache.plc4x.java.opcua.readwrite.NodeIdString;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTwoByte;
import org.apache.plc4x.java.opcua.readwrite.NullExtension;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaIdentifierType;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.QualifiedName;
import org.apache.plc4x.java.opcua.readwrite.ReadRequest;
import org.apache.plc4x.java.opcua.readwrite.ReadResponse;
import org.apache.plc4x.java.opcua.readwrite.ReadValueId;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.ServiceFault;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.opcua.readwrite.VariantBoolean;
import org.apache.plc4x.java.opcua.readwrite.VariantByte;
import org.apache.plc4x.java.opcua.readwrite.VariantByteString;
import org.apache.plc4x.java.opcua.readwrite.VariantDateTime;
import org.apache.plc4x.java.opcua.readwrite.VariantDouble;
import org.apache.plc4x.java.opcua.readwrite.VariantExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.VariantFloat;
import org.apache.plc4x.java.opcua.readwrite.VariantGuid;
import org.apache.plc4x.java.opcua.readwrite.VariantInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantLocalizedText;
import org.apache.plc4x.java.opcua.readwrite.VariantNodeId;
import org.apache.plc4x.java.opcua.readwrite.VariantQualifiedName;
import org.apache.plc4x.java.opcua.readwrite.VariantSByte;
import org.apache.plc4x.java.opcua.readwrite.VariantStatusCode;
import org.apache.plc4x.java.opcua.readwrite.VariantString;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantXmlElement;
import org.apache.plc4x.java.opcua.readwrite.WriteRequest;
import org.apache.plc4x.java.opcua.readwrite.WriteResponse;
import org.apache.plc4x.java.opcua.readwrite.WriteValue;
import org.apache.plc4x.java.opcua.tag.OpcuaTag;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaProtocolLogic
extends Plc4xProtocolBase<OpcuaAPU>
implements HasConfiguration<OpcuaConfiguration>,
PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcuaProtocolLogic.class);
    protected static final PascalString NULL_STRING = new PascalString("");
    private static final ExpandedNodeId NULL_EXPANDED_NODEID = new ExpandedNodeId(false, false, new NodeIdTwoByte(0), null, null);
    protected static final ExtensionObject NULL_EXTENSION_OBJECT = new ExtensionObject(NULL_EXPANDED_NODEID, new ExtensionObjectEncodingMask(false, false, false), new NullExtension());
    private static final long EPOCH_OFFSET = 116444736000000000L;
    private OpcuaConfiguration configuration;
    private final Map<Long, OpcuaSubscriptionHandle> subscriptions = new HashMap<Long, OpcuaSubscriptionHandle>();
    private SecureChannel channel;

    public void setConfiguration(OpcuaConfiguration configuration) {
        this.configuration = configuration;
    }

    public void close(ConversationContext<OpcuaAPU> context) {
    }

    public void onDisconnect(ConversationContext<OpcuaAPU> context) {
        if (this.channel == null) {
            return;
        }
        for (Map.Entry<Long, OpcuaSubscriptionHandle> subscriber : this.subscriptions.entrySet()) {
            subscriber.getValue().stopSubscriber();
        }
        this.channel.onDisconnect(context);
    }

    public void setDriverContext(DriverContext driverContext) {
        super.setDriverContext(driverContext);
    }

    public void onConnect(ConversationContext<OpcuaAPU> context) {
        LOGGER.debug("Opcua Driver running in ACTIVE mode.");
        if (this.channel == null) {
            try {
                this.channel = this.createSecureChannel(context.getAuthentication());
            }
            catch (PlcRuntimeException ex) {
                context.getChannel().pipeline().fireExceptionCaught((Throwable)new PlcConnectionException((Throwable)ex));
                return;
            }
        }
        this.channel.onConnect(context);
    }

    public void onDiscover(ConversationContext<OpcuaAPU> context) {
        LOGGER.debug("Opcua Driver running in ACTIVE mode, discovering endpoints");
        if (this.channel == null) {
            try {
                this.channel = this.createSecureChannel(context.getAuthentication());
            }
            catch (PlcRuntimeException ex) {
                context.getChannel().pipeline().fireExceptionCaught((Throwable)new PlcConnectionException((Throwable)ex));
                return;
            }
        }
        this.channel.onDiscover(context);
    }

    private SecureChannel createSecureChannel(PlcAuthentication authentication) {
        return new SecureChannel((OpcuaDriverContext)this.driverContext, this.configuration, authentication);
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        LOGGER.trace("Reading Value");
        CompletableFuture<PlcReadResponse> future = new CompletableFuture<PlcReadResponse>();
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), this.channel.getRequestHandle(), 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        ArrayList<ExtensionObjectDefinition> readValueArray = new ArrayList<ExtensionObjectDefinition>(request.getTagNames().size());
        Iterator iterator = request.getTagNames().iterator();
        int i = 0;
        while (i < request.getTagNames().size()) {
            String tagName = (String)iterator.next();
            OpcuaTag tag = (OpcuaTag)request.getTag(tagName);
            NodeId nodeId = OpcuaProtocolLogic.generateNodeId(tag);
            readValueArray.add(new ReadValueId(nodeId, 13L, NULL_STRING, new QualifiedName(0, NULL_STRING)));
            ++i;
        }
        ReadRequest opcuaReadRequest = new ReadRequest(requestHeader, 0.0, TimestampsToReturn.timestampsToReturnNeither, readValueArray.size(), readValueArray);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(opcuaReadRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, opcuaReadRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                try {
                    ExtensionObjectDefinition reply = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (reply instanceof ReadResponse) {
                        future.complete((PlcReadResponse)new DefaultPlcReadResponse((PlcReadRequest)request, this.readResponse(request.getTagNames(), ((ReadResponse)reply).getResults())));
                    } else {
                        if (reply instanceof ServiceFault) {
                            ExtensionObjectDefinition header = ((ServiceFault)reply).getResponseHeader();
                            LOGGER.error("Read request ended up with ServiceFault: {}", (Object)header);
                        } else {
                            LOGGER.error("Remote party returned an error '{}'", (Object)reply);
                        }
                        LinkedHashMap<String, ResponseItem> status = new LinkedHashMap<String, ResponseItem>();
                        for (String key : request.getTagNames()) {
                            status.put(key, new ResponseItem(PlcResponseCode.INTERNAL_ERROR, null));
                        }
                        future.complete((PlcReadResponse)new DefaultPlcReadResponse((PlcReadRequest)request, status));
                    }
                }
                catch (PlcRuntimeException | ParseException e) {
                    future.completeExceptionally(new PlcRuntimeException(e));
                }
            };
            Consumer<TimeoutException> timeout = future::completeExceptionally;
            BiConsumer<OpcuaAPU, Throwable> error = (message, t) -> future.completeExceptionally((Throwable)t);
            this.channel.submit((ConversationContext<OpcuaAPU>)this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to serialise the ReadRequest");
        }
        return future;
    }

    static NodeId generateNodeId(OpcuaTag tag) {
        NodeId nodeId = null;
        if (tag.getIdentifierType() == OpcuaIdentifierType.BINARY_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdTwoByte(Short.parseShort(tag.getIdentifier())));
        } else if (tag.getIdentifierType() == OpcuaIdentifierType.NUMBER_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdNumeric((short)tag.getNamespace(), Long.parseLong(tag.getIdentifier())));
        } else if (tag.getIdentifierType() == OpcuaIdentifierType.GUID_IDENTIFIER) {
            UUID guid = UUID.fromString(tag.getIdentifier());
            ByteBuffer bb = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putInt((int)(guid.getMostSignificantBits() >> 32)).putShort((short)(guid.getMostSignificantBits() >> 16)).putShort((short)guid.getMostSignificantBits()).order(ByteOrder.BIG_ENDIAN).putLong(guid.getLeastSignificantBits());
            nodeId = new NodeId(new NodeIdGuid((short)tag.getNamespace(), bb.array()));
        } else if (tag.getIdentifierType() == OpcuaIdentifierType.STRING_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdString((short)tag.getNamespace(), new PascalString(tag.getIdentifier())));
        }
        return nodeId;
    }

    public Map<String, ResponseItem<PlcValue>> readResponse(LinkedHashSet<String> tagNames, List<DataValue> results) {
        PlcResponseCode responseCode = PlcResponseCode.OK;
        HashMap<String, ResponseItem<PlcValue>> response = new HashMap<String, ResponseItem<PlcValue>>();
        int count = 0;
        for (String tagName : tagNames) {
            PlcValue value = null;
            if (results.get(count).getValueSpecified()) {
                Object[] tmpValue;
                Variant variant = results.get(count).getValue();
                LOGGER.trace("Response of type {}", (Object)variant.getClass().toString());
                if (variant instanceof VariantBoolean) {
                    byte[] array = ((VariantBoolean)variant).getValue();
                    int length = array.length;
                    tmpValue = new Boolean[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = array[i] != 0;
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantSByte) {
                    byte[] array = ((VariantSByte)variant).getValue();
                    value = PlcValueHandler.of((Object)array);
                } else if (variant instanceof VariantByte) {
                    List<Short> array = ((VariantByte)variant).getValue();
                    Object[] tmpValue2 = array.toArray(new Short[0]);
                    value = PlcValueHandler.of((Object[])tmpValue2);
                } else if (variant instanceof VariantInt16) {
                    List<Short> array = ((VariantInt16)variant).getValue();
                    Object[] tmpValue3 = array.toArray(new Short[0]);
                    value = PlcValueHandler.of((Object[])tmpValue3);
                } else if (variant instanceof VariantUInt16) {
                    List<Integer> array = ((VariantUInt16)variant).getValue();
                    Object[] tmpValue4 = array.toArray(new Integer[0]);
                    value = PlcValueHandler.of((Object[])tmpValue4);
                } else if (variant instanceof VariantInt32) {
                    List<Integer> array = ((VariantInt32)variant).getValue();
                    Object[] tmpValue5 = array.toArray(new Integer[0]);
                    value = PlcValueHandler.of((Object[])tmpValue5);
                } else if (variant instanceof VariantUInt32) {
                    List<Long> array = ((VariantUInt32)variant).getValue();
                    Object[] tmpValue6 = array.toArray(new Long[0]);
                    value = PlcValueHandler.of((Object[])tmpValue6);
                } else if (variant instanceof VariantInt64) {
                    List<Long> array = ((VariantInt64)variant).getValue();
                    Object[] tmpValue7 = array.toArray(new Long[0]);
                    value = PlcValueHandler.of((Object[])tmpValue7);
                } else if (variant instanceof VariantUInt64) {
                    value = PlcValueHandler.of(((VariantUInt64)variant).getValue());
                } else if (variant instanceof VariantFloat) {
                    List<Float> array = ((VariantFloat)variant).getValue();
                    Object[] tmpValue8 = array.toArray(new Float[0]);
                    value = PlcValueHandler.of((Object[])tmpValue8);
                } else if (variant instanceof VariantDouble) {
                    List<Double> array = ((VariantDouble)variant).getValue();
                    Object[] tmpValue9 = array.toArray(new Double[0]);
                    value = PlcValueHandler.of((Object[])tmpValue9);
                } else if (variant instanceof VariantString) {
                    int length = ((VariantString)variant).getValue().size();
                    List<PascalString> stringArray = ((VariantString)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = stringArray.get(i).getStringValue();
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantDateTime) {
                    List<Long> array = ((VariantDateTime)variant).getValue();
                    int length = array.size();
                    tmpValue = new LocalDateTime[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(OpcuaProtocolLogic.getDateTime(array.get(i))), ZoneOffset.UTC);
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantGuid) {
                    List<GuidValue> array = ((VariantGuid)variant).getValue();
                    int length = array.size();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        byte[] data4Bytes = array.get(i).getData4();
                        int data4 = 0;
                        byte[] byArray = data4Bytes;
                        int n = data4Bytes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte data4Byte = byArray[n2];
                            data4 = (data4 << 8) + (data4Byte & 0xFF);
                            ++n2;
                        }
                        byte[] data5Bytes = array.get(i).getData5();
                        long data5 = 0L;
                        byte[] byArray2 = data5Bytes;
                        int n3 = data5Bytes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            byte data5Byte = byArray2[n4];
                            data5 = (data5 << 8) + (long)(data5Byte & 0xFF);
                            ++n4;
                        }
                        tmpValue[i] = String.valueOf(Long.toHexString(array.get(i).getData1())) + "-" + Integer.toHexString(array.get(i).getData2()) + "-" + Integer.toHexString(array.get(i).getData3()) + "-" + Integer.toHexString(data4) + "-" + Long.toHexString(data5);
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantXmlElement) {
                    int length = ((VariantXmlElement)variant).getValue().size();
                    List<PascalString> strings = ((VariantXmlElement)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).getStringValue();
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantLocalizedText) {
                    int length = ((VariantLocalizedText)variant).getValue().size();
                    List<LocalizedText> strings = ((VariantLocalizedText)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = "";
                        int n = i;
                        tmpValue[n] = String.valueOf(tmpValue[n]) + (strings.get(i).getLocaleSpecified() ? String.valueOf(strings.get(i).getLocale().getStringValue()) + "|" : "");
                        int n5 = i;
                        tmpValue[n5] = String.valueOf(tmpValue[n5]) + (strings.get(i).getTextSpecified() ? strings.get(i).getText().getStringValue() : "");
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantQualifiedName) {
                    int length = ((VariantQualifiedName)variant).getValue().size();
                    List<QualifiedName> strings = ((VariantQualifiedName)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = "ns=" + strings.get(i).getNamespaceIndex() + ";s=" + strings.get(i).getName().getStringValue();
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantExtensionObject) {
                    int length = ((VariantExtensionObject)variant).getValue().size();
                    List<ExtensionObject> strings = ((VariantExtensionObject)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).toString();
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantNodeId) {
                    int length = ((VariantNodeId)variant).getValue().size();
                    List<NodeId> strings = ((VariantNodeId)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).toString();
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantStatusCode) {
                    int length = ((VariantStatusCode)variant).getValue().size();
                    List<StatusCode> strings = ((VariantStatusCode)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).toString();
                        ++i;
                    }
                    value = PlcValueHandler.of((Object[])tmpValue);
                } else if (variant instanceof VariantByteString) {
                    PlcList plcList = new PlcList();
                    List<ByteStringArray> array = ((VariantByteString)variant).getValue();
                    for (ByteStringArray byteStringArray : array) {
                        int length = byteStringArray.getValue().size();
                        Object[] tmpValue10 = new Short[length];
                        int i = 0;
                        while (i < length) {
                            tmpValue10[i] = byteStringArray.getValue().get(i);
                            ++i;
                        }
                        plcList.add(PlcValueHandler.of((Object[])tmpValue10));
                    }
                    value = plcList;
                } else {
                    responseCode = PlcResponseCode.UNSUPPORTED;
                    LOGGER.error("Data type - " + variant.getClass() + " is not supported ");
                }
            } else {
                responseCode = results.get(count).getStatusCode().getStatusCode() == OpcuaStatusCode.BadNodeIdUnknown.getValue() ? PlcResponseCode.NOT_FOUND : PlcResponseCode.UNSUPPORTED;
                LOGGER.error("Error while reading value from OPC UA server error code:- " + results.get(count).getStatusCode().toString());
            }
            ++count;
            response.put(tagName, (ResponseItem<PlcValue>)new ResponseItem(responseCode, (Object)value));
        }
        return response;
    }

    private Variant fromPlcValue(String tagName, OpcuaTag tag, PlcWriteRequest request) {
        PlcList valueObject;
        if (request.getPlcValue(tagName).getObject() instanceof ArrayList) {
            valueObject = (PlcList)request.getPlcValue(tagName);
        } else {
            ArrayList<PlcValue> list = new ArrayList<PlcValue>();
            list.add(request.getPlcValue(tagName));
            valueObject = new PlcList(list);
        }
        List plcValueList = valueObject.getList();
        PlcValueType dataType = tag.getPlcValueType();
        if (dataType.equals((Object)PlcValueType.NULL)) {
            if (((PlcValue)plcValueList.get(0)).getObject() instanceof Boolean) {
                dataType = PlcValueType.BOOL;
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Byte) {
                dataType = PlcValueType.SINT;
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Short) {
                dataType = PlcValueType.INT;
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Integer) {
                dataType = PlcValueType.DINT;
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Long) {
                dataType = PlcValueType.LINT;
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Float) {
                dataType = PlcValueType.REAL;
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof Double) {
                dataType = PlcValueType.LREAL;
            } else if (((PlcValue)plcValueList.get(0)).getObject() instanceof String) {
                dataType = PlcValueType.STRING;
            }
        }
        int length = valueObject.getLength();
        switch (dataType) {
            case BOOL: {
                byte[] tmpBOOL = new byte[length];
                int i = 0;
                while (i < length) {
                    tmpBOOL[i] = valueObject.getIndex(i).getByte();
                    ++i;
                }
                return new VariantBoolean(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpBOOL);
            }
            case BYTE: {
                ArrayList<Short> tmpBYTE = new ArrayList<Short>(length);
                int i = 0;
                while (i < length) {
                    tmpBYTE.add(valueObject.getIndex(i).getShort());
                    ++i;
                }
                return new VariantByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpBYTE);
            }
            case WORD: {
                ArrayList<Integer> tmpWORD = new ArrayList<Integer>(length);
                int i = 0;
                while (i < length) {
                    tmpWORD.add(valueObject.getIndex(i).getInteger());
                    ++i;
                }
                return new VariantUInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpWORD);
            }
            case DWORD: {
                ArrayList<Long> tmpDWORD = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpDWORD.add(valueObject.getIndex(i).getLong());
                    ++i;
                }
                return new VariantUInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDWORD);
            }
            case LWORD: {
                ArrayList<BigInteger> tmpLWORD = new ArrayList<BigInteger>(length);
                int i = 0;
                while (i < length) {
                    tmpLWORD.add(valueObject.getIndex(i).getBigInteger());
                    ++i;
                }
                return new VariantUInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLWORD);
            }
            case USINT: {
                ArrayList<Short> tmpUSINT = new ArrayList<Short>(length);
                int i = 0;
                while (i < length) {
                    tmpUSINT.add(valueObject.getIndex(i).getShort());
                    ++i;
                }
                return new VariantByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUSINT);
            }
            case SINT: {
                byte[] tmpSINT = new byte[length];
                int i = 0;
                while (i < length) {
                    tmpSINT[i] = valueObject.getIndex(i).getByte();
                    ++i;
                }
                return new VariantSByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpSINT);
            }
            case UINT: {
                ArrayList<Integer> tmpUINT = new ArrayList<Integer>(length);
                int i = 0;
                while (i < length) {
                    tmpUINT.add(valueObject.getIndex(i).getInt());
                    ++i;
                }
                return new VariantUInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUINT);
            }
            case INT: {
                ArrayList<Short> tmpINT16 = new ArrayList<Short>(length);
                int i = 0;
                while (i < length) {
                    tmpINT16.add(valueObject.getIndex(i).getShort());
                    ++i;
                }
                return new VariantInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpINT16);
            }
            case UDINT: {
                ArrayList<Long> tmpUDINT = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpUDINT.add(valueObject.getIndex(i).getLong());
                    ++i;
                }
                return new VariantUInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUDINT);
            }
            case DINT: {
                ArrayList<Integer> tmpDINT = new ArrayList<Integer>(length);
                int i = 0;
                while (i < length) {
                    tmpDINT.add(valueObject.getIndex(i).getInt());
                    ++i;
                }
                return new VariantInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDINT);
            }
            case ULINT: {
                ArrayList<BigInteger> tmpULINT = new ArrayList<BigInteger>(length);
                int i = 0;
                while (i < length) {
                    tmpULINT.add(valueObject.getIndex(i).getBigInteger());
                    ++i;
                }
                return new VariantUInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpULINT);
            }
            case LINT: {
                ArrayList<Long> tmpLINT = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpLINT.add(valueObject.getIndex(i).getLong());
                    ++i;
                }
                return new VariantInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLINT);
            }
            case REAL: {
                ArrayList<Float> tmpREAL = new ArrayList<Float>(length);
                int i = 0;
                while (i < length) {
                    tmpREAL.add(Float.valueOf(valueObject.getIndex(i).getFloat()));
                    ++i;
                }
                return new VariantFloat(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpREAL);
            }
            case LREAL: {
                ArrayList<Double> tmpLREAL = new ArrayList<Double>(length);
                int i = 0;
                while (i < length) {
                    tmpLREAL.add(valueObject.getIndex(i).getDouble());
                    ++i;
                }
                return new VariantDouble(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLREAL);
            }
            case CHAR: 
            case WCHAR: 
            case STRING: 
            case WSTRING: {
                ArrayList<PascalString> tmpString = new ArrayList<PascalString>(length);
                int i = 0;
                while (i < length) {
                    String s = valueObject.getIndex(i).getString();
                    tmpString.add(new PascalString(s));
                    ++i;
                }
                return new VariantString(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpString);
            }
            case DATE_AND_TIME: {
                ArrayList<Long> tmpDateTime = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpDateTime.add(valueObject.getIndex(i).getDateTime().toEpochSecond(ZoneOffset.UTC));
                    ++i;
                }
                return new VariantDateTime(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDateTime);
            }
        }
        throw new PlcRuntimeException("Unsupported write tag type " + dataType);
    }

    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        LOGGER.trace("Writing Value");
        CompletableFuture<PlcWriteResponse> future = new CompletableFuture<PlcWriteResponse>();
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), this.channel.getRequestHandle(), 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        ArrayList<ExtensionObjectDefinition> writeValueList = new ArrayList<ExtensionObjectDefinition>(request.getTagNames().size());
        for (String tagName : request.getTagNames()) {
            OpcuaTag tag = (OpcuaTag)request.getTag(tagName);
            NodeId nodeId = OpcuaProtocolLogic.generateNodeId(tag);
            writeValueList.add(new WriteValue(nodeId, 13L, NULL_STRING, new DataValue(false, false, false, false, false, true, this.fromPlcValue(tagName, tag, writeRequest), null, null, null, null, null)));
        }
        WriteRequest opcuaWriteRequest = new WriteRequest(requestHeader, writeValueList.size(), writeValueList);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(opcuaWriteRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, opcuaWriteRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                try {
                    ExtensionObjectDefinition reply = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (reply instanceof WriteResponse) {
                        WriteResponse responseMessage = (WriteResponse)reply;
                        PlcWriteResponse response = this.writeResponse(request, responseMessage);
                        future.complete(response);
                    } else {
                        if (reply instanceof ServiceFault) {
                            ExtensionObjectDefinition header = ((ServiceFault)reply).getResponseHeader();
                            LOGGER.error("Write request ended up with ServiceFault: {}", (Object)header);
                        } else {
                            LOGGER.error("Remote party returned an error '{}'", (Object)reply);
                        }
                        LinkedHashMap<String, PlcResponseCode> status = new LinkedHashMap<String, PlcResponseCode>();
                        for (String key : request.getTagNames()) {
                            status.put(key, PlcResponseCode.INTERNAL_ERROR);
                        }
                        future.complete((PlcWriteResponse)new DefaultPlcWriteResponse((PlcWriteRequest)request, status));
                    }
                }
                catch (ParseException e) {
                    throw new PlcRuntimeException((Throwable)e);
                }
            };
            Consumer<TimeoutException> timeout = future::completeExceptionally;
            BiConsumer<OpcuaAPU, Throwable> error = (message, t) -> future.completeExceptionally((Throwable)t);
            this.channel.submit((ConversationContext<OpcuaAPU>)this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to serialise the ReadRequest");
        }
        return future;
    }

    private PlcWriteResponse writeResponse(DefaultPlcWriteRequest request, WriteResponse writeResponse) {
        HashMap<String, PlcResponseCode> responseMap = new HashMap<String, PlcResponseCode>();
        List<StatusCode> results = writeResponse.getResults();
        Iterator responseIterator = request.getTagNames().iterator();
        int i = 0;
        while (i < request.getTagNames().size()) {
            String tagName = (String)responseIterator.next();
            OpcuaStatusCode statusCode = OpcuaStatusCode.enumForValue(results.get(i).getStatusCode());
            switch (statusCode) {
                case Good: {
                    responseMap.put(tagName, PlcResponseCode.OK);
                    break;
                }
                case BadNodeIdUnknown: {
                    responseMap.put(tagName, PlcResponseCode.NOT_FOUND);
                    break;
                }
                default: {
                    responseMap.put(tagName, PlcResponseCode.REMOTE_ERROR);
                }
            }
            ++i;
        }
        return new DefaultPlcWriteResponse((PlcWriteRequest)request, responseMap);
    }

    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        return CompletableFuture.supplyAsync(() -> {
            long subscriptionId;
            HashMap<String, ResponseItem> values = new HashMap<String, ResponseItem>();
            ArrayList tagNames = new ArrayList(subscriptionRequest.getTagNames());
            long cycleTime = subscriptionRequest.getTag((String)tagNames.get(0)).getDuration().orElse(Duration.ofMillis(1000L)).toMillis();
            try {
                CompletableFuture<CreateSubscriptionResponse> subscription = this.onSubscribeCreateSubscription(cycleTime);
                CreateSubscriptionResponse response = subscription.get(10000L, TimeUnit.MILLISECONDS);
                subscriptionId = response.getSubscriptionId();
                this.subscriptions.put(subscriptionId, new OpcuaSubscriptionHandle((ConversationContext<OpcuaAPU>)this.context, this, this.channel, subscriptionRequest, subscriptionId, cycleTime));
            }
            catch (Exception e) {
                throw new PlcRuntimeException("Unable to subscribe because of: " + e.getMessage());
            }
            for (String tagName : subscriptionRequest.getTagNames()) {
                DefaultPlcSubscriptionTag tagDefaultPlcSubscription = (DefaultPlcSubscriptionTag)subscriptionRequest.getTag(tagName);
                if (!(tagDefaultPlcSubscription.getTag() instanceof OpcuaTag)) {
                    values.put(tagName, new ResponseItem(PlcResponseCode.INVALID_ADDRESS, null));
                    continue;
                }
                values.put(tagName, new ResponseItem(PlcResponseCode.OK, (Object)((PlcSubscriptionHandle)this.subscriptions.get(subscriptionId))));
            }
            return new DefaultPlcSubscriptionResponse(subscriptionRequest, values);
        });
    }

    private CompletableFuture<CreateSubscriptionResponse> onSubscribeCreateSubscription(long cycleTime) {
        CompletableFuture<CreateSubscriptionResponse> future = new CompletableFuture<CreateSubscriptionResponse>();
        LOGGER.trace("Entering creating subscription request");
        RequestHeader requestHeader = new RequestHeader(this.channel.getAuthenticationToken(), SecureChannel.getCurrentDateTime(), this.channel.getRequestHandle(), 0L, NULL_STRING, 10000L, NULL_EXTENSION_OBJECT);
        CreateSubscriptionRequest createSubscriptionRequest = new CreateSubscriptionRequest(requestHeader, cycleTime, 12000L, 5L, 65536L, true, 0);
        ExpandedNodeId expandedNodeId = new ExpandedNodeId(false, false, new NodeIdFourByte(0, Integer.parseInt(createSubscriptionRequest.getIdentifier())), null, null);
        ExtensionObject extObject = new ExtensionObject(expandedNodeId, null, createSubscriptionRequest);
        try {
            WriteBufferByteBased buffer = new WriteBufferByteBased(extObject.getLengthInBytes(), org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN);
            extObject.serialize((WriteBuffer)buffer);
            Consumer<byte[]> consumer = opcuaResponse -> {
                try {
                    ExtensionObjectDefinition reply = ExtensionObject.staticParse((ReadBuffer)new ReadBufferByteBased(opcuaResponse, org.apache.plc4x.java.spi.generation.ByteOrder.LITTLE_ENDIAN), false).getBody();
                    if (reply instanceof CreateSubscriptionResponse) {
                        CreateSubscriptionResponse responseMessage = (CreateSubscriptionResponse)reply;
                        future.complete(responseMessage);
                    } else if (reply instanceof ServiceFault) {
                        ExtensionObjectDefinition header = ((ServiceFault)reply).getResponseHeader();
                        LOGGER.error("Subscription request ended up with ServiceFault: {}", (Object)header);
                        future.completeExceptionally(new PlcRuntimeException(String.format("Subscription request ended up with ServiceFault: %s", header)));
                    } else {
                        LOGGER.error("Remote party returned an error '{}'", (Object)reply);
                        future.completeExceptionally(new PlcRuntimeException(String.format("Remote party returned an error '%s'", reply)));
                    }
                }
                catch (ParseException e) {
                    LOGGER.error("error parsing", (Throwable)e);
                }
            };
            Consumer<TimeoutException> timeout = e -> {
                LOGGER.error("Timeout while waiting on the crate subscription response", (Throwable)e);
                future.completeExceptionally((Throwable)e);
            };
            BiConsumer<OpcuaAPU, Throwable> error = (message, e) -> {
                LOGGER.error("Error while creating the subscription", e);
                future.completeExceptionally((Throwable)e);
            };
            this.channel.submit((ConversationContext<OpcuaAPU>)this.context, timeout, error, consumer, buffer);
        }
        catch (SerializationException e2) {
            LOGGER.error("Error while creating the subscription", (Throwable)e2);
            future.completeExceptionally(e2);
        }
        return future;
    }

    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        unsubscriptionRequest.getSubscriptionHandles().forEach(o -> {
            OpcuaSubscriptionHandle opcuaSubHandle = (OpcuaSubscriptionHandle)((Object)o);
            opcuaSubHandle.stopSubscriber();
        });
        return null;
    }

    public void removeSubscription(Long subscriptionId) {
        this.subscriptions.remove(subscriptionId);
    }

    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        LinkedList<PlcConsumerRegistration> registrations = new LinkedList<PlcConsumerRegistration>();
        for (PlcSubscriptionHandle subscriptionHandle : handles) {
            LOGGER.debug("Registering Consumer");
            PlcConsumerRegistration consumerRegistration = subscriptionHandle.register(consumer);
            registrations.add(consumerRegistration);
        }
        return new DefaultPlcConsumerRegistration((PlcSubscriber)this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
    }

    public void unregister(PlcConsumerRegistration registration) {
        registration.unregister();
    }

    public static long getDateTime(long dateTime) {
        return (dateTime - 116444736000000000L) / 10000L;
    }

    private GuidValue toGuidValue(String identifier) {
        LOGGER.error("Querying Guid nodes is not supported");
        byte[] data4 = new byte[2];
        byte[] data5 = new byte[6];
        return new GuidValue(0L, 0, 0, data4, data5);
    }
}

