/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HistoryReadRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "664";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final ExtensionObject historyReadDetails;
  protected final TimestampsToReturn timestampsToReturn;
  protected final boolean releaseContinuationPoints;
  protected final int noOfNodesToRead;
  protected final List<ExtensionObjectDefinition> nodesToRead;

  public HistoryReadRequest(
      ExtensionObjectDefinition requestHeader,
      ExtensionObject historyReadDetails,
      TimestampsToReturn timestampsToReturn,
      boolean releaseContinuationPoints,
      int noOfNodesToRead,
      List<ExtensionObjectDefinition> nodesToRead) {
    super();
    this.requestHeader = requestHeader;
    this.historyReadDetails = historyReadDetails;
    this.timestampsToReturn = timestampsToReturn;
    this.releaseContinuationPoints = releaseContinuationPoints;
    this.noOfNodesToRead = noOfNodesToRead;
    this.nodesToRead = nodesToRead;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public ExtensionObject getHistoryReadDetails() {
    return historyReadDetails;
  }

  public TimestampsToReturn getTimestampsToReturn() {
    return timestampsToReturn;
  }

  public boolean getReleaseContinuationPoints() {
    return releaseContinuationPoints;
  }

  public int getNoOfNodesToRead() {
    return noOfNodesToRead;
  }

  public List<ExtensionObjectDefinition> getNodesToRead() {
    return nodesToRead;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HistoryReadRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (historyReadDetails)
    writeSimpleField(
        "historyReadDetails", historyReadDetails, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (timestampsToReturn)
    writeSimpleEnumField(
        "timestampsToReturn",
        "TimestampsToReturn",
        timestampsToReturn,
        new DataWriterEnumDefault<>(
            TimestampsToReturn::getValue,
            TimestampsToReturn::name,
            writeUnsignedLong(writeBuffer, 32)));

    // Reserved Field (reserved)
    writeReservedField("reserved", (byte) 0x00, writeUnsignedByte(writeBuffer, 7));

    // Simple Field (releaseContinuationPoints)
    writeSimpleField(
        "releaseContinuationPoints", releaseContinuationPoints, writeBoolean(writeBuffer));

    // Simple Field (noOfNodesToRead)
    writeSimpleField("noOfNodesToRead", noOfNodesToRead, writeSignedInt(writeBuffer, 32));

    // Array Field (nodesToRead)
    writeComplexTypeArrayField("nodesToRead", nodesToRead, writeBuffer);

    writeBuffer.popContext("HistoryReadRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    HistoryReadRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (historyReadDetails)
    lengthInBits += historyReadDetails.getLengthInBits();

    // Simple field (timestampsToReturn)
    lengthInBits += 32;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (releaseContinuationPoints)
    lengthInBits += 1;

    // Simple field (noOfNodesToRead)
    lengthInBits += 32;

    // Array field
    if (nodesToRead != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : nodesToRead) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= nodesToRead.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("HistoryReadRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    ExtensionObject historyReadDetails =
        readSimpleField(
            "historyReadDetails",
            new DataReaderComplexDefault<>(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    TimestampsToReturn timestampsToReturn =
        readEnumField(
            "timestampsToReturn",
            "TimestampsToReturn",
            new DataReaderEnumDefault<>(
                TimestampsToReturn::enumForValue, readUnsignedLong(readBuffer, 32)));

    Byte reservedField0 =
        readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0x00);

    boolean releaseContinuationPoints =
        readSimpleField("releaseContinuationPoints", readBoolean(readBuffer));

    int noOfNodesToRead = readSimpleField("noOfNodesToRead", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> nodesToRead =
        readCountArrayField(
            "nodesToRead",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("637")),
                readBuffer),
            noOfNodesToRead);

    readBuffer.closeContext("HistoryReadRequest");
    // Create the instance
    return new HistoryReadRequestBuilderImpl(
        requestHeader,
        historyReadDetails,
        timestampsToReturn,
        releaseContinuationPoints,
        noOfNodesToRead,
        nodesToRead);
  }

  public static class HistoryReadRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final ExtensionObject historyReadDetails;
    private final TimestampsToReturn timestampsToReturn;
    private final boolean releaseContinuationPoints;
    private final int noOfNodesToRead;
    private final List<ExtensionObjectDefinition> nodesToRead;

    public HistoryReadRequestBuilderImpl(
        ExtensionObjectDefinition requestHeader,
        ExtensionObject historyReadDetails,
        TimestampsToReturn timestampsToReturn,
        boolean releaseContinuationPoints,
        int noOfNodesToRead,
        List<ExtensionObjectDefinition> nodesToRead) {
      this.requestHeader = requestHeader;
      this.historyReadDetails = historyReadDetails;
      this.timestampsToReturn = timestampsToReturn;
      this.releaseContinuationPoints = releaseContinuationPoints;
      this.noOfNodesToRead = noOfNodesToRead;
      this.nodesToRead = nodesToRead;
    }

    public HistoryReadRequest build() {
      HistoryReadRequest historyReadRequest =
          new HistoryReadRequest(
              requestHeader,
              historyReadDetails,
              timestampsToReturn,
              releaseContinuationPoints,
              noOfNodesToRead,
              nodesToRead);
      return historyReadRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HistoryReadRequest)) {
      return false;
    }
    HistoryReadRequest that = (HistoryReadRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getHistoryReadDetails() == that.getHistoryReadDetails())
        && (getTimestampsToReturn() == that.getTimestampsToReturn())
        && (getReleaseContinuationPoints() == that.getReleaseContinuationPoints())
        && (getNoOfNodesToRead() == that.getNoOfNodesToRead())
        && (getNodesToRead() == that.getNodesToRead())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getRequestHeader(),
        getHistoryReadDetails(),
        getTimestampsToReturn(),
        getReleaseContinuationPoints(),
        getNoOfNodesToRead(),
        getNodesToRead());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
