/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesMethod {
  ProgramStateMachineType_Start((int) 2426L),
  ProgramStateMachineType_Suspend((int) 2427L),
  ProgramStateMachineType_Resume((int) 2428L),
  ProgramStateMachineType_Halt((int) 2429L),
  ProgramStateMachineType_Reset((int) 2430L),
  ShelvedStateMachineType_Unshelve((int) 2947L),
  ShelvedStateMachineType_OneShotShelve((int) 2948L),
  ShelvedStateMachineType_TimedShelve((int) 2949L),
  AddCommentMethodType((int) 3863L),
  ConditionType_ConditionRefresh((int) 3875L),
  TimedShelveMethodType((int) 6102L),
  ConditionRefreshMethodType((int) 9007L),
  ConditionType_Enable((int) 9027L),
  ConditionType_Disable((int) 9028L),
  ConditionType_AddComment((int) 9029L),
  DialogResponseMethodType((int) 9031L),
  DialogConditionType_Respond((int) 9069L),
  AcknowledgeableConditionType_Acknowledge((int) 9111L),
  AcknowledgeableConditionType_Confirm((int) 9113L),
  AlarmConditionType_ShelvingState_Unshelve((int) 9211L),
  AlarmConditionType_ShelvingState_OneShotShelve((int) 9212L),
  AlarmConditionType_ShelvingState_TimedShelve((int) 9213L),
  ServerType_GetMonitoredItems((int) 11489L),
  Server_GetMonitoredItems((int) 11492L),
  GetMonitoredItemsMethodType((int) 11495L),
  FileType_Open((int) 11580L),
  FileType_Close((int) 11583L),
  FileType_Read((int) 11585L),
  FileType_Write((int) 11588L),
  FileType_GetPosition((int) 11590L),
  FileType_SetPosition((int) 11593L),
  AddressSpaceFileType_ExportNamespace((int) 11615L),
  NamespaceMetadataType_NamespaceFile_Open((int) 11629L),
  NamespaceMetadataType_NamespaceFile_Close((int) 11632L),
  NamespaceMetadataType_NamespaceFile_Read((int) 11634L),
  NamespaceMetadataType_NamespaceFile_Write((int) 11637L),
  NamespaceMetadataType_NamespaceFile_GetPosition((int) 11639L),
  NamespaceMetadataType_NamespaceFile_SetPosition((int) 11642L),
  NamespaceMetadataType_NamespaceFile_ExportNamespace((int) 11644L),
  NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Open((int) 11659L),
  NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Close((int) 11662L),
  NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Read((int) 11664L),
  NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_Write((int) 11667L),
  NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_GetPosition((int) 11669L),
  NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_SetPosition((int) 11672L),
  NamespacesType_NamespaceIdentifier_Placeholder_NamespaceFile_ExportNamespace((int) 11674L),
  OpenMethodType((int) 11738L),
  CloseMethodType((int) 11741L),
  ReadMethodType((int) 11743L),
  WriteMethodType((int) 11746L),
  GetPositionMethodType((int) 11748L),
  SetPositionMethodType((int) 11751L),
  OpenWithMasksMethodType((int) 12513L),
  CloseAndUpdateMethodType((int) 12516L),
  AddCertificateMethodType((int) 12518L),
  RemoveCertificateMethodType((int) 12520L),
  TrustListType_OpenWithMasks((int) 12543L),
  TrustListType_CloseAndUpdate((int) 12546L),
  TrustListType_AddCertificate((int) 12548L),
  TrustListType_RemoveCertificate((int) 12550L),
  UpdateCertificateMethodType((int) 12578L),
  ServerConfigurationType_UpdateCertificate((int) 12616L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Open((int) 12647L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Close((int) 12650L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Read((int) 12652L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_Write((int) 12655L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition((int) 12657L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition((int) 12660L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks(
      (int) 12663L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate(
      (int) 12666L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate(
      (int) 12668L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate(
      (int) 12670L),
  ServerConfigurationType_CreateSigningRequest((int) 12731L),
  ServerConfigurationType_ApplyChanges((int) 12734L),
  ServerConfiguration_CreateSigningRequest((int) 12737L),
  ServerConfiguration_ApplyChanges((int) 12740L),
  CreateSigningRequestMethodType((int) 12741L),
  ServerType_SetSubscriptionDurable((int) 12746L),
  Server_SetSubscriptionDurable((int) 12749L),
  SetSubscriptionDurableMethodType((int) 12752L),
  GetRejectedListMethodType((int) 12773L),
  ServerConfigurationType_GetRejectedList((int) 12775L),
  ServerConfiguration_GetRejectedList((int) 12777L),
  ServerType_ResendData((int) 12871L),
  Server_ResendData((int) 12873L),
  ResendDataMethodType((int) 12875L),
  ServerType_RequestServerStateChange((int) 12883L),
  Server_RequestServerStateChange((int) 12886L),
  RequestServerStateChangeMethodType((int) 12888L),
  ConditionType_ConditionRefresh2((int) 12912L),
  ConditionRefresh2MethodType((int) 12914L),
  CreateDirectoryMethodType((int) 13342L),
  CreateFileMethodType((int) 13345L),
  DeleteFileMethodType((int) 13348L),
  MoveOrCopyMethodType((int) 13350L),
  FileDirectoryType_FileDirectoryName_Placeholder_CreateDirectory((int) 13355L),
  FileDirectoryType_FileDirectoryName_Placeholder_CreateFile((int) 13358L),
  FileDirectoryType_FileDirectoryName_Placeholder_MoveOrCopy((int) 13363L),
  FileDirectoryType_FileName_Placeholder_Open((int) 13372L),
  FileDirectoryType_FileName_Placeholder_Close((int) 13375L),
  FileDirectoryType_FileName_Placeholder_Read((int) 13377L),
  FileDirectoryType_FileName_Placeholder_Write((int) 13380L),
  FileDirectoryType_FileName_Placeholder_GetPosition((int) 13382L),
  FileDirectoryType_FileName_Placeholder_SetPosition((int) 13385L),
  FileDirectoryType_CreateDirectory((int) 13387L),
  FileDirectoryType_CreateFile((int) 13390L),
  FileDirectoryType_DeleteFileSystemObject((int) 13393L),
  FileDirectoryType_MoveOrCopy((int) 13395L),
  CertificateGroupType_TrustList_Open((int) 13605L),
  CertificateGroupType_TrustList_Close((int) 13608L),
  CertificateGroupType_TrustList_Read((int) 13610L),
  CertificateGroupType_TrustList_Write((int) 13613L),
  CertificateGroupType_TrustList_GetPosition((int) 13615L),
  CertificateGroupType_TrustList_SetPosition((int) 13618L),
  CertificateGroupType_TrustList_OpenWithMasks((int) 13621L),
  CertificateGroupType_TrustList_CloseAndUpdate((int) 13624L),
  CertificateGroupType_TrustList_AddCertificate((int) 13627L),
  CertificateGroupType_TrustList_RemoveCertificate((int) 13629L),
  ServerConfiguration_UpdateCertificate((int) 13737L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Open((int) 13821L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Close((int) 13824L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Read((int) 13826L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_Write((int) 13829L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_GetPosition((int) 13831L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_SetPosition((int) 13834L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_OpenWithMasks((int) 13837L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_CloseAndUpdate((int) 13840L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_AddCertificate((int) 13843L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustList_RemoveCertificate((int) 13845L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Open((int) 13855L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Close((int) 13858L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Read((int) 13860L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_Write((int) 13863L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_GetPosition((int) 13865L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_SetPosition((int) 13868L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_OpenWithMasks((int) 13871L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_CloseAndUpdate((int) 13874L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_AddCertificate((int) 13877L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustList_RemoveCertificate((int) 13879L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Open((int) 13889L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Close((int) 13892L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Read((int) 13894L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_Write((int) 13897L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_GetPosition((int) 13899L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_SetPosition((int) 13902L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_OpenWithMasks((int) 13905L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_CloseAndUpdate((int) 13908L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_AddCertificate((int) 13911L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustList_RemoveCertificate((int) 13913L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Open((int) 13923L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Close((int) 13926L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Read((int) 13928L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_Write((int) 13931L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_GetPosition((int) 13933L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_SetPosition((int) 13936L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_OpenWithMasks((int) 13939L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_CloseAndUpdate((int) 13942L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_AddCertificate((int) 13945L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustList_RemoveCertificate((int) 13947L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Open((int) 13958L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Close((int) 13961L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Read((int) 13963L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_Write((int) 13966L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition(
      (int) 13968L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition(
      (int) 13971L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks(
      (int) 13974L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate(
      (int) 13977L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate(
      (int) 13980L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate(
      (int) 13982L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Open((int) 13992L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Close((int) 13995L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Read((int) 13997L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_Write((int) 14000L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition((int) 14002L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition((int) 14005L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks((int) 14008L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate(
      (int) 14011L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate(
      (int) 14014L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate(
      (int) 14016L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Open((int) 14026L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Close((int) 14029L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Read((int) 14031L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_Write((int) 14034L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition(
      (int) 14036L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition(
      (int) 14039L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks(
      (int) 14042L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate(
      (int) 14045L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate(
      (int) 14048L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate(
      (int) 14050L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Open((int) 14095L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Close((int) 14098L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Read((int) 14100L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_Write((int) 14103L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition((int) 14105L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition((int) 14108L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks((int) 14111L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate((int) 14114L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate((int) 14117L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate((int) 14119L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Open((int) 14129L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Close((int) 14132L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Read((int) 14134L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_Write((int) 14137L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition((int) 14139L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition((int) 14142L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks((int) 14145L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate(
      (int) 14148L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate(
      (int) 14151L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate(
      (int) 14153L),
  RemoveConnectionMethodType((int) 14183L),
  PubSubConnectionType_RemoveGroup((int) 14225L),
  PublishSubscribeType_ConnectionName_Placeholder_Status_Enable((int) 14421L),
  PublishSubscribeType_ConnectionName_Placeholder_Status_Disable((int) 14422L),
  PublishSubscribeType_ConnectionName_Placeholder_RemoveGroup((int) 14424L),
  PublishSubscribeType_RemoveConnection((int) 14432L),
  PublishSubscribeType_PublishedDataSets_AddPublishedDataItems((int) 14435L),
  PublishSubscribeType_PublishedDataSets_AddPublishedEvents((int) 14438L),
  PublishSubscribeType_PublishedDataSets_RemovePublishedDataSet((int) 14441L),
  DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItems((int) 14479L),
  DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEvents((int) 14482L),
  DataSetFolderType_DataSetFolderName_Placeholder_RemovePublishedDataSet((int) 14485L),
  DataSetFolderType_AddPublishedDataItems((int) 14493L),
  DataSetFolderType_AddPublishedEvents((int) 14496L),
  DataSetFolderType_RemovePublishedDataSet((int) 14499L),
  AddPublishedDataItemsMethodType((int) 14501L),
  AddPublishedEventsMethodType((int) 14504L),
  RemovePublishedDataSetMethodType((int) 14507L),
  PublishedDataItemsType_AddVariables((int) 14555L),
  PublishedDataItemsType_RemoveVariables((int) 14558L),
  PublishedDataItemsAddVariablesMethodType((int) 14564L),
  PublishedDataItemsRemoveVariablesMethodType((int) 14567L),
  PubSubConnectionType_Status_Enable((int) 14602L),
  PubSubConnectionType_Status_Disable((int) 14603L),
  PubSubConnectionTypeRemoveGroupMethodType((int) 14604L),
  PubSubGroupTypeRemoveWriterMethodType((int) 14623L),
  PubSubGroupTypeRemoveReaderMethodType((int) 14625L),
  PubSubStatusType_Enable((int) 14645L),
  PubSubStatusType_Disable((int) 14646L),
  PublishedEventsType_ModifyFieldSelection((int) 15052L),
  PublishedEventsTypeModifyFieldSelectionMethodType((int) 15054L),
  TargetVariablesType_AddTargetVariables((int) 15115L),
  TargetVariablesType_RemoveTargetVariables((int) 15118L),
  TargetVariablesTypeAddTargetVariablesMethodType((int) 15121L),
  TargetVariablesTypeRemoveTargetVariablesMethodType((int) 15124L),
  PublishSubscribe_GetSecurityKeys((int) 15215L),
  GetSecurityKeysMethodType((int) 15218L),
  PublishedDataSetType_DataSetWriterName_Placeholder_Status_Enable((int) 15225L),
  PublishedDataSetType_DataSetWriterName_Placeholder_Status_Disable((int) 15226L),
  CreateCredentialMethodType((int) 15248L),
  PubSubGroupType_Status_Enable((int) 15267L),
  PubSubGroupType_Status_Disable((int) 15268L),
  DataSetWriterType_Status_Enable((int) 15301L),
  DataSetWriterType_Status_Disable((int) 15302L),
  DataSetReaderType_Status_Enable((int) 15309L),
  DataSetReaderType_Status_Disable((int) 15310L),
  PublishSubscribe_GetSecurityGroup((int) 15440L),
  PublishSubscribe_SecurityGroups_AddSecurityGroup((int) 15444L),
  PublishSubscribe_SecurityGroups_RemoveSecurityGroup((int) 15447L),
  GetSecurityGroupMethodType((int) 15449L),
  SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroup((int) 15454L),
  SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroup((int) 15457L),
  SecurityGroupFolderType_AddSecurityGroup((int) 15461L),
  SecurityGroupFolderType_RemoveSecurityGroup((int) 15464L),
  AddSecurityGroupMethodType((int) 15466L),
  RemoveSecurityGroupMethodType((int) 15469L),
  DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_AddExtensionField(
      (int) 15474L),
  DataSetFolderType_PublishedDataSetName_Placeholder_ExtensionFields_RemoveExtensionField(
      (int) 15477L),
  PublishedDataSetType_ExtensionFields_AddExtensionField((int) 15482L),
  PublishedDataSetType_ExtensionFields_RemoveExtensionField((int) 15485L),
  ExtensionFieldsType_AddExtensionField((int) 15491L),
  ExtensionFieldsType_RemoveExtensionField((int) 15494L),
  AddExtensionFieldMethodType((int) 15496L),
  RemoveExtensionFieldMethodType((int) 15499L),
  RoleSetType_RoleName_Placeholder_AddIdentity((int) 15612L),
  RoleSetType_RoleName_Placeholder_RemoveIdentity((int) 15614L),
  RoleType_AddIdentity((int) 15624L),
  RoleType_RemoveIdentity((int) 15626L),
  AddIdentityMethodType((int) 15636L),
  RemoveIdentityMethodType((int) 15638L),
  WellKnownRole_Anonymous_AddIdentity((int) 15648L),
  WellKnownRole_Anonymous_RemoveIdentity((int) 15650L),
  WellKnownRole_AuthenticatedUser_AddIdentity((int) 15660L),
  WellKnownRole_AuthenticatedUser_RemoveIdentity((int) 15662L),
  WellKnownRole_Observer_AddIdentity((int) 15672L),
  WellKnownRole_Observer_RemoveIdentity((int) 15674L),
  WellKnownRole_Operator_AddIdentity((int) 15684L),
  WellKnownRole_Operator_RemoveIdentity((int) 15686L),
  WellKnownRole_Supervisor_AddIdentity((int) 15696L),
  WellKnownRole_Supervisor_RemoveIdentity((int) 15698L),
  WellKnownRole_SecurityAdmin_AddIdentity((int) 15708L),
  WellKnownRole_SecurityAdmin_RemoveIdentity((int) 15710L),
  WellKnownRole_ConfigureAdmin_AddIdentity((int) 15720L),
  WellKnownRole_ConfigureAdmin_RemoveIdentity((int) 15722L),
  TemporaryFileTransferType_GenerateFileForRead((int) 15746L),
  TemporaryFileTransferType_GenerateFileForWrite((int) 15749L),
  TemporaryFileTransferType_CloseAndCommit((int) 15751L),
  TemporaryFileTransferType_TransferState_Placeholder_Reset((int) 15794L),
  GenerateFileForReadMethodType((int) 15795L),
  GenerateFileForWriteMethodType((int) 15798L),
  CloseAndCommitMethodType((int) 15800L),
  FileTransferStateMachineType_Reset((int) 15843L),
  PublishSubscribeType_Status_Enable((int) 15846L),
  PublishSubscribeType_Status_Disable((int) 15847L),
  PubSubKeyServiceType_GetSecurityKeys((int) 15907L),
  PubSubKeyServiceType_GetSecurityGroup((int) 15910L),
  PubSubKeyServiceType_SecurityGroups_AddSecurityGroup((int) 15914L),
  PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroup((int) 15917L),
  OPCUANamespaceMetadata_NamespaceFile_Open((int) 15971L),
  OPCUANamespaceMetadata_NamespaceFile_Close((int) 15974L),
  OPCUANamespaceMetadata_NamespaceFile_Read((int) 15976L),
  OPCUANamespaceMetadata_NamespaceFile_Write((int) 15979L),
  OPCUANamespaceMetadata_NamespaceFile_GetPosition((int) 15981L),
  OPCUANamespaceMetadata_NamespaceFile_SetPosition((int) 15984L),
  OPCUANamespaceMetadata_NamespaceFile_ExportNamespace((int) 15986L),
  RoleSetType_AddRole((int) 15997L),
  RoleSetType_RemoveRole((int) 16000L),
  AddRoleMethodType((int) 16002L),
  RemoveRoleMethodType((int) 16005L),
  WellKnownRole_Engineer_AddIdentity((int) 16041L),
  WellKnownRole_Engineer_RemoveIdentity((int) 16043L),
  RoleSetType_RoleName_Placeholder_AddApplication((int) 16165L),
  RoleSetType_RoleName_Placeholder_RemoveApplication((int) 16167L),
  RoleSetType_RoleName_Placeholder_AddEndpoint((int) 16169L),
  RoleSetType_RoleName_Placeholder_RemoveEndpoint((int) 16171L),
  RoleType_AddApplication((int) 16176L),
  RoleType_RemoveApplication((int) 16178L),
  RoleType_AddEndpoint((int) 16180L),
  RoleType_RemoveEndpoint((int) 16182L),
  AddApplicationMethodType((int) 16184L),
  RemoveApplicationMethodType((int) 16186L),
  AddEndpointMethodType((int) 16188L),
  RemoveEndpointMethodType((int) 16190L),
  WellKnownRole_Anonymous_AddApplication((int) 16195L),
  WellKnownRole_Anonymous_RemoveApplication((int) 16197L),
  WellKnownRole_Anonymous_AddEndpoint((int) 16199L),
  WellKnownRole_Anonymous_RemoveEndpoint((int) 16201L),
  WellKnownRole_AuthenticatedUser_AddApplication((int) 16206L),
  WellKnownRole_AuthenticatedUser_RemoveApplication((int) 16208L),
  WellKnownRole_AuthenticatedUser_AddEndpoint((int) 16210L),
  WellKnownRole_AuthenticatedUser_RemoveEndpoint((int) 16212L),
  WellKnownRole_Observer_AddApplication((int) 16217L),
  WellKnownRole_Observer_RemoveApplication((int) 16219L),
  WellKnownRole_Observer_AddEndpoint((int) 16221L),
  WellKnownRole_Observer_RemoveEndpoint((int) 16223L),
  WellKnownRole_Operator_AddApplication((int) 16228L),
  WellKnownRole_Operator_RemoveApplication((int) 16230L),
  WellKnownRole_Operator_AddEndpoint((int) 16232L),
  WellKnownRole_Operator_RemoveEndpoint((int) 16234L),
  WellKnownRole_Engineer_AddApplication((int) 16239L),
  WellKnownRole_Engineer_RemoveApplication((int) 16241L),
  WellKnownRole_Engineer_AddEndpoint((int) 16243L),
  WellKnownRole_Engineer_RemoveEndpoint((int) 16245L),
  WellKnownRole_Supervisor_AddApplication((int) 16250L),
  WellKnownRole_Supervisor_RemoveApplication((int) 16252L),
  WellKnownRole_Supervisor_AddEndpoint((int) 16254L),
  WellKnownRole_Supervisor_RemoveEndpoint((int) 16256L),
  WellKnownRole_SecurityAdmin_AddApplication((int) 16261L),
  WellKnownRole_SecurityAdmin_RemoveApplication((int) 16263L),
  WellKnownRole_SecurityAdmin_AddEndpoint((int) 16265L),
  WellKnownRole_SecurityAdmin_RemoveEndpoint((int) 16267L),
  WellKnownRole_ConfigureAdmin_AddApplication((int) 16272L),
  WellKnownRole_ConfigureAdmin_RemoveApplication((int) 16274L),
  WellKnownRole_ConfigureAdmin_AddEndpoint((int) 16276L),
  WellKnownRole_ConfigureAdmin_RemoveEndpoint((int) 16278L),
  ServerType_ServerCapabilities_RoleSet_AddRole((int) 16290L),
  ServerType_ServerCapabilities_RoleSet_RemoveRole((int) 16293L),
  ServerCapabilitiesType_RoleSet_AddRole((int) 16296L),
  ServerCapabilitiesType_RoleSet_RemoveRole((int) 16299L),
  Server_ServerCapabilities_RoleSet_AddRole((int) 16301L),
  Server_ServerCapabilities_RoleSet_RemoveRole((int) 16304L),
  FileSystem_CreateDirectory((int) 16348L),
  FileSystem_CreateFile((int) 16351L),
  FileSystem_DeleteFileSystemObject((int) 16354L),
  FileSystem_MoveOrCopy((int) 16356L),
  AlarmConditionType_Silence((int) 16402L),
  AlarmConditionType_Suppress((int) 16403L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Disable((int) 16439L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Enable((int) 16440L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment((int) 16441L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge((int) 16461L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm((int) 16463L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve((int) 16515L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve((int) 16516L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve((int) 16517L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Silence((int) 16533L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress((int) 16534L),
  PublishSubscribeType_ConnectionName_Placeholder_AddWriterGroup((int) 16535L),
  PublishSubscribeType_ConnectionName_Placeholder_AddReaderGroup((int) 16560L),
  PublishSubscribeType_AddConnection((int) 16598L),
  PublishSubscribeType_PublishedDataSets_AddPublishedDataItemsTemplate((int) 16601L),
  PublishSubscribeType_PublishedDataSets_AddPublishedEventsTemplate((int) 16639L),
  PublishSubscribeType_PublishedDataSets_AddDataSetFolder((int) 16651L),
  PublishSubscribeType_PublishedDataSets_RemoveDataSetFolder((int) 16680L),
  AddConnectionMethodType((int) 16691L),
  DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedDataItemsTemplate((int) 16842L),
  DataSetFolderType_DataSetFolderName_Placeholder_AddPublishedEventsTemplate((int) 16881L),
  DataSetFolderType_DataSetFolderName_Placeholder_AddDataSetFolder((int) 16884L),
  DataSetFolderType_DataSetFolderName_Placeholder_RemoveDataSetFolder((int) 16923L),
  DataSetFolderType_AddPublishedDataItemsTemplate((int) 16935L),
  DataSetFolderType_AddPublishedEventsTemplate((int) 16960L),
  DataSetFolderType_AddDataSetFolder((int) 16994L),
  DataSetFolderType_RemoveDataSetFolder((int) 16997L),
  AddPublishedDataItemsTemplateMethodType((int) 17030L),
  AddPublishedEventsTemplateMethodType((int) 17033L),
  AddDataSetFolderMethodType((int) 17067L),
  RemoveDataSetFolderMethodType((int) 17079L),
  PubSubConnectionType_WriterGroupName_Placeholder_AddDataSetWriter((int) 17293L),
  PublishSubscribeType_SetSecurityKeys((int) 17296L),
  SetSecurityKeysMethodType((int) 17298L),
  PubSubConnectionType_WriterGroupName_Placeholder_Status_Enable((int) 17316L),
  PubSubConnectionType_WriterGroupName_Placeholder_Status_Disable((int) 17317L),
  PubSubConnectionType_WriterGroupName_Placeholder_RemoveDataSetWriter((int) 17323L),
  PubSubConnectionType_ReaderGroupName_Placeholder_Status_Enable((int) 17331L),
  PubSubConnectionType_ReaderGroupName_Placeholder_Status_Disable((int) 17332L),
  PubSubConnectionType_ReaderGroupName_Placeholder_RemoveDataSetReader((int) 17333L),
  PubSubConnectionType_ReaderGroupName_Placeholder_AddDataSetReader((int) 17355L),
  PublishSubscribe_SetSecurityKeys((int) 17364L),
  PublishSubscribe_AddConnection((int) 17366L),
  PublishSubscribe_RemoveConnection((int) 17369L),
  PublishSubscribe_PublishedDataSets_AddPublishedDataItems((int) 17372L),
  PublishSubscribe_PublishedDataSets_AddPublishedEvents((int) 17375L),
  PublishSubscribe_PublishedDataSets_AddPublishedDataItemsTemplate((int) 17378L),
  PublishSubscribe_PublishedDataSets_AddPublishedEventsTemplate((int) 17381L),
  PublishSubscribe_PublishedDataSets_RemovePublishedDataSet((int) 17384L),
  DataSetReaderType_CreateTargetVariables((int) 17386L),
  DataSetReaderType_CreateDataSetMirror((int) 17389L),
  DataSetReaderTypeCreateTargetVariablesMethodType((int) 17392L),
  DataSetReaderTypeCreateDataSetMirrorMethodType((int) 17395L),
  PublishSubscribe_PublishedDataSets_AddDataSetFolder((int) 17398L),
  PublishSubscribe_PublishedDataSets_RemoveDataSetFolder((int) 17403L),
  PublishSubscribe_Status_Enable((int) 17407L),
  PublishSubscribe_Status_Disable((int) 17408L),
  PublishSubscribe_Diagnostics_Reset((int) 17421L),
  PubSubConnectionType_AddWriterGroup((int) 17427L),
  PubSubConnectionType_AddReaderGroup((int) 17465L),
  KeyCredentialConfigurationFolderType_ServiceName_Placeholder_GetEncryptingKey((int) 17516L),
  KeyCredentialConfigurationFolderType_ServiceName_Placeholder_UpdateCredential((int) 17519L),
  KeyCredentialConfigurationFolderType_ServiceName_Placeholder_DeleteCredential((int) 17521L),
  KeyCredentialConfigurationFolderType_CreateCredential((int) 17522L),
  KeyCredentialConfiguration_CreateCredential((int) 17528L),
  GetEncryptingKeyMethodType((int) 17531L),
  KeyCredentialConfigurationType_GetEncryptingKey((int) 17534L),
  PubSubConnectionTypeAddWriterGroupMethodType((int) 17561L),
  PubSubConnectionAddReaderGroupGroupMethodType((int) 17630L),
  FileDirectoryType_FileDirectoryName_Placeholder_DeleteFileSystemObject((int) 17718L),
  WriterGroupType_DataSetWriterName_Placeholder_Status_Enable((int) 17751L),
  WriterGroupType_DataSetWriterName_Placeholder_Status_Disable((int) 17752L),
  WriterGroupType_DataSetWriterName_Placeholder_Diagnostics_Reset((int) 17765L),
  WriterGroupType_Diagnostics_Reset((int) 17824L),
  AlarmConditionType_Unsuppress((int) 17868L),
  AlarmConditionType_RemoveFromService((int) 17869L),
  AlarmConditionType_PlaceInService((int) 17870L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress((int) 17875L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService((int) 17876L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService((int) 17877L),
  WriterGroupType_AddDataSetWriter((int) 17969L),
  WriterGroupType_RemoveDataSetWriter((int) 17992L),
  PubSubGroupTypeAddWriterMethodType((int) 17994L),
  KeyCredentialConfigurationType_UpdateCredential((int) 18006L),
  KeyCredentialConfigurationType_DeleteCredential((int) 18008L),
  KeyCredentialUpdateMethodType((int) 18009L),
  ReaderGroupType_DataSetReaderName_Placeholder_Status_Enable((int) 18090L),
  ReaderGroupType_DataSetReaderName_Placeholder_Status_Disable((int) 18091L),
  ReaderGroupType_DataSetReaderName_Placeholder_Diagnostics_Reset((int) 18104L),
  AlarmConditionType_Reset((int) 18199L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Reset((int) 18212L),
  AlarmMetricsType_Reset((int) 18666L),
  PublishSubscribeType_ConnectionName_Placeholder_Diagnostics_Reset((int) 18679L),
  PublishSubscribeType_Diagnostics_Reset((int) 18727L),
  PublishedDataSetType_DataSetWriterName_Placeholder_Diagnostics_Reset((int) 18883L),
  PubSubConnectionType_WriterGroupName_Placeholder_Diagnostics_Reset((int) 19119L),
  PubSubConnectionType_ReaderGroupName_Placeholder_Diagnostics_Reset((int) 19188L),
  PubSubConnectionType_Diagnostics_Reset((int) 19253L),
  CertificateGroupType_CertificateExpired_Disable((int) 19483L),
  CertificateGroupType_CertificateExpired_Enable((int) 19484L),
  CertificateGroupType_CertificateExpired_AddComment((int) 19485L),
  CertificateGroupType_CertificateExpired_Acknowledge((int) 19505L),
  CertificateGroupType_CertificateExpired_Confirm((int) 19507L),
  DataSetWriterType_Diagnostics_Reset((int) 19562L),
  DataSetReaderType_Diagnostics_Reset((int) 19621L),
  PubSubDiagnosticsType_Reset((int) 19689L),
  CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve((int) 20097L),
  CertificateGroupType_CertificateExpired_ShelvingState_Unshelve((int) 20099L),
  CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve((int) 20100L),
  CertificateGroupType_CertificateExpired_Silence((int) 20132L),
  CertificateGroupType_CertificateExpired_Suppress((int) 20133L),
  CertificateGroupType_CertificateExpired_Unsuppress((int) 20134L),
  CertificateGroupType_CertificateExpired_RemoveFromService((int) 20135L),
  CertificateGroupType_CertificateExpired_PlaceInService((int) 20136L),
  CertificateGroupType_CertificateExpired_Reset((int) 20137L),
  CertificateGroupType_TrustListOutOfDate_Disable((int) 20176L),
  CertificateGroupType_TrustListOutOfDate_Enable((int) 20177L),
  CertificateGroupType_TrustListOutOfDate_AddComment((int) 20178L),
  CertificateGroupType_TrustListOutOfDate_Acknowledge((int) 20198L),
  CertificateGroupType_TrustListOutOfDate_Confirm((int) 20200L),
  CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve((int) 20245L),
  CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve((int) 20247L),
  CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve((int) 20248L),
  CertificateGroupType_TrustListOutOfDate_Silence((int) 20280L),
  CertificateGroupType_TrustListOutOfDate_Suppress((int) 20281L),
  CertificateGroupType_TrustListOutOfDate_Unsuppress((int) 20282L),
  CertificateGroupType_TrustListOutOfDate_RemoveFromService((int) 20283L),
  CertificateGroupType_TrustListOutOfDate_PlaceInService((int) 20284L),
  CertificateGroupType_TrustListOutOfDate_Reset((int) 20285L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Disable((int) 20324L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Enable((int) 20325L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_AddComment((int) 20326L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Acknowledge((int) 20346L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Confirm((int) 20348L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 20393L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 20395L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 20396L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Silence((int) 20430L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress((int) 20431L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress((int) 20432L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService(
      (int) 20433L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService(
      (int) 20434L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset((int) 20435L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Disable((int) 20474L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Enable((int) 20475L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_AddComment((int) 20476L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge((int) 20496L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Confirm((int) 20498L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 20543L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 20545L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 20546L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Silence((int) 20578L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress((int) 20579L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress((int) 20580L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService(
      (int) 20581L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService(
      (int) 20582L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset((int) 20583L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Disable((int) 20622L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Enable((int) 20623L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_AddComment((int) 20624L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Acknowledge((int) 20644L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Confirm((int) 20646L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 20691L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 20693L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 20694L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Silence((int) 20726L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress((int) 20727L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress((int) 20728L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService((int) 20729L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService((int) 20730L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset((int) 20731L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Disable((int) 20770L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Enable((int) 20771L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_AddComment((int) 20772L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge((int) 20792L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Confirm((int) 20794L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 20839L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 20841L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 20842L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Silence((int) 20874L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress((int) 20875L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress((int) 20876L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService((int) 20877L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService((int) 20878L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset((int) 20879L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Disable((int) 20918L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Enable((int) 20919L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_AddComment((int) 20920L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Acknowledge((int) 20940L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Confirm((int) 20942L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 20987L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 20989L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 20990L),
  ReaderGroupType_DataSetReaderName_Placeholder_CreateTargetVariables((int) 21009L),
  ReaderGroupType_DataSetReaderName_Placeholder_CreateDataSetMirror((int) 21012L),
  ReaderGroupType_Diagnostics_Reset((int) 21027L),
  ReaderGroupType_AddDataSetReader((int) 21082L),
  ReaderGroupType_RemoveDataSetReader((int) 21085L),
  PubSubGroupTypeAddReaderMethodType((int) 21087L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Silence((int) 21225L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress((int) 21226L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress((int) 21227L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService(
      (int) 21228L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService((int) 21229L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset((int) 21230L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Disable((int) 21269L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Enable((int) 21270L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_AddComment((int) 21271L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge((int) 21291L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Confirm((int) 21293L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 21338L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 21340L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 21341L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Silence((int) 21373L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress((int) 21374L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress((int) 21375L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService(
      (int) 21376L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService((int) 21377L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset((int) 21378L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Disable((int) 21417L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Enable((int) 21418L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_AddComment(
      (int) 21419L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Acknowledge(
      (int) 21439L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Confirm((int) 21441L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve(
      (int) 21486L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve(
      (int) 21488L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 21489L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Silence((int) 21521L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress((int) 21522L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress(
      (int) 21523L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService(
      (int) 21524L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService(
      (int) 21525L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset((int) 21526L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Disable((int) 21565L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Enable((int) 21566L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_AddComment(
      (int) 21567L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Acknowledge(
      (int) 21587L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Confirm((int) 21589L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 21634L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 21636L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 21637L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Silence((int) 21669L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress((int) 21670L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress(
      (int) 21671L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService(
      (int) 21672L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService(
      (int) 21673L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset((int) 21674L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable(
      (int) 21713L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable(
      (int) 21714L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment(
      (int) 21715L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge(
      (int) 21735L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm(
      (int) 21737L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 21782L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 21784L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 21785L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence(
      (int) 21817L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress(
      (int) 21818L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress(
      (int) 21819L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService(
      (int) 21820L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService(
      (int) 21821L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset(
      (int) 21822L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable(
      (int) 21861L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable(
      (int) 21862L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment(
      (int) 21863L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge(
      (int) 21883L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm(
      (int) 21885L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 21930L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 21932L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 21933L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence(
      (int) 21965L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress(
      (int) 21966L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress(
      (int) 21967L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService(
      (int) 21968L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService(
      (int) 21969L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset(
      (int) 21970L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable(
      (int) 22009L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable(
      (int) 22010L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment(
      (int) 22011L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge(
      (int) 22031L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm(
      (int) 22033L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 22078L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 22080L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 22081L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence(
      (int) 22113L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress(
      (int) 22114L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress(
      (int) 22115L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService(
      (int) 22116L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService(
      (int) 22117L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset(
      (int) 22118L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable(
      (int) 22157L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable(
      (int) 22158L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment(
      (int) 22159L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge(
      (int) 22179L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm(
      (int) 22181L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 22226L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 22228L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 22229L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence(
      (int) 22261L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress(
      (int) 22262L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress(
      (int) 22263L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService(
      (int) 22264L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService(
      (int) 22265L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset(
      (int) 22266L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable(
      (int) 22305L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable(
      (int) 22306L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment(
      (int) 22307L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge(
      (int) 22327L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm(
      (int) 22329L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 22374L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 22376L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 22377L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence(
      (int) 22409L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress(
      (int) 22410L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress(
      (int) 22411L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService(
      (int) 22412L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService(
      (int) 22413L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset(
      (int) 22414L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable(
      (int) 22453L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable(
      (int) 22454L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment(
      (int) 22455L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge(
      (int) 22475L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm(
      (int) 22477L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 22522L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 22524L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 22525L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence(
      (int) 22557L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress(
      (int) 22558L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress(
      (int) 22559L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService(
      (int) 22560L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService(
      (int) 22561L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset(
      (int) 22562L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable(
      (int) 22601L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable(
      (int) 22602L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment(
      (int) 22603L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge(
      (int) 22623L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm(
      (int) 22625L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 22670L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 22672L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 22673L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence(
      (int) 22705L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress(
      (int) 22706L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress(
      (int) 22707L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService(
      (int) 22708L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService(
      (int) 22709L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset(
      (int) 22710L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable(
      (int) 22749L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable(
      (int) 22750L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment(
      (int) 22751L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge(
      (int) 22771L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm(
      (int) 22773L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 22818L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 22820L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 22821L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence(
      (int) 22853L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress(
      (int) 22854L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress(
      (int) 22855L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService(
      (int) 22856L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService(
      (int) 22857L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset(
      (int) 22858L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable((int) 22897L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable((int) 22898L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment(
      (int) 22899L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge(
      (int) 22919L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm((int) 22921L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 22966L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 22968L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 22969L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence((int) 23001L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress((int) 23002L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress(
      (int) 23003L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService(
      (int) 23004L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService(
      (int) 23005L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset((int) 23006L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable((int) 23045L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable((int) 23046L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment(
      (int) 23047L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge(
      (int) 23067L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm((int) 23069L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 23114L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 23116L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 23117L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence((int) 23149L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress((int) 23150L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress(
      (int) 23151L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService(
      (int) 23152L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService(
      (int) 23153L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset((int) 23154L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable(
      (int) 23193L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable(
      (int) 23194L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment(
      (int) 23195L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge(
      (int) 23215L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm(
      (int) 23217L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 23262L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 23264L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 23265L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence(
      (int) 23297L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress(
      (int) 23298L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress(
      (int) 23299L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService(
      (int) 23300L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService(
      (int) 23301L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset(
      (int) 23302L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable(
      (int) 23341L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable(
      (int) 23342L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment(
      (int) 23343L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge(
      (int) 23363L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm(
      (int) 23365L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 23410L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 23412L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 23413L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence(
      (int) 23445L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress(
      (int) 23446L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress(
      (int) 23447L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService(
      (int) 23448L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService(
      (int) 23449L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset(
      (int) 23450L),
  AliasNameCategoryType_SubAliasNameCategories_Placeholder_FindAlias((int) 23459L),
  AliasNameCategoryType_FindAlias((int) 23462L),
  FindAliasMethodType((int) 23465L),
  Aliases_FindAlias((int) 23476L),
  TagVariables_FindAlias((int) 23485L),
  Topics_FindAlias((int) 23494L),
  CertificateGroupType_GetRejectedList((int) 23526L),
  CertificateGroupFolderType_DefaultApplicationGroup_GetRejectedList((int) 23529L),
  CertificateGroupFolderType_DefaultHttpsGroup_GetRejectedList((int) 23531L),
  CertificateGroupFolderType_DefaultUserTokenGroup_GetRejectedList((int) 23533L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_GetRejectedList((int) 23535L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_GetRejectedList((int) 23544L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_GetRejectedList((int) 23546L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_GetRejectedList((int) 23548L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_GetRejectedList((int) 23550L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_GetRejectedList((int) 23552L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_GetRejectedList((int) 23554L),
  PublishSubscribeType_SubscribedDataSets_AddDataSetFolder((int) 23637L),
  PublishSubscribeType_SubscribedDataSets_RemoveDataSetFolder((int) 23640L),
  PublishSubscribe_SubscribedDataSets_AddDataSetFolder((int) 23673L),
  PublishSubscribe_SubscribedDataSets_RemoveDataSetFolder((int) 23676L),
  GetConnectionMethodType((int) 23726L),
  ModifyConnectionMethodType((int) 23729L),
  GetWriterGroupMethodType((int) 23745L),
  ModifyWriterGroupMethodType((int) 23748L),
  GetReaderGroupMethodType((int) 23767L),
  ModifyReaderGroupMethodType((int) 23770L),
  GetDataSetWriterMethodType((int) 23779L),
  ModifyDataSetWriterMethodType((int) 23781L),
  GetDataSetReaderMethodType((int) 23790L),
  ModifyDataSetReaderMethodType((int) 23792L),
  SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddSubscribedDataSet(
      (int) 23797L),
  SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveSubscribedDataSet(
      (int) 23800L),
  SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_AddDataSetFolder(
      (int) 23802L),
  SubscribedDataSetFolderType_SubscribedDataSetFolderName_Placeholder_RemoveDataSetFolder(
      (int) 23805L),
  SubscribedDataSetFolderType_AddSubscribedDataSet((int) 23811L),
  SubscribedDataSetFolderType_RemoveSubscribedDataSet((int) 23814L),
  SubscribedDataSetFolderType_AddDataSetFolder((int) 23816L),
  SubscribedDataSetFolderType_RemoveDataSetFolder((int) 23819L),
  AddSubscribedDataSetMethodType((int) 23821L),
  RemoveSubscribedDataSetMethodType((int) 23824L),
  PublishSubscribeType_SubscribedDataSets_AddSubscribedDataSet((int) 24004L),
  PublishSubscribeType_SubscribedDataSets_RemoveSubscribedDataSet((int) 24007L),
  PublishSubscribe_SubscribedDataSets_AddSubscribedDataSet((int) 24010L),
  PublishSubscribe_SubscribedDataSets_RemoveSubscribedDataSet((int) 24013L),
  UserManagementType_AddUser((int) 24269L),
  UserManagementType_ModifyUser((int) 24271L),
  UserManagementType_RemoveUser((int) 24273L),
  UserManagementType_ChangePassword((int) 24275L),
  AddUserMethodType((int) 24282L),
  ModifyUserMethodType((int) 24284L),
  RemoveUserMethodType((int) 24286L),
  ChangePasswordMethodType((int) 24288L),
  UserManagement_AddUser((int) 24304L),
  UserManagement_ModifyUser((int) 24306L),
  UserManagement_RemoveUser((int) 24308L),
  UserManagement_ChangePassword((int) 24310L),
  DialogConditionType_Respond2((int) 24312L),
  DialogResponse2MethodType((int) 24314L),
  AlarmConditionType_Suppress2((int) 24316L),
  AlarmConditionType_Unsuppress2((int) 24318L),
  AlarmConditionType_RemoveFromService2((int) 24320L),
  AlarmConditionType_PlaceInService2((int) 24322L),
  AlarmConditionType_Reset2((int) 24324L),
  WithCommentMethodType((int) 24326L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2((int) 24328L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2((int) 24330L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2((int) 24332L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2((int) 24334L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2((int) 24336L),
  CertificateGroupType_CertificateExpired_Suppress2((int) 24518L),
  CertificateGroupType_CertificateExpired_Unsuppress2((int) 24520L),
  CertificateGroupType_CertificateExpired_RemoveFromService2((int) 24522L),
  CertificateGroupType_CertificateExpired_PlaceInService2((int) 24524L),
  CertificateGroupType_CertificateExpired_Reset2((int) 24526L),
  CertificateGroupType_TrustListOutOfDate_Suppress2((int) 24528L),
  CertificateGroupType_TrustListOutOfDate_Unsuppress2((int) 24530L),
  CertificateGroupType_TrustListOutOfDate_RemoveFromService2((int) 24532L),
  CertificateGroupType_TrustListOutOfDate_PlaceInService2((int) 24534L),
  CertificateGroupType_TrustListOutOfDate_Reset2((int) 24536L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Suppress2((int) 24538L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Unsuppress2((int) 24540L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_RemoveFromService2(
      (int) 24542L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_PlaceInService2(
      (int) 24544L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_Reset2((int) 24546L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Suppress2((int) 24548L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2((int) 24550L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24552L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2(
      (int) 24554L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_Reset2((int) 24556L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Suppress2((int) 24558L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Unsuppress2((int) 24560L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_RemoveFromService2((int) 24562L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_PlaceInService2((int) 24564L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_Reset2((int) 24566L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Suppress2((int) 24568L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2((int) 24570L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2((int) 24572L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2((int) 24574L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_Reset2((int) 24576L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Suppress2((int) 24578L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Unsuppress2((int) 24580L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2(
      (int) 24582L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_PlaceInService2((int) 24584L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_Reset2((int) 24586L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2((int) 24588L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2((int) 24590L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24592L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2((int) 24594L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_Reset2((int) 24596L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Suppress2((int) 24598L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Unsuppress2(
      (int) 24600L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_RemoveFromService2(
      (int) 24602L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_PlaceInService2(
      (int) 24604L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_Reset2((int) 24606L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Suppress2((int) 24608L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Unsuppress2(
      (int) 24610L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_RemoveFromService2(
      (int) 24612L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_PlaceInService2(
      (int) 24614L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_Reset2((int) 24616L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2(
      (int) 24618L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2(
      (int) 24620L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2(
      (int) 24622L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2(
      (int) 24624L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2(
      (int) 24626L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2(
      (int) 24628L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2(
      (int) 24630L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24632L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2(
      (int) 24634L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2(
      (int) 24636L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2(
      (int) 24638L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2(
      (int) 24640L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2(
      (int) 24642L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2(
      (int) 24644L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2(
      (int) 24646L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2(
      (int) 24648L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2(
      (int) 24650L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24652L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2(
      (int) 24654L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2(
      (int) 24656L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2(
      (int) 24658L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2(
      (int) 24660L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2(
      (int) 24662L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2(
      (int) 24664L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2(
      (int) 24666L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2(
      (int) 24668L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2(
      (int) 24670L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24672L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2(
      (int) 24674L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2(
      (int) 24676L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2(
      (int) 24678L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2(
      (int) 24680L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2(
      (int) 24682L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2(
      (int) 24684L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2(
      (int) 24686L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2(
      (int) 24688L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2(
      (int) 24690L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24692L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2(
      (int) 24694L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2(
      (int) 24696L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2(
      (int) 24698L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2(
      (int) 24700L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2(
      (int) 24702L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2(
      (int) 24704L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2((int) 24706L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2(
      (int) 24708L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2(
      (int) 24710L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24712L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2(
      (int) 24714L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2((int) 24716L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2(
      (int) 24718L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2(
      (int) 24720L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2(
      (int) 24722L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2(
      (int) 24724L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2(
      (int) 24726L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2(
      (int) 24728L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2(
      (int) 24730L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 24732L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2(
      (int) 24734L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2(
      (int) 24736L),
  AlarmConditionType_ShelvingState_TimedShelve2((int) 24738L),
  AlarmConditionType_ShelvingState_Unshelve2((int) 24740L),
  AlarmConditionType_ShelvingState_OneShotShelve2((int) 24742L),
  AlarmConditionType_GetGroupMemberships((int) 24744L),
  GetGroupMembershipsMethodType((int) 24746L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2((int) 24748L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2((int) 24750L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2((int) 24752L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships((int) 24754L),
  ShelvedStateMachineType_TimedShelve2((int) 24756L),
  ShelvedStateMachineType_Unshelve2((int) 24758L),
  ShelvedStateMachineType_OneShotShelve2((int) 24760L),
  CertificateGroupType_CertificateExpired_ShelvingState_TimedShelve2((int) 24978L),
  CertificateGroupType_CertificateExpired_ShelvingState_Unshelve2((int) 24980L),
  CertificateGroupType_CertificateExpired_ShelvingState_OneShotShelve2((int) 24982L),
  CertificateGroupType_CertificateExpired_GetGroupMemberships((int) 24984L),
  CertificateGroupType_TrustListOutOfDate_ShelvingState_TimedShelve2((int) 24986L),
  CertificateGroupType_TrustListOutOfDate_ShelvingState_Unshelve2((int) 24988L),
  CertificateGroupType_TrustListOutOfDate_ShelvingState_OneShotShelve2((int) 24990L),
  CertificateGroupType_TrustListOutOfDate_GetGroupMemberships((int) 24992L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 24994L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 24996L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 24998L),
  CertificateGroupFolderType_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships(
      (int) 25000L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25002L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25004L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25006L),
  CertificateGroupFolderType_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25008L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25010L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25012L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25014L),
  CertificateGroupFolderType_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships((int) 25016L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25018L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25020L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25022L),
  CertificateGroupFolderType_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships((int) 25024L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25026L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25028L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25030L),
  CertificateGroupFolderType_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships(
      (int) 25032L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25034L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25036L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25038L),
  CertificateGroupFolderType_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25040L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25042L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25044L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25046L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_CertificateExpired_GetGroupMemberships(
      (int) 25048L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25050L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25052L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25054L),
  CertificateGroupFolderType_AdditionalGroup_Placeholder_TrustListOutOfDate_GetGroupMemberships(
      (int) 25056L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25058L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25060L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25062L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships(
      (int) 25064L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25066L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25068L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25070L),
  ServerConfigurationType_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25072L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25074L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25076L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25078L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships(
      (int) 25080L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25082L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25084L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25086L),
  ServerConfigurationType_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25088L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25090L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25092L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25094L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships(
      (int) 25096L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25098L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25100L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25102L),
  ServerConfigurationType_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25104L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25106L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25108L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25110L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships(
      (int) 25112L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25114L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25116L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25118L),
  ServerConfiguration_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25120L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25122L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25124L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25126L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships(
      (int) 25128L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25130L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25132L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25134L),
  ServerConfiguration_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25136L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 25138L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 25140L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 25142L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships(
      (int) 25144L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 25146L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 25148L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 25150L),
  ServerConfiguration_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 25152L),
  TimedShelve2MethodType((int) 25157L),
  PriorityMappingTableType_AddPriorityMappingEntry((int) 25229L),
  PriorityMappingTableType_DeletePriorityMappingEntry((int) 25231L),
  AddPriorityMappingEntryMethodType((int) 25233L),
  DeletePriorityMappingEntryMethodType((int) 25235L),
  PubSubKeyServiceType_SecurityGroups_AddSecurityGroupFolder((int) 25271L),
  PubSubKeyServiceType_SecurityGroups_RemoveSecurityGroupFolder((int) 25274L),
  PubSubKeyServiceType_KeyPushTargets_AddPushTarget((int) 25278L),
  PubSubKeyServiceType_KeyPushTargets_RemovePushTarget((int) 25281L),
  PubSubKeyServiceType_KeyPushTargets_AddPushTargetFolder((int) 25283L),
  PubSubKeyServiceType_KeyPushTargets_RemovePushTargetFolder((int) 25286L),
  AddSecurityGroupFolderMethodType((int) 25288L),
  RemoveSecurityGroupFolderMethodType((int) 25291L),
  SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_AddSecurityGroupFolder((int) 25293L),
  SecurityGroupFolderType_SecurityGroupFolderName_Placeholder_RemoveSecurityGroupFolder(
      (int) 25296L),
  SecurityGroupFolderType_AddSecurityGroupFolder((int) 25312L),
  SecurityGroupFolderType_RemoveSecurityGroupFolder((int) 25315L),
  ConnectSecurityGroupsMethodType((int) 25331L),
  DisconnectSecurityGroupsMethodType((int) 25334L),
  PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTarget((int) 25348L),
  PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTarget((int) 25351L),
  PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_AddPushTargetFolder((int) 25353L),
  PubSubKeyPushTargetFolderType_PushTargetFolderName_Placeholder_RemovePushTargetFolder(
      (int) 25356L),
  PubSubKeyPushTargetFolderType_AddPushTarget((int) 25366L),
  PubSubKeyPushTargetFolderType_RemovePushTarget((int) 25369L),
  PubSubKeyPushTargetFolderType_AddPushTargetFolder((int) 25371L),
  PubSubKeyPushTargetFolderType_RemovePushTargetFolder((int) 25374L),
  AddPushTargetMethodType((int) 25376L),
  RemovePushTargetMethodType((int) 25379L),
  AddPushTargetFolderMethodType((int) 25381L),
  RemovePushTargetFolderMethodType((int) 25384L),
  PublishSubscribeType_PubSubConfiguration_Open((int) 25411L),
  PublishSubscribeType_PubSubConfiguration_Close((int) 25414L),
  PublishSubscribeType_PubSubConfiguration_Read((int) 25416L),
  PublishSubscribeType_PubSubConfiguration_Write((int) 25419L),
  PublishSubscribeType_PubSubConfiguration_GetPosition((int) 25421L),
  PublishSubscribeType_PubSubConfiguration_SetPosition((int) 25424L),
  PublishSubscribeType_PubSubConfiguration_ReserveIds((int) 25426L),
  PublishSubscribeType_PubSubConfiguration_CloseAndUpdate((int) 25429L),
  PublishSubscribe_SecurityGroups_AddSecurityGroupFolder((int) 25434L),
  PublishSubscribe_SecurityGroups_RemoveSecurityGroupFolder((int) 25437L),
  PublishSubscribe_KeyPushTargets_AddPushTarget((int) 25441L),
  PublishSubscribe_KeyPushTargets_RemovePushTarget((int) 25444L),
  PublishSubscribe_KeyPushTargets_AddPushTargetFolder((int) 25446L),
  PublishSubscribe_KeyPushTargets_RemovePushTargetFolder((int) 25449L),
  PublishSubscribe_PubSubConfiguration_Open((int) 25459L),
  PublishSubscribe_PubSubConfiguration_Close((int) 25462L),
  PublishSubscribe_PubSubConfiguration_Read((int) 25464L),
  PublishSubscribe_PubSubConfiguration_Write((int) 25467L),
  PublishSubscribe_PubSubConfiguration_GetPosition((int) 25469L),
  PublishSubscribe_PubSubConfiguration_SetPosition((int) 25472L),
  PublishSubscribe_PubSubConfiguration_ReserveIds((int) 25474L),
  PublishSubscribe_PubSubConfiguration_CloseAndUpdate((int) 25477L),
  PubSubConfigurationType_ReserveIds((int) 25505L),
  PubSubConfigurationType_CloseAndUpdate((int) 25508L),
  PubSubConfigurationTypeReserveIdsMethodType((int) 25511L),
  PubSubConfigurationTypeCloseAndUpdateMethodType((int) 25514L),
  WellKnownRole_SecurityKeyServerAdmin_AddIdentity((int) 25572L),
  WellKnownRole_SecurityKeyServerAdmin_RemoveIdentity((int) 25574L),
  WellKnownRole_SecurityKeyServerAdmin_AddApplication((int) 25576L),
  WellKnownRole_SecurityKeyServerAdmin_RemoveApplication((int) 25578L),
  WellKnownRole_SecurityKeyServerAdmin_AddEndpoint((int) 25580L),
  WellKnownRole_SecurityKeyServerAdmin_RemoveEndpoint((int) 25582L),
  WellKnownRole_SecurityKeyServerPush_AddIdentity((int) 25591L),
  WellKnownRole_SecurityKeyServerPush_RemoveIdentity((int) 25593L),
  WellKnownRole_SecurityKeyServerPush_AddApplication((int) 25595L),
  WellKnownRole_SecurityKeyServerPush_RemoveApplication((int) 25597L),
  WellKnownRole_SecurityKeyServerPush_AddEndpoint((int) 25599L),
  WellKnownRole_SecurityKeyServerPush_RemoveEndpoint((int) 25601L),
  WellKnownRole_SecurityKeyServerAccess_AddIdentity((int) 25610L),
  WellKnownRole_SecurityKeyServerAccess_RemoveIdentity((int) 25612L),
  WellKnownRole_SecurityKeyServerAccess_AddApplication((int) 25614L),
  WellKnownRole_SecurityKeyServerAccess_RemoveApplication((int) 25616L),
  WellKnownRole_SecurityKeyServerAccess_AddEndpoint((int) 25618L),
  WellKnownRole_SecurityKeyServerAccess_RemoveEndpoint((int) 25620L),
  SecurityGroupFolderType_SecurityGroupName_Placeholder_InvalidateKeys((int) 25622L),
  SecurityGroupFolderType_SecurityGroupName_Placeholder_ForceKeyRotation((int) 25623L),
  SecurityGroupType_InvalidateKeys((int) 25624L),
  SecurityGroupType_ForceKeyRotation((int) 25625L),
  PubSubKeyPushTargetType_SecurityGroupName_Placeholder_InvalidateKeys((int) 25632L),
  PubSubKeyPushTargetType_SecurityGroupName_Placeholder_ForceKeyRotation((int) 25633L),
  PubSubKeyPushTargetType_ConnectSecurityGroups((int) 25641L),
  PubSubKeyPushTargetType_DisconnectSecurityGroups((int) 25644L),
  PubSubKeyPushTargetType_TriggerKeyUpdate((int) 25647L),
  PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_ConnectSecurityGroups((int) 25655L),
  PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_DisconnectSecurityGroups((int) 25658L),
  PubSubKeyPushTargetFolderType_PushTargetName_Placeholder_TriggerKeyUpdate((int) 25661L),
  ServerConfigurationType_CancelChanges((int) 25698L),
  ServerConfigurationType_ResetToServerDefaults((int) 25699L),
  ServerConfiguration_CancelChanges((int) 25708L),
  ServerConfiguration_ResetToServerDefaults((int) 25709L),
  RequestTicketsMethodType((int) 25727L),
  SetRegistrarEndpointsMethodType((int) 25729L),
  ProvisionableDeviceType_RequestTickets((int) 26873L),
  ProvisionableDeviceType_SetRegistrarEndpoints((int) 26875L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Open(
      (int) 26889L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Close(
      (int) 26892L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Read(
      (int) 26894L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_Write(
      (int) 26897L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_GetPosition(
      (int) 26899L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_SetPosition(
      (int) 26902L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_OpenWithMasks(
      (int) 26907L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_CloseAndUpdate(
      (int) 26910L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_AddCertificate(
      (int) 26913L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustList_RemoveCertificate(
      (int) 26915L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_GetRejectedList(
      (int) 26919L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Disable(
      (int) 26954L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Enable(
      (int) 26955L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_AddComment(
      (int) 26956L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Acknowledge(
      (int) 26976L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Confirm(
      (int) 26978L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 27023L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 27025L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 27027L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 27028L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 27030L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 27031L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Silence(
      (int) 27064L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress(
      (int) 27065L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Suppress2(
      (int) 27066L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress(
      (int) 27068L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Unsuppress2(
      (int) 27069L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService(
      (int) 27071L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_RemoveFromService2(
      (int) 27072L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService(
      (int) 27074L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_PlaceInService2(
      (int) 27075L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset(
      (int) 27077L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_Reset2(
      (int) 27078L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_CertificateExpired_GetGroupMemberships(
      (int) 27080L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Disable(
      (int) 27120L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Enable(
      (int) 27121L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_AddComment(
      (int) 27122L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Acknowledge(
      (int) 27142L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Confirm(
      (int) 27144L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 27189L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 27191L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 27193L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 27194L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 27196L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 27197L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Silence(
      (int) 27230L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress(
      (int) 27231L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Suppress2(
      (int) 27232L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress(
      (int) 27234L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Unsuppress2(
      (int) 27235L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService(
      (int) 27237L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 27238L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService(
      (int) 27240L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_PlaceInService2(
      (int) 27241L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset(
      (int) 27243L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_Reset2(
      (int) 27244L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultApplicationGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 27246L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Open(
      (int) 27261L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Close(
      (int) 27264L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Read(
      (int) 27266L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_Write(
      (int) 27269L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_GetPosition(
      (int) 27271L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_SetPosition(
      (int) 27274L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_OpenWithMasks(
      (int) 27279L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_CloseAndUpdate(
      (int) 27282L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_AddCertificate(
      (int) 27285L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustList_RemoveCertificate(
      (int) 27287L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_GetRejectedList(
      (int) 27291L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Disable(
      (int) 27326L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Enable(
      (int) 27327L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_AddComment(
      (int) 27328L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Acknowledge(
      (int) 27348L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Confirm(
      (int) 27350L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 27395L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 27397L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 27399L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 27400L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 27402L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 27403L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Silence(
      (int) 27436L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress(
      (int) 27437L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Suppress2(
      (int) 27438L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress(
      (int) 27440L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Unsuppress2(
      (int) 27441L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService(
      (int) 27443L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_RemoveFromService2(
      (int) 27444L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService(
      (int) 27446L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_PlaceInService2(
      (int) 27447L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset(
      (int) 27449L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_Reset2(
      (int) 27450L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_CertificateExpired_GetGroupMemberships(
      (int) 27452L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Disable(
      (int) 27492L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Enable(
      (int) 27493L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_AddComment(
      (int) 27494L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Acknowledge(
      (int) 27514L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Confirm(
      (int) 27516L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 27561L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 27563L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 27565L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 27566L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 27568L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 27569L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Silence(
      (int) 27602L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress(
      (int) 27603L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Suppress2(
      (int) 27604L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress(
      (int) 27606L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Unsuppress2(
      (int) 27607L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService(
      (int) 27609L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 27610L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService(
      (int) 27612L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_PlaceInService2(
      (int) 27613L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset(
      (int) 27615L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_Reset2(
      (int) 27616L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultHttpsGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 27618L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Open(
      (int) 27633L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Close(
      (int) 27636L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Read(
      (int) 27638L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_Write(
      (int) 27641L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_GetPosition(
      (int) 27643L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_SetPosition(
      (int) 27646L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_OpenWithMasks(
      (int) 27651L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_CloseAndUpdate(
      (int) 27654L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_AddCertificate(
      (int) 27657L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustList_RemoveCertificate(
      (int) 27659L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_GetRejectedList(
      (int) 27663L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Disable(
      (int) 27698L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Enable(
      (int) 27699L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_AddComment(
      (int) 27700L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Acknowledge(
      (int) 27720L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Confirm(
      (int) 27722L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve(
      (int) 27767L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_TimedShelve2(
      (int) 27769L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve(
      (int) 27771L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_Unshelve2(
      (int) 27772L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve(
      (int) 27774L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_ShelvingState_OneShotShelve2(
      (int) 27775L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Silence(
      (int) 27808L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress(
      (int) 27809L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Suppress2(
      (int) 27810L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress(
      (int) 27812L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Unsuppress2(
      (int) 27813L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService(
      (int) 27815L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_RemoveFromService2(
      (int) 27816L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService(
      (int) 27818L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_PlaceInService2(
      (int) 27819L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset(
      (int) 27821L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_Reset2(
      (int) 27822L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_CertificateExpired_GetGroupMemberships(
      (int) 27824L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Disable(
      (int) 27864L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Enable(
      (int) 27865L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_AddComment(
      (int) 27866L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Acknowledge(
      (int) 27886L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Confirm(
      (int) 27888L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve(
      (int) 27933L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_TimedShelve2(
      (int) 27935L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve(
      (int) 27937L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_Unshelve2(
      (int) 27938L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve(
      (int) 27940L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_ShelvingState_OneShotShelve2(
      (int) 27941L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Silence(
      (int) 27974L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress(
      (int) 27975L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Suppress2(
      (int) 27976L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress(
      (int) 27978L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Unsuppress2(
      (int) 27979L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService(
      (int) 27981L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_RemoveFromService2(
      (int) 27982L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService(
      (int) 27984L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_PlaceInService2(
      (int) 27985L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset(
      (int) 27987L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_Reset2(
      (int) 27988L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CertificateGroups_DefaultUserTokenGroup_TrustListOutOfDate_GetGroupMemberships(
      (int) 27990L),
  ProvisionableDeviceType_ApplicationName_Placeholder_UpdateCertificate((int) 28005L),
  ProvisionableDeviceType_ApplicationName_Placeholder_ApplyChanges((int) 28008L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CancelChanges((int) 28009L),
  ProvisionableDeviceType_ApplicationName_Placeholder_CreateSigningRequest((int) 28010L),
  ProvisionableDeviceType_ApplicationName_Placeholder_GetRejectedList((int) 28013L),
  ProvisionableDeviceType_ApplicationName_Placeholder_ResetToServerDefaults((int) 28015L),
  ProvisionableDevice_RequestTickets((int) 29880L),
  ProvisionableDevice_SetRegistrarEndpoints((int) 29882L),
  GetCertificatesMethodType((int) 32282L),
  ServerConfigurationType_GetCertificates((int) 32296L),
  ServerConfiguration_GetCertificates((int) 32333L),
  ProvisionableDeviceType_ApplicationName_Placeholder_GetCertificates((int) 32359L),
  NonTransparentBackupRedundancyType_Failover((int) 32416L);
  private static final Map<Integer, OpcuaNodeIdServicesMethod> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesMethod value : OpcuaNodeIdServicesMethod.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesMethod(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesMethod enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
