/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class WriteRequest extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "673";
  }

  // Properties.
  protected final ExtensionObjectDefinition requestHeader;
  protected final int noOfNodesToWrite;
  protected final List<ExtensionObjectDefinition> nodesToWrite;

  public WriteRequest(
      ExtensionObjectDefinition requestHeader,
      int noOfNodesToWrite,
      List<ExtensionObjectDefinition> nodesToWrite) {
    super();
    this.requestHeader = requestHeader;
    this.noOfNodesToWrite = noOfNodesToWrite;
    this.nodesToWrite = nodesToWrite;
  }

  public ExtensionObjectDefinition getRequestHeader() {
    return requestHeader;
  }

  public int getNoOfNodesToWrite() {
    return noOfNodesToWrite;
  }

  public List<ExtensionObjectDefinition> getNodesToWrite() {
    return nodesToWrite;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("WriteRequest");

    // Simple Field (requestHeader)
    writeSimpleField("requestHeader", requestHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfNodesToWrite)
    writeSimpleField("noOfNodesToWrite", noOfNodesToWrite, writeSignedInt(writeBuffer, 32));

    // Array Field (nodesToWrite)
    writeComplexTypeArrayField("nodesToWrite", nodesToWrite, writeBuffer);

    writeBuffer.popContext("WriteRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    WriteRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (requestHeader)
    lengthInBits += requestHeader.getLengthInBits();

    // Simple field (noOfNodesToWrite)
    lengthInBits += 32;

    // Array field
    if (nodesToWrite != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : nodesToWrite) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= nodesToWrite.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("WriteRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectDefinition requestHeader =
        readSimpleField(
            "requestHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("391")),
                readBuffer));

    int noOfNodesToWrite = readSimpleField("noOfNodesToWrite", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> nodesToWrite =
        readCountArrayField(
            "nodesToWrite",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("670")),
                readBuffer),
            noOfNodesToWrite);

    readBuffer.closeContext("WriteRequest");
    // Create the instance
    return new WriteRequestBuilderImpl(requestHeader, noOfNodesToWrite, nodesToWrite);
  }

  public static class WriteRequestBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition requestHeader;
    private final int noOfNodesToWrite;
    private final List<ExtensionObjectDefinition> nodesToWrite;

    public WriteRequestBuilderImpl(
        ExtensionObjectDefinition requestHeader,
        int noOfNodesToWrite,
        List<ExtensionObjectDefinition> nodesToWrite) {
      this.requestHeader = requestHeader;
      this.noOfNodesToWrite = noOfNodesToWrite;
      this.nodesToWrite = nodesToWrite;
    }

    public WriteRequest build() {
      WriteRequest writeRequest = new WriteRequest(requestHeader, noOfNodesToWrite, nodesToWrite);
      return writeRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof WriteRequest)) {
      return false;
    }
    WriteRequest that = (WriteRequest) o;
    return (getRequestHeader() == that.getRequestHeader())
        && (getNoOfNodesToWrite() == that.getNoOfNodesToWrite())
        && (getNodesToWrite() == that.getNodesToWrite())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(), getRequestHeader(), getNoOfNodesToWrite(), getNodesToWrite());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
