/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaProtocolLimits;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaAcknowledgeResponse
extends MessagePDU
implements Message {
    protected final long version;
    protected final OpcuaProtocolLimits limits;

    @Override
    public String getMessageType() {
        return "ACK";
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public OpcuaAcknowledgeResponse(ChunkType chunk, long version, OpcuaProtocolLimits limits) {
        super(chunk);
        this.version = version;
        this.limits = limits;
    }

    public long getVersion() {
        return this.version;
    }

    public OpcuaProtocolLimits getLimits() {
        return this.limits;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaAcknowledgeResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"version", (Object)this.version, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"limits", (Object)this.limits, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaAcknowledgeResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaAcknowledgeResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += this.limits.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaAcknowledgeResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long version = (Long)FieldReaderFactory.readSimpleField((String)"version", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        OpcuaProtocolLimits limits = (OpcuaProtocolLimits)FieldReaderFactory.readSimpleField((String)"limits", (DataReader)new DataReaderComplexDefault(() -> OpcuaProtocolLimits.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaAcknowledgeResponse", new WithReaderArgs[0]);
        return new OpcuaAcknowledgeResponseBuilderImpl(version, limits);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaAcknowledgeResponse)) {
            return false;
        }
        OpcuaAcknowledgeResponse that = (OpcuaAcknowledgeResponse)o;
        return this.getVersion() == that.getVersion() && this.getLimits() == that.getLimits() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getVersion(), this.getLimits());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaAcknowledgeResponseBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final long version;
        private final OpcuaProtocolLimits limits;

        public OpcuaAcknowledgeResponseBuilderImpl(long version, OpcuaProtocolLimits limits) {
            this.version = version;
            this.limits = limits;
        }

        @Override
        public OpcuaAcknowledgeResponse build(ChunkType chunk) {
            OpcuaAcknowledgeResponse opcuaAcknowledgeResponse = new OpcuaAcknowledgeResponse(chunk, this.version, this.limits);
            return opcuaAcknowledgeResponse;
        }
    }
}

