/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class RegisterNodesRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfNodesToRegister;
    protected final List<NodeId> nodesToRegister;

    @Override
    public String getIdentifier() {
        return "560";
    }

    public RegisterNodesRequest(ExtensionObjectDefinition requestHeader, int noOfNodesToRegister, List<NodeId> nodesToRegister) {
        this.requestHeader = requestHeader;
        this.noOfNodesToRegister = noOfNodesToRegister;
        this.nodesToRegister = nodesToRegister;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfNodesToRegister() {
        return this.noOfNodesToRegister;
    }

    public List<NodeId> getNodesToRegister() {
        return this.nodesToRegister;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("RegisterNodesRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"noOfNodesToRegister", (Object)this.noOfNodesToRegister, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"nodesToRegister", this.nodesToRegister, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("RegisterNodesRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        RegisterNodesRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.nodesToRegister != null) {
            int i = 0;
            for (NodeId element : this.nodesToRegister) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToRegister.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("RegisterNodesRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)new DataReaderComplexDefault(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNodesToRegister = (Integer)FieldReaderFactory.readSimpleField((String)"noOfNodesToRegister", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List nodesToRegister = FieldReaderFactory.readCountArrayField((String)"nodesToRegister", (DataReader)new DataReaderComplexDefault(() -> NodeId.staticParse(readBuffer), readBuffer), (long)noOfNodesToRegister, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("RegisterNodesRequest", new WithReaderArgs[0]);
        return new RegisterNodesRequestBuilderImpl(requestHeader, noOfNodesToRegister, nodesToRegister);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisterNodesRequest)) {
            return false;
        }
        RegisterNodesRequest that = (RegisterNodesRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfNodesToRegister() == that.getNoOfNodesToRegister() && this.getNodesToRegister() == that.getNodesToRegister() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfNodesToRegister(), this.getNodesToRegister());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class RegisterNodesRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfNodesToRegister;
        private final List<NodeId> nodesToRegister;

        public RegisterNodesRequestBuilderImpl(ExtensionObjectDefinition requestHeader, int noOfNodesToRegister, List<NodeId> nodesToRegister) {
            this.requestHeader = requestHeader;
            this.noOfNodesToRegister = noOfNodesToRegister;
            this.nodesToRegister = nodesToRegister;
        }

        @Override
        public RegisterNodesRequest build() {
            RegisterNodesRequest registerNodesRequest = new RegisterNodesRequest(this.requestHeader, this.noOfNodesToRegister, this.nodesToRegister);
            return registerNodesRequest;
        }
    }
}

