/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.security;

import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;

public class SymmetricKeys {
    private final Keys clientKeys;
    private final byte[] senderNonce;
    private final Keys serverKeys;
    private final byte[] receiverNonce;

    public SymmetricKeys(Keys clientKeys, byte[] senderNonce, Keys serverKeys, byte[] receiverNonce) {
        this.clientKeys = clientKeys;
        this.senderNonce = senderNonce;
        this.serverKeys = serverKeys;
        this.receiverNonce = receiverNonce;
    }

    public Keys getClientKeys() {
        return this.clientKeys;
    }

    public byte[] getSenderNonce() {
        return this.senderNonce;
    }

    public Keys getServerKeys() {
        return this.serverKeys;
    }

    public byte[] getReceiverNonce() {
        return this.receiverNonce;
    }

    public boolean matches(byte[] senderNonce, byte[] receiverNonce) {
        return Arrays.equals(this.senderNonce, senderNonce) && Arrays.equals(this.receiverNonce, receiverNonce);
    }

    public static SymmetricKeys generateKeyPair(byte[] senderNonce, byte[] receiverNonce, SecurityPolicy securityPolicy) {
        int signatureKeySize = securityPolicy.getSignatureKeySize();
        int encryptionKeySize = securityPolicy.getEncryptionKeySize();
        int cipherTextBlockSize = securityPolicy.getEncryptionBlockSize();
        SecurityPolicy.MacSignatureAlgorithm policy = securityPolicy.getSymmetricSignatureAlgorithm();
        byte[] senderSignatureKey = SymmetricKeys.createKey(receiverNonce, senderNonce, 0, signatureKeySize, policy);
        byte[] senderEncryptionKey = SymmetricKeys.createKey(receiverNonce, senderNonce, signatureKeySize, encryptionKeySize, policy);
        byte[] senderInitializationVector = SymmetricKeys.createKey(receiverNonce, senderNonce, signatureKeySize + encryptionKeySize, cipherTextBlockSize, policy);
        byte[] receiverSignatureKey = SymmetricKeys.createKey(senderNonce, receiverNonce, 0, signatureKeySize, policy);
        byte[] receiverEncryptionKey = SymmetricKeys.createKey(senderNonce, receiverNonce, signatureKeySize, encryptionKeySize, policy);
        byte[] receiverInitializationVector = SymmetricKeys.createKey(senderNonce, receiverNonce, signatureKeySize + encryptionKeySize, cipherTextBlockSize, policy);
        return new SymmetricKeys(new Keys(senderSignatureKey, senderEncryptionKey, senderInitializationVector), senderNonce, new Keys(receiverSignatureKey, receiverEncryptionKey, receiverInitializationVector), receiverNonce);
    }

    private static byte[] createKey(byte[] secret, byte[] seed, int offset, int length, SecurityPolicy.MacSignatureAlgorithm macSignatureAlgorithm) {
        try {
            Mac mac = macSignatureAlgorithm.getSignature();
            byte[] tempBytes = SymmetricKeys.hash(macSignatureAlgorithm.getName(), secret, seed, mac, offset + length);
            byte[] key = new byte[length];
            System.arraycopy(tempBytes, offset, key, 0, key.length);
            return key;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] hash(String transformation, byte[] secret, byte[] seed, Mac mac, int required) throws Exception {
        byte[] out = new byte[required];
        int offset = 0;
        byte[] a = seed;
        while (required > 0) {
            SecretKeySpec key = new SecretKeySpec(secret, transformation);
            mac.init(key);
            mac.update(a);
            a = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(a);
            mac.update(seed);
            byte[] tmp = mac.doFinal();
            int toCopy = Math.min(required, tmp.length);
            System.arraycopy(tmp, 0, out, offset, toCopy);
            offset += toCopy;
            required -= toCopy;
        }
        return out;
    }

    public static class Keys {
        private final byte[] signatureKey;
        private final byte[] encryptionKey;
        private final byte[] initializationVector;

        public Keys(byte[] signatureKey, byte[] encryptionKey, byte[] initializationVector) {
            this.signatureKey = signatureKey;
            this.encryptionKey = encryptionKey;
            this.initializationVector = initializationVector;
        }

        public byte[] getSignatureKey() {
            return this.signatureKey;
        }

        public byte[] getEncryptionKey() {
            return this.encryptionKey;
        }

        public byte[] getInitializationVector() {
            return this.initializationVector;
        }
    }
}

