/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.AddReferencesItem;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AddReferencesRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final List<AddReferencesItem> referencesToAdd;

    @Override
    public Integer getExtensionId() {
        return 494;
    }

    public AddReferencesRequest(RequestHeader requestHeader, List<AddReferencesItem> referencesToAdd) {
        this.requestHeader = requestHeader;
        this.referencesToAdd = referencesToAdd;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public List<AddReferencesItem> getReferencesToAdd() {
        return this.referencesToAdd;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AddReferencesRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfReferencesToAdd = this.getReferencesToAdd() == null ? -1 : StaticHelper.COUNT(this.getReferencesToAdd());
        FieldWriterFactory.writeImplicitField((String)"noOfReferencesToAdd", (Object)noOfReferencesToAdd, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"referencesToAdd", this.referencesToAdd, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AddReferencesRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AddReferencesRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.referencesToAdd != null) {
            int i = 0;
            for (AddReferencesItem element : this.referencesToAdd) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.referencesToAdd.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("AddReferencesRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfReferencesToAdd = (Integer)FieldReaderFactory.readImplicitField((String)"noOfReferencesToAdd", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List referencesToAdd = FieldReaderFactory.readCountArrayField((String)"referencesToAdd", (DataReader)DataReaderFactory.readComplex(() -> (AddReferencesItem)ExtensionObjectDefinition.staticParse(readBuffer, 381), (ReadBuffer)readBuffer), (long)noOfReferencesToAdd, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("AddReferencesRequest", new WithReaderArgs[0]);
        return new AddReferencesRequestBuilderImpl(requestHeader, referencesToAdd);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddReferencesRequest)) {
            return false;
        }
        AddReferencesRequest that = (AddReferencesRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getReferencesToAdd() == that.getReferencesToAdd() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getReferencesToAdd());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AddReferencesRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final List<AddReferencesItem> referencesToAdd;

        public AddReferencesRequestBuilderImpl(RequestHeader requestHeader, List<AddReferencesItem> referencesToAdd) {
            this.requestHeader = requestHeader;
            this.referencesToAdd = referencesToAdd;
        }

        @Override
        public AddReferencesRequest build() {
            AddReferencesRequest addReferencesRequest = new AddReferencesRequest(this.requestHeader, this.referencesToAdd);
            return addReferencesRequest;
        }
    }
}

