/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.AggregateConfiguration;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AggregateFilter
extends ExtensionObjectDefinition
implements Message {
    protected final long startTime;
    protected final NodeId aggregateType;
    protected final double processingInterval;
    protected final AggregateConfiguration aggregateConfiguration;

    @Override
    public Integer getExtensionId() {
        return 730;
    }

    public AggregateFilter(long startTime, NodeId aggregateType, double processingInterval, AggregateConfiguration aggregateConfiguration) {
        this.startTime = startTime;
        this.aggregateType = aggregateType;
        this.processingInterval = processingInterval;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public NodeId getAggregateType() {
        return this.aggregateType;
    }

    public double getProcessingInterval() {
        return this.processingInterval;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AggregateFilter", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"startTime", (Object)this.startTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"aggregateType", (Object)this.aggregateType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"processingInterval", (Object)this.processingInterval, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"aggregateConfiguration", (Object)this.aggregateConfiguration, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AggregateFilter", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AggregateFilter _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += this.aggregateType.getLengthInBits();
        lengthInBits += 64;
        return lengthInBits += this.aggregateConfiguration.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("AggregateFilter", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long startTime = (Long)FieldReaderFactory.readSimpleField((String)"startTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId aggregateType = (NodeId)FieldReaderFactory.readSimpleField((String)"aggregateType", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        double processingInterval = (Double)FieldReaderFactory.readSimpleField((String)"processingInterval", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        AggregateConfiguration aggregateConfiguration = (AggregateConfiguration)FieldReaderFactory.readSimpleField((String)"aggregateConfiguration", (DataReader)DataReaderFactory.readComplex(() -> (AggregateConfiguration)ExtensionObjectDefinition.staticParse(readBuffer, 950), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("AggregateFilter", new WithReaderArgs[0]);
        return new AggregateFilterBuilderImpl(startTime, aggregateType, processingInterval, aggregateConfiguration);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AggregateFilter)) {
            return false;
        }
        AggregateFilter that = (AggregateFilter)o;
        return this.getStartTime() == that.getStartTime() && this.getAggregateType() == that.getAggregateType() && this.getProcessingInterval() == that.getProcessingInterval() && this.getAggregateConfiguration() == that.getAggregateConfiguration() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStartTime(), this.getAggregateType(), this.getProcessingInterval(), this.getAggregateConfiguration());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AggregateFilterBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long startTime;
        private final NodeId aggregateType;
        private final double processingInterval;
        private final AggregateConfiguration aggregateConfiguration;

        public AggregateFilterBuilderImpl(long startTime, NodeId aggregateType, double processingInterval, AggregateConfiguration aggregateConfiguration) {
            this.startTime = startTime;
            this.aggregateType = aggregateType;
            this.processingInterval = processingInterval;
            this.aggregateConfiguration = aggregateConfiguration;
        }

        @Override
        public AggregateFilter build() {
            AggregateFilter aggregateFilter = new AggregateFilter(this.startTime, this.aggregateType, this.processingInterval, this.aggregateConfiguration);
            return aggregateFilter;
        }
    }
}

