/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ApplicationType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ApplicationDescription
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString applicationUri;
    protected final PascalString productUri;
    protected final LocalizedText applicationName;
    protected final ApplicationType applicationType;
    protected final PascalString gatewayServerUri;
    protected final PascalString discoveryProfileUri;
    protected final List<PascalString> discoveryUrls;

    @Override
    public Integer getExtensionId() {
        return 310;
    }

    public ApplicationDescription(PascalString applicationUri, PascalString productUri, LocalizedText applicationName, ApplicationType applicationType, PascalString gatewayServerUri, PascalString discoveryProfileUri, List<PascalString> discoveryUrls) {
        this.applicationUri = applicationUri;
        this.productUri = productUri;
        this.applicationName = applicationName;
        this.applicationType = applicationType;
        this.gatewayServerUri = gatewayServerUri;
        this.discoveryProfileUri = discoveryProfileUri;
        this.discoveryUrls = discoveryUrls;
    }

    public PascalString getApplicationUri() {
        return this.applicationUri;
    }

    public PascalString getProductUri() {
        return this.productUri;
    }

    public LocalizedText getApplicationName() {
        return this.applicationName;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public PascalString getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    public PascalString getDiscoveryProfileUri() {
        return this.discoveryProfileUri;
    }

    public List<PascalString> getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ApplicationDescription", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"applicationUri", (Object)this.applicationUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"productUri", (Object)this.productUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"applicationName", (Object)this.applicationName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"applicationType", (String)"ApplicationType", (Object)((Object)this.applicationType), (DataWriter)DataWriterFactory.writeEnum(ApplicationType::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"gatewayServerUri", (Object)this.gatewayServerUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"discoveryProfileUri", (Object)this.discoveryProfileUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDiscoveryUrls = this.getDiscoveryUrls() == null ? -1 : StaticHelper.COUNT(this.getDiscoveryUrls());
        FieldWriterFactory.writeImplicitField((String)"noOfDiscoveryUrls", (Object)noOfDiscoveryUrls, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"discoveryUrls", this.discoveryUrls, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ApplicationDescription", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ApplicationDescription _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.applicationUri.getLengthInBits();
        lengthInBits += this.productUri.getLengthInBits();
        lengthInBits += this.applicationName.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += this.gatewayServerUri.getLengthInBits();
        lengthInBits += this.discoveryProfileUri.getLengthInBits();
        lengthInBits += 32;
        if (this.discoveryUrls != null) {
            int i = 0;
            for (PascalString element : this.discoveryUrls) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.discoveryUrls.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ApplicationDescription", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString applicationUri = (PascalString)FieldReaderFactory.readSimpleField((String)"applicationUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString productUri = (PascalString)FieldReaderFactory.readSimpleField((String)"productUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText applicationName = (LocalizedText)FieldReaderFactory.readSimpleField((String)"applicationName", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ApplicationType applicationType = (ApplicationType)((Object)FieldReaderFactory.readEnumField((String)"applicationType", (String)"ApplicationType", (DataReader)DataReaderFactory.readEnum(ApplicationType::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString gatewayServerUri = (PascalString)FieldReaderFactory.readSimpleField((String)"gatewayServerUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString discoveryProfileUri = (PascalString)FieldReaderFactory.readSimpleField((String)"discoveryProfileUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDiscoveryUrls = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDiscoveryUrls", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List discoveryUrls = FieldReaderFactory.readCountArrayField((String)"discoveryUrls", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDiscoveryUrls, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ApplicationDescription", new WithReaderArgs[0]);
        return new ApplicationDescriptionBuilderImpl(applicationUri, productUri, applicationName, applicationType, gatewayServerUri, discoveryProfileUri, discoveryUrls);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription that = (ApplicationDescription)o;
        return this.getApplicationUri() == that.getApplicationUri() && this.getProductUri() == that.getProductUri() && this.getApplicationName() == that.getApplicationName() && this.getApplicationType() == that.getApplicationType() && this.getGatewayServerUri() == that.getGatewayServerUri() && this.getDiscoveryProfileUri() == that.getDiscoveryProfileUri() && this.getDiscoveryUrls() == that.getDiscoveryUrls() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getApplicationUri(), this.getProductUri(), this.getApplicationName(), this.getApplicationType(), this.getGatewayServerUri(), this.getDiscoveryProfileUri(), this.getDiscoveryUrls()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApplicationDescriptionBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString applicationUri;
        private final PascalString productUri;
        private final LocalizedText applicationName;
        private final ApplicationType applicationType;
        private final PascalString gatewayServerUri;
        private final PascalString discoveryProfileUri;
        private final List<PascalString> discoveryUrls;

        public ApplicationDescriptionBuilderImpl(PascalString applicationUri, PascalString productUri, LocalizedText applicationName, ApplicationType applicationType, PascalString gatewayServerUri, PascalString discoveryProfileUri, List<PascalString> discoveryUrls) {
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.applicationName = applicationName;
            this.applicationType = applicationType;
            this.gatewayServerUri = gatewayServerUri;
            this.discoveryProfileUri = discoveryProfileUri;
            this.discoveryUrls = discoveryUrls;
        }

        @Override
        public ApplicationDescription build() {
            ApplicationDescription applicationDescription = new ApplicationDescription(this.applicationUri, this.productUri, this.applicationName, this.applicationType, this.gatewayServerUri, this.discoveryProfileUri, this.discoveryUrls);
            return applicationDescription;
        }
    }
}

