/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ApplicationDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ApplicationIdentityDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final List<KeyValuePair> recordProperties;
    protected final PascalString applicationUri;
    protected final List<LocalizedText> applicationNames;
    protected final List<ApplicationDescription> additionalServers;

    @Override
    public Integer getExtensionId() {
        return 15558;
    }

    public ApplicationIdentityDataType(PascalString name, List<KeyValuePair> recordProperties, PascalString applicationUri, List<LocalizedText> applicationNames, List<ApplicationDescription> additionalServers) {
        this.name = name;
        this.recordProperties = recordProperties;
        this.applicationUri = applicationUri;
        this.applicationNames = applicationNames;
        this.additionalServers = additionalServers;
    }

    public PascalString getName() {
        return this.name;
    }

    public List<KeyValuePair> getRecordProperties() {
        return this.recordProperties;
    }

    public PascalString getApplicationUri() {
        return this.applicationUri;
    }

    public List<LocalizedText> getApplicationNames() {
        return this.applicationNames;
    }

    public List<ApplicationDescription> getAdditionalServers() {
        return this.additionalServers;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ApplicationIdentityDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRecordProperties = this.getRecordProperties() == null ? -1 : StaticHelper.COUNT(this.getRecordProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfRecordProperties", (Object)noOfRecordProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"recordProperties", this.recordProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"applicationUri", (Object)this.applicationUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfApplicationNames = this.getApplicationNames() == null ? -1 : StaticHelper.COUNT(this.getApplicationNames());
        FieldWriterFactory.writeImplicitField((String)"noOfApplicationNames", (Object)noOfApplicationNames, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"applicationNames", this.applicationNames, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAdditionalServers = this.getAdditionalServers() == null ? -1 : StaticHelper.COUNT(this.getAdditionalServers());
        FieldWriterFactory.writeImplicitField((String)"noOfAdditionalServers", (Object)noOfAdditionalServers, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"additionalServers", this.additionalServers, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ApplicationIdentityDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ApplicationIdentityDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 32;
        if (this.recordProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.recordProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.recordProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        lengthInBits += this.applicationUri.getLengthInBits();
        lengthInBits += 32;
        if (this.applicationNames != null) {
            i = 0;
            for (LocalizedText localizedText : this.applicationNames) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.applicationNames.size());
                lengthInBits += localizedText.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.additionalServers != null) {
            i = 0;
            for (ApplicationDescription applicationDescription : this.additionalServers) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.additionalServers.size());
                lengthInBits += applicationDescription.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ApplicationIdentityDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRecordProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRecordProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List recordProperties = FieldReaderFactory.readCountArrayField((String)"recordProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfRecordProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString applicationUri = (PascalString)FieldReaderFactory.readSimpleField((String)"applicationUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfApplicationNames = (Integer)FieldReaderFactory.readImplicitField((String)"noOfApplicationNames", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List applicationNames = FieldReaderFactory.readCountArrayField((String)"applicationNames", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfApplicationNames, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAdditionalServers = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAdditionalServers", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List additionalServers = FieldReaderFactory.readCountArrayField((String)"additionalServers", (DataReader)DataReaderFactory.readComplex(() -> (ApplicationDescription)ExtensionObjectDefinition.staticParse(readBuffer, 310), (ReadBuffer)readBuffer), (long)noOfAdditionalServers, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ApplicationIdentityDataType", new WithReaderArgs[0]);
        return new ApplicationIdentityDataTypeBuilderImpl(name, recordProperties, applicationUri, applicationNames, additionalServers);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationIdentityDataType)) {
            return false;
        }
        ApplicationIdentityDataType that = (ApplicationIdentityDataType)o;
        return this.getName() == that.getName() && this.getRecordProperties() == that.getRecordProperties() && this.getApplicationUri() == that.getApplicationUri() && this.getApplicationNames() == that.getApplicationNames() && this.getAdditionalServers() == that.getAdditionalServers() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getRecordProperties(), this.getApplicationUri(), this.getApplicationNames(), this.getAdditionalServers());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApplicationIdentityDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final List<KeyValuePair> recordProperties;
        private final PascalString applicationUri;
        private final List<LocalizedText> applicationNames;
        private final List<ApplicationDescription> additionalServers;

        public ApplicationIdentityDataTypeBuilderImpl(PascalString name, List<KeyValuePair> recordProperties, PascalString applicationUri, List<LocalizedText> applicationNames, List<ApplicationDescription> additionalServers) {
            this.name = name;
            this.recordProperties = recordProperties;
            this.applicationUri = applicationUri;
            this.applicationNames = applicationNames;
            this.additionalServers = additionalServers;
        }

        @Override
        public ApplicationIdentityDataType build() {
            ApplicationIdentityDataType applicationIdentityDataType = new ApplicationIdentityDataType(this.name, this.recordProperties, this.applicationUri, this.applicationNames, this.additionalServers);
            return applicationIdentityDataType;
        }
    }
}

