/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

public enum AttributeId {
    NodeId(1L),
    NodeClass(2L),
    BrowseName(3L),
    DisplayName(4L),
    Description(5L),
    WriteMask(6L),
    UserWriteMask(7L),
    IsAbstract(8L),
    Symmetric(9L),
    InverseName(10L),
    ContainsNoLoops(11L),
    EventNotifier(12L),
    Value(13L),
    DataType(14L),
    ValueRank(15L),
    ArrayDimensions(16L),
    AccessLevel(17L),
    UserAccessLevel(18L),
    MinimumSamplingInterval(19L),
    Historizing(20L),
    Executable(21L),
    UserExecutable(22L),
    DataTypeDefinition(23L),
    RolePermissions(24L),
    UserRolePermissions(25L),
    AccessRestrictions(26L),
    AccessLevelEx(27L);

    private static final Map<Long, AttributeId> map;
    private final long value;

    static {
        map = new HashMap<Long, AttributeId>();
        AttributeId[] attributeIdArray = AttributeId.values();
        int n = attributeIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeId value = attributeIdArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private AttributeId(long value) {
        this.value = value;
    }

    public long getValue() {
        return this.value;
    }

    public static AttributeId enumForValue(long value) {
        return map.get(value);
    }

    public static Boolean isDefined(long value) {
        return map.containsKey(value);
    }
}

