/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectWithMask;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BinaryExtensionObjectWithMask
extends ExtensionObjectWithMask
implements Message {
    protected final ExtensionObjectDefinition body;

    @Override
    public Boolean getEncodingMaskXmlBody() {
        return false;
    }

    @Override
    public Boolean getEncodingMaskBinaryBody() {
        return true;
    }

    public BinaryExtensionObjectWithMask(ExpandedNodeId typeId, ExtensionObjectEncodingMask encodingMask, ExtensionObjectDefinition body) {
        super(typeId, encodingMask);
        this.body = body;
    }

    @Override
    public ExtensionObjectDefinition getBody() {
        return this.body;
    }

    @Override
    protected void serializeExtensionObjectWithMaskChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BinaryExtensionObjectWithMask", new WithWriterArgs[0]);
        int bodyLength = this.getBody() == null ? 0 : this.getBody().getLengthInBytes();
        FieldWriterFactory.writeImplicitField((String)"bodyLength", (Object)bodyLength, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"body", (Object)this.body, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BinaryExtensionObjectWithMask", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BinaryExtensionObjectWithMask _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += this.body.getLengthInBits();
    }

    public static ExtensionObjectWithMask.ExtensionObjectWithMaskBuilder staticParseExtensionObjectWithMaskBuilder(ReadBuffer readBuffer, Integer extensionId, Boolean includeEncodingMask) throws ParseException {
        readBuffer.pullContext("BinaryExtensionObjectWithMask", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int bodyLength = (Integer)FieldReaderFactory.readImplicitField((String)"bodyLength", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObjectDefinition body = (ExtensionObjectDefinition)FieldReaderFactory.readSimpleField((String)"body", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObjectDefinition.staticParse(readBuffer, (int)extensionId), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BinaryExtensionObjectWithMask", new WithReaderArgs[0]);
        return new BinaryExtensionObjectWithMaskBuilderImpl(body);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryExtensionObjectWithMask)) {
            return false;
        }
        BinaryExtensionObjectWithMask that = (BinaryExtensionObjectWithMask)o;
        return this.getBody() == that.getBody() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBody());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BinaryExtensionObjectWithMaskBuilderImpl
    implements ExtensionObjectWithMask.ExtensionObjectWithMaskBuilder {
        private final ExtensionObjectDefinition body;

        public BinaryExtensionObjectWithMaskBuilderImpl(ExtensionObjectDefinition body) {
            this.body = body;
        }

        @Override
        public BinaryExtensionObjectWithMask build(ExpandedNodeId typeId, ExtensionObjectEncodingMask encodingMask) {
            BinaryExtensionObjectWithMask binaryExtensionObjectWithMask = new BinaryExtensionObjectWithMask(typeId, encodingMask, this.body);
            return binaryExtensionObjectWithMask;
        }
    }
}

