/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.BrowseDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.ViewDescription;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BrowseRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final ViewDescription view;
    protected final long requestedMaxReferencesPerNode;
    protected final List<BrowseDescription> nodesToBrowse;

    @Override
    public Integer getExtensionId() {
        return 527;
    }

    public BrowseRequest(RequestHeader requestHeader, ViewDescription view, long requestedMaxReferencesPerNode, List<BrowseDescription> nodesToBrowse) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
        this.nodesToBrowse = nodesToBrowse;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    public long getRequestedMaxReferencesPerNode() {
        return this.requestedMaxReferencesPerNode;
    }

    public List<BrowseDescription> getNodesToBrowse() {
        return this.nodesToBrowse;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BrowseRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"view", (Object)this.view, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestedMaxReferencesPerNode", (Object)this.requestedMaxReferencesPerNode, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfNodesToBrowse = this.getNodesToBrowse() == null ? -1 : StaticHelper.COUNT(this.getNodesToBrowse());
        FieldWriterFactory.writeImplicitField((String)"noOfNodesToBrowse", (Object)noOfNodesToBrowse, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"nodesToBrowse", this.nodesToBrowse, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BrowseRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BrowseRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.view.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.nodesToBrowse != null) {
            int i = 0;
            for (BrowseDescription element : this.nodesToBrowse) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToBrowse.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("BrowseRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ViewDescription view = (ViewDescription)FieldReaderFactory.readSimpleField((String)"view", (DataReader)DataReaderFactory.readComplex(() -> (ViewDescription)ExtensionObjectDefinition.staticParse(readBuffer, 513), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long requestedMaxReferencesPerNode = (Long)FieldReaderFactory.readSimpleField((String)"requestedMaxReferencesPerNode", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNodesToBrowse = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNodesToBrowse", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List nodesToBrowse = FieldReaderFactory.readCountArrayField((String)"nodesToBrowse", (DataReader)DataReaderFactory.readComplex(() -> (BrowseDescription)ExtensionObjectDefinition.staticParse(readBuffer, 516), (ReadBuffer)readBuffer), (long)noOfNodesToBrowse, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("BrowseRequest", new WithReaderArgs[0]);
        return new BrowseRequestBuilderImpl(requestHeader, view, requestedMaxReferencesPerNode, nodesToBrowse);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowseRequest)) {
            return false;
        }
        BrowseRequest that = (BrowseRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getView() == that.getView() && this.getRequestedMaxReferencesPerNode() == that.getRequestedMaxReferencesPerNode() && this.getNodesToBrowse() == that.getNodesToBrowse() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getView(), this.getRequestedMaxReferencesPerNode(), this.getNodesToBrowse());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BrowseRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final ViewDescription view;
        private final long requestedMaxReferencesPerNode;
        private final List<BrowseDescription> nodesToBrowse;

        public BrowseRequestBuilderImpl(RequestHeader requestHeader, ViewDescription view, long requestedMaxReferencesPerNode, List<BrowseDescription> nodesToBrowse) {
            this.requestHeader = requestHeader;
            this.view = view;
            this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
            this.nodesToBrowse = nodesToBrowse;
        }

        @Override
        public BrowseRequest build() {
            BrowseRequest browseRequest = new BrowseRequest(this.requestHeader, this.view, this.requestedMaxReferencesPerNode, this.nodesToBrowse);
            return browseRequest;
        }
    }
}

