/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CallMethodResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final List<StatusCode> inputArgumentResults;
    protected final List<DiagnosticInfo> inputArgumentDiagnosticInfos;
    protected final List<Variant> outputArguments;

    @Override
    public Integer getExtensionId() {
        return 709;
    }

    public CallMethodResult(StatusCode statusCode, List<StatusCode> inputArgumentResults, List<DiagnosticInfo> inputArgumentDiagnosticInfos, List<Variant> outputArguments) {
        this.statusCode = statusCode;
        this.inputArgumentResults = inputArgumentResults;
        this.inputArgumentDiagnosticInfos = inputArgumentDiagnosticInfos;
        this.outputArguments = outputArguments;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public List<StatusCode> getInputArgumentResults() {
        return this.inputArgumentResults;
    }

    public List<DiagnosticInfo> getInputArgumentDiagnosticInfos() {
        return this.inputArgumentDiagnosticInfos;
    }

    public List<Variant> getOutputArguments() {
        return this.outputArguments;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CallMethodResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfInputArgumentResults = this.getInputArgumentResults() == null ? -1 : StaticHelper.COUNT(this.getInputArgumentResults());
        FieldWriterFactory.writeImplicitField((String)"noOfInputArgumentResults", (Object)noOfInputArgumentResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"inputArgumentResults", this.inputArgumentResults, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfInputArgumentDiagnosticInfos = this.getInputArgumentDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getInputArgumentDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfInputArgumentDiagnosticInfos", (Object)noOfInputArgumentDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"inputArgumentDiagnosticInfos", this.inputArgumentDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfOutputArguments = this.getOutputArguments() == null ? -1 : StaticHelper.COUNT(this.getOutputArguments());
        FieldWriterFactory.writeImplicitField((String)"noOfOutputArguments", (Object)noOfOutputArguments, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"outputArguments", this.outputArguments, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CallMethodResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        CallMethodResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.inputArgumentResults != null) {
            i = 0;
            for (StatusCode statusCode : this.inputArgumentResults) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.inputArgumentResults.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.inputArgumentDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.inputArgumentDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.inputArgumentDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.outputArguments != null) {
            i = 0;
            for (Variant variant : this.outputArguments) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.outputArguments.size());
                lengthInBits += variant.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("CallMethodResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfInputArgumentResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfInputArgumentResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List inputArgumentResults = FieldReaderFactory.readCountArrayField((String)"inputArgumentResults", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfInputArgumentResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfInputArgumentDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfInputArgumentDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List inputArgumentDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"inputArgumentDiagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfInputArgumentDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfOutputArguments = (Integer)FieldReaderFactory.readImplicitField((String)"noOfOutputArguments", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List outputArguments = FieldReaderFactory.readCountArrayField((String)"outputArguments", (DataReader)DataReaderFactory.readComplex(() -> Variant.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfOutputArguments, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CallMethodResult", new WithReaderArgs[0]);
        return new CallMethodResultBuilderImpl(statusCode, inputArgumentResults, inputArgumentDiagnosticInfos, outputArguments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallMethodResult)) {
            return false;
        }
        CallMethodResult that = (CallMethodResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getInputArgumentResults() == that.getInputArgumentResults() && this.getInputArgumentDiagnosticInfos() == that.getInputArgumentDiagnosticInfos() && this.getOutputArguments() == that.getOutputArguments() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getInputArgumentResults(), this.getInputArgumentDiagnosticInfos(), this.getOutputArguments());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CallMethodResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final List<StatusCode> inputArgumentResults;
        private final List<DiagnosticInfo> inputArgumentDiagnosticInfos;
        private final List<Variant> outputArguments;

        public CallMethodResultBuilderImpl(StatusCode statusCode, List<StatusCode> inputArgumentResults, List<DiagnosticInfo> inputArgumentDiagnosticInfos, List<Variant> outputArguments) {
            this.statusCode = statusCode;
            this.inputArgumentResults = inputArgumentResults;
            this.inputArgumentDiagnosticInfos = inputArgumentDiagnosticInfos;
            this.outputArguments = outputArguments;
        }

        @Override
        public CallMethodResult build() {
            CallMethodResult callMethodResult = new CallMethodResult(this.statusCode, this.inputArgumentResults, this.inputArgumentDiagnosticInfos, this.outputArguments);
            return callMethodResult;
        }
    }
}

