/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.CallMethodRequest;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CallRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final List<CallMethodRequest> methodsToCall;

    @Override
    public Integer getExtensionId() {
        return 712;
    }

    public CallRequest(RequestHeader requestHeader, List<CallMethodRequest> methodsToCall) {
        this.requestHeader = requestHeader;
        this.methodsToCall = methodsToCall;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public List<CallMethodRequest> getMethodsToCall() {
        return this.methodsToCall;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CallRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfMethodsToCall = this.getMethodsToCall() == null ? -1 : StaticHelper.COUNT(this.getMethodsToCall());
        FieldWriterFactory.writeImplicitField((String)"noOfMethodsToCall", (Object)noOfMethodsToCall, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"methodsToCall", this.methodsToCall, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CallRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CallRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.methodsToCall != null) {
            int i = 0;
            for (CallMethodRequest element : this.methodsToCall) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.methodsToCall.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("CallRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfMethodsToCall = (Integer)FieldReaderFactory.readImplicitField((String)"noOfMethodsToCall", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List methodsToCall = FieldReaderFactory.readCountArrayField((String)"methodsToCall", (DataReader)DataReaderFactory.readComplex(() -> (CallMethodRequest)ExtensionObjectDefinition.staticParse(readBuffer, 706), (ReadBuffer)readBuffer), (long)noOfMethodsToCall, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CallRequest", new WithReaderArgs[0]);
        return new CallRequestBuilderImpl(requestHeader, methodsToCall);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallRequest)) {
            return false;
        }
        CallRequest that = (CallRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getMethodsToCall() == that.getMethodsToCall() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getMethodsToCall());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CallRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final List<CallMethodRequest> methodsToCall;

        public CallRequestBuilderImpl(RequestHeader requestHeader, List<CallMethodRequest> methodsToCall) {
            this.requestHeader = requestHeader;
            this.methodsToCall = methodsToCall;
        }

        @Override
        public CallRequest build() {
            CallRequest callRequest = new CallRequest(this.requestHeader, this.methodsToCall);
            return callRequest;
        }
    }
}

