/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ContentFilterElement;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ContentFilter
extends ExtensionObjectDefinition
implements Message {
    protected final List<ContentFilterElement> elements;

    @Override
    public Integer getExtensionId() {
        return 588;
    }

    public ContentFilter(List<ContentFilterElement> elements) {
        this.elements = elements;
    }

    public List<ContentFilterElement> getElements() {
        return this.elements;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ContentFilter", new WithWriterArgs[0]);
        int noOfElements = this.getElements() == null ? -1 : StaticHelper.COUNT(this.getElements());
        FieldWriterFactory.writeImplicitField((String)"noOfElements", (Object)noOfElements, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"elements", this.elements, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ContentFilter", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ContentFilter _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.elements != null) {
            int i = 0;
            for (ContentFilterElement element : this.elements) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.elements.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ContentFilter", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfElements = (Integer)FieldReaderFactory.readImplicitField((String)"noOfElements", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List elements = FieldReaderFactory.readCountArrayField((String)"elements", (DataReader)DataReaderFactory.readComplex(() -> (ContentFilterElement)ExtensionObjectDefinition.staticParse(readBuffer, 585), (ReadBuffer)readBuffer), (long)noOfElements, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ContentFilter", new WithReaderArgs[0]);
        return new ContentFilterBuilderImpl(elements);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentFilter)) {
            return false;
        }
        ContentFilter that = (ContentFilter)o;
        return this.getElements() == that.getElements() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getElements());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ContentFilterBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<ContentFilterElement> elements;

        public ContentFilterBuilderImpl(List<ContentFilterElement> elements) {
            this.elements = elements;
        }

        @Override
        public ContentFilter build() {
            ContentFilter contentFilter = new ContentFilter(this.elements);
            return contentFilter;
        }
    }
}

