/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataSetFieldContentMask;
import org.apache.plc4x.java.opcua.readwrite.DataSetMetaDataType;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DataSetReaderDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final boolean enabled;
    protected final Variant publisherId;
    protected final int writerGroupId;
    protected final int dataSetWriterId;
    protected final DataSetMetaDataType dataSetMetaData;
    protected final DataSetFieldContentMask dataSetFieldContentMask;
    protected final double messageReceiveTimeout;
    protected final long keyFrameCount;
    protected final PascalString headerLayoutUri;
    protected final MessageSecurityMode securityMode;
    protected final PascalString securityGroupId;
    protected final List<EndpointDescription> securityKeyServices;
    protected final List<KeyValuePair> dataSetReaderProperties;
    protected final ExtensionObject transportSettings;
    protected final ExtensionObject messageSettings;
    protected final ExtensionObject subscribedDataSet;

    @Override
    public Integer getExtensionId() {
        return 15625;
    }

    public DataSetReaderDataType(PascalString name, boolean enabled, Variant publisherId, int writerGroupId, int dataSetWriterId, DataSetMetaDataType dataSetMetaData, DataSetFieldContentMask dataSetFieldContentMask, double messageReceiveTimeout, long keyFrameCount, PascalString headerLayoutUri, MessageSecurityMode securityMode, PascalString securityGroupId, List<EndpointDescription> securityKeyServices, List<KeyValuePair> dataSetReaderProperties, ExtensionObject transportSettings, ExtensionObject messageSettings, ExtensionObject subscribedDataSet) {
        this.name = name;
        this.enabled = enabled;
        this.publisherId = publisherId;
        this.writerGroupId = writerGroupId;
        this.dataSetWriterId = dataSetWriterId;
        this.dataSetMetaData = dataSetMetaData;
        this.dataSetFieldContentMask = dataSetFieldContentMask;
        this.messageReceiveTimeout = messageReceiveTimeout;
        this.keyFrameCount = keyFrameCount;
        this.headerLayoutUri = headerLayoutUri;
        this.securityMode = securityMode;
        this.securityGroupId = securityGroupId;
        this.securityKeyServices = securityKeyServices;
        this.dataSetReaderProperties = dataSetReaderProperties;
        this.transportSettings = transportSettings;
        this.messageSettings = messageSettings;
        this.subscribedDataSet = subscribedDataSet;
    }

    public PascalString getName() {
        return this.name;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Variant getPublisherId() {
        return this.publisherId;
    }

    public int getWriterGroupId() {
        return this.writerGroupId;
    }

    public int getDataSetWriterId() {
        return this.dataSetWriterId;
    }

    public DataSetMetaDataType getDataSetMetaData() {
        return this.dataSetMetaData;
    }

    public DataSetFieldContentMask getDataSetFieldContentMask() {
        return this.dataSetFieldContentMask;
    }

    public double getMessageReceiveTimeout() {
        return this.messageReceiveTimeout;
    }

    public long getKeyFrameCount() {
        return this.keyFrameCount;
    }

    public PascalString getHeaderLayoutUri() {
        return this.headerLayoutUri;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalString getSecurityGroupId() {
        return this.securityGroupId;
    }

    public List<EndpointDescription> getSecurityKeyServices() {
        return this.securityKeyServices;
    }

    public List<KeyValuePair> getDataSetReaderProperties() {
        return this.dataSetReaderProperties;
    }

    public ExtensionObject getTransportSettings() {
        return this.transportSettings;
    }

    public ExtensionObject getMessageSettings() {
        return this.messageSettings;
    }

    public ExtensionObject getSubscribedDataSet() {
        return this.subscribedDataSet;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DataSetReaderDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"enabled", (Object)this.enabled, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publisherId", (Object)this.publisherId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"writerGroupId", (Object)this.writerGroupId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetWriterId", (Object)this.dataSetWriterId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetMetaData", (Object)this.dataSetMetaData, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"dataSetFieldContentMask", (String)"DataSetFieldContentMask", (Object)((Object)this.dataSetFieldContentMask), (DataWriter)DataWriterFactory.writeEnum(DataSetFieldContentMask::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageReceiveTimeout", (Object)this.messageReceiveTimeout, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"keyFrameCount", (Object)this.keyFrameCount, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"headerLayoutUri", (Object)this.headerLayoutUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"securityMode", (String)"MessageSecurityMode", (Object)((Object)this.securityMode), (DataWriter)DataWriterFactory.writeEnum(MessageSecurityMode::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityGroupId", (Object)this.securityGroupId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSecurityKeyServices = this.getSecurityKeyServices() == null ? -1 : StaticHelper.COUNT(this.getSecurityKeyServices());
        FieldWriterFactory.writeImplicitField((String)"noOfSecurityKeyServices", (Object)noOfSecurityKeyServices, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"securityKeyServices", this.securityKeyServices, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDataSetReaderProperties = this.getDataSetReaderProperties() == null ? -1 : StaticHelper.COUNT(this.getDataSetReaderProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfDataSetReaderProperties", (Object)noOfDataSetReaderProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataSetReaderProperties", this.dataSetReaderProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"transportSettings", (Object)this.transportSettings, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageSettings", (Object)this.messageSettings, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"subscribedDataSet", (Object)this.subscribedDataSet, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DataSetReaderDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        DataSetReaderDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += this.publisherId.getLengthInBits();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += this.dataSetMetaData.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 64;
        lengthInBits += 32;
        lengthInBits += this.headerLayoutUri.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += this.securityGroupId.getLengthInBits();
        lengthInBits += 32;
        if (this.securityKeyServices != null) {
            i = 0;
            for (EndpointDescription endpointDescription : this.securityKeyServices) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.securityKeyServices.size());
                lengthInBits += endpointDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.dataSetReaderProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.dataSetReaderProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataSetReaderProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        lengthInBits += this.transportSettings.getLengthInBits();
        lengthInBits += this.messageSettings.getLengthInBits();
        return lengthInBits += this.subscribedDataSet.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DataSetReaderDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean enabled = (Boolean)FieldReaderFactory.readSimpleField((String)"enabled", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Variant publisherId = (Variant)FieldReaderFactory.readSimpleField((String)"publisherId", (DataReader)DataReaderFactory.readComplex(() -> Variant.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int writerGroupId = (Integer)FieldReaderFactory.readSimpleField((String)"writerGroupId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int dataSetWriterId = (Integer)FieldReaderFactory.readSimpleField((String)"dataSetWriterId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        DataSetMetaDataType dataSetMetaData = (DataSetMetaDataType)FieldReaderFactory.readSimpleField((String)"dataSetMetaData", (DataReader)DataReaderFactory.readComplex(() -> (DataSetMetaDataType)ExtensionObjectDefinition.staticParse(readBuffer, 14525), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        DataSetFieldContentMask dataSetFieldContentMask = (DataSetFieldContentMask)((Object)FieldReaderFactory.readEnumField((String)"dataSetFieldContentMask", (String)"DataSetFieldContentMask", (DataReader)DataReaderFactory.readEnum(DataSetFieldContentMask::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        double messageReceiveTimeout = (Double)FieldReaderFactory.readSimpleField((String)"messageReceiveTimeout", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        long keyFrameCount = (Long)FieldReaderFactory.readSimpleField((String)"keyFrameCount", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString headerLayoutUri = (PascalString)FieldReaderFactory.readSimpleField((String)"headerLayoutUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField((String)"securityMode", (String)"MessageSecurityMode", (DataReader)DataReaderFactory.readEnum(MessageSecurityMode::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString securityGroupId = (PascalString)FieldReaderFactory.readSimpleField((String)"securityGroupId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSecurityKeyServices = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSecurityKeyServices", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List securityKeyServices = FieldReaderFactory.readCountArrayField((String)"securityKeyServices", (DataReader)DataReaderFactory.readComplex(() -> (EndpointDescription)ExtensionObjectDefinition.staticParse(readBuffer, 314), (ReadBuffer)readBuffer), (long)noOfSecurityKeyServices, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataSetReaderProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataSetReaderProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataSetReaderProperties = FieldReaderFactory.readCountArrayField((String)"dataSetReaderProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfDataSetReaderProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject transportSettings = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"transportSettings", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject messageSettings = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"messageSettings", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject subscribedDataSet = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"subscribedDataSet", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DataSetReaderDataType", new WithReaderArgs[0]);
        return new DataSetReaderDataTypeBuilderImpl(name, enabled, publisherId, writerGroupId, dataSetWriterId, dataSetMetaData, dataSetFieldContentMask, messageReceiveTimeout, keyFrameCount, headerLayoutUri, securityMode, securityGroupId, securityKeyServices, dataSetReaderProperties, transportSettings, messageSettings, subscribedDataSet);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSetReaderDataType)) {
            return false;
        }
        DataSetReaderDataType that = (DataSetReaderDataType)o;
        return this.getName() == that.getName() && this.getEnabled() == that.getEnabled() && this.getPublisherId() == that.getPublisherId() && this.getWriterGroupId() == that.getWriterGroupId() && this.getDataSetWriterId() == that.getDataSetWriterId() && this.getDataSetMetaData() == that.getDataSetMetaData() && this.getDataSetFieldContentMask() == that.getDataSetFieldContentMask() && this.getMessageReceiveTimeout() == that.getMessageReceiveTimeout() && this.getKeyFrameCount() == that.getKeyFrameCount() && this.getHeaderLayoutUri() == that.getHeaderLayoutUri() && this.getSecurityMode() == that.getSecurityMode() && this.getSecurityGroupId() == that.getSecurityGroupId() && this.getSecurityKeyServices() == that.getSecurityKeyServices() && this.getDataSetReaderProperties() == that.getDataSetReaderProperties() && this.getTransportSettings() == that.getTransportSettings() && this.getMessageSettings() == that.getMessageSettings() && this.getSubscribedDataSet() == that.getSubscribedDataSet() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getName(), this.getEnabled(), this.getPublisherId(), this.getWriterGroupId(), this.getDataSetWriterId(), this.getDataSetMetaData(), this.getDataSetFieldContentMask(), this.getMessageReceiveTimeout(), this.getKeyFrameCount(), this.getHeaderLayoutUri(), this.getSecurityMode(), this.getSecurityGroupId(), this.getSecurityKeyServices(), this.getDataSetReaderProperties(), this.getTransportSettings(), this.getMessageSettings(), this.getSubscribedDataSet()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DataSetReaderDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final boolean enabled;
        private final Variant publisherId;
        private final int writerGroupId;
        private final int dataSetWriterId;
        private final DataSetMetaDataType dataSetMetaData;
        private final DataSetFieldContentMask dataSetFieldContentMask;
        private final double messageReceiveTimeout;
        private final long keyFrameCount;
        private final PascalString headerLayoutUri;
        private final MessageSecurityMode securityMode;
        private final PascalString securityGroupId;
        private final List<EndpointDescription> securityKeyServices;
        private final List<KeyValuePair> dataSetReaderProperties;
        private final ExtensionObject transportSettings;
        private final ExtensionObject messageSettings;
        private final ExtensionObject subscribedDataSet;

        public DataSetReaderDataTypeBuilderImpl(PascalString name, boolean enabled, Variant publisherId, int writerGroupId, int dataSetWriterId, DataSetMetaDataType dataSetMetaData, DataSetFieldContentMask dataSetFieldContentMask, double messageReceiveTimeout, long keyFrameCount, PascalString headerLayoutUri, MessageSecurityMode securityMode, PascalString securityGroupId, List<EndpointDescription> securityKeyServices, List<KeyValuePair> dataSetReaderProperties, ExtensionObject transportSettings, ExtensionObject messageSettings, ExtensionObject subscribedDataSet) {
            this.name = name;
            this.enabled = enabled;
            this.publisherId = publisherId;
            this.writerGroupId = writerGroupId;
            this.dataSetWriterId = dataSetWriterId;
            this.dataSetMetaData = dataSetMetaData;
            this.dataSetFieldContentMask = dataSetFieldContentMask;
            this.messageReceiveTimeout = messageReceiveTimeout;
            this.keyFrameCount = keyFrameCount;
            this.headerLayoutUri = headerLayoutUri;
            this.securityMode = securityMode;
            this.securityGroupId = securityGroupId;
            this.securityKeyServices = securityKeyServices;
            this.dataSetReaderProperties = dataSetReaderProperties;
            this.transportSettings = transportSettings;
            this.messageSettings = messageSettings;
            this.subscribedDataSet = subscribedDataSet;
        }

        @Override
        public DataSetReaderDataType build() {
            DataSetReaderDataType dataSetReaderDataType = new DataSetReaderDataType(this.name, this.enabled, this.publisherId, this.writerGroupId, this.dataSetWriterId, this.dataSetMetaData, this.dataSetFieldContentMask, this.messageReceiveTimeout, this.keyFrameCount, this.headerLayoutUri, this.securityMode, this.securityGroupId, this.securityKeyServices, this.dataSetReaderProperties, this.transportSettings, this.messageSettings, this.subscribedDataSet);
            return dataSetReaderDataType;
        }
    }
}

