/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DatagramDataSetReaderTransportDataType
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObject address;
    protected final PascalString qosCategory;
    protected final List<ExtensionObject> datagramQos;
    protected final PascalString topic;

    @Override
    public Integer getExtensionId() {
        return 23616;
    }

    public DatagramDataSetReaderTransportDataType(ExtensionObject address, PascalString qosCategory, List<ExtensionObject> datagramQos, PascalString topic) {
        this.address = address;
        this.qosCategory = qosCategory;
        this.datagramQos = datagramQos;
        this.topic = topic;
    }

    public ExtensionObject getAddress() {
        return this.address;
    }

    public PascalString getQosCategory() {
        return this.qosCategory;
    }

    public List<ExtensionObject> getDatagramQos() {
        return this.datagramQos;
    }

    public PascalString getTopic() {
        return this.topic;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DatagramDataSetReaderTransportDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"qosCategory", (Object)this.qosCategory, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDatagramQos = this.getDatagramQos() == null ? -1 : StaticHelper.COUNT(this.getDatagramQos());
        FieldWriterFactory.writeImplicitField((String)"noOfDatagramQos", (Object)noOfDatagramQos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"datagramQos", this.datagramQos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"topic", (Object)this.topic, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DatagramDataSetReaderTransportDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DatagramDataSetReaderTransportDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.address.getLengthInBits();
        lengthInBits += this.qosCategory.getLengthInBits();
        lengthInBits += 32;
        if (this.datagramQos != null) {
            int i = 0;
            for (ExtensionObject element : this.datagramQos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.datagramQos.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits += this.topic.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DatagramDataSetReaderTransportDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObject address = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString qosCategory = (PascalString)FieldReaderFactory.readSimpleField((String)"qosCategory", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDatagramQos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDatagramQos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List datagramQos = FieldReaderFactory.readCountArrayField((String)"datagramQos", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (long)noOfDatagramQos, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString topic = (PascalString)FieldReaderFactory.readSimpleField((String)"topic", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DatagramDataSetReaderTransportDataType", new WithReaderArgs[0]);
        return new DatagramDataSetReaderTransportDataTypeBuilderImpl(address, qosCategory, datagramQos, topic);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatagramDataSetReaderTransportDataType)) {
            return false;
        }
        DatagramDataSetReaderTransportDataType that = (DatagramDataSetReaderTransportDataType)o;
        return this.getAddress() == that.getAddress() && this.getQosCategory() == that.getQosCategory() && this.getDatagramQos() == that.getDatagramQos() && this.getTopic() == that.getTopic() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAddress(), this.getQosCategory(), this.getDatagramQos(), this.getTopic());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DatagramDataSetReaderTransportDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObject address;
        private final PascalString qosCategory;
        private final List<ExtensionObject> datagramQos;
        private final PascalString topic;

        public DatagramDataSetReaderTransportDataTypeBuilderImpl(ExtensionObject address, PascalString qosCategory, List<ExtensionObject> datagramQos, PascalString topic) {
            this.address = address;
            this.qosCategory = qosCategory;
            this.datagramQos = datagramQos;
            this.topic = topic;
        }

        @Override
        public DatagramDataSetReaderTransportDataType build() {
            DatagramDataSetReaderTransportDataType datagramDataSetReaderTransportDataType = new DatagramDataSetReaderTransportDataType(this.address, this.qosCategory, this.datagramQos, this.topic);
            return datagramDataSetReaderTransportDataType;
        }
    }
}

