/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DeleteEventDetails
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId nodeId;
    protected final List<PascalByteString> eventIds;

    @Override
    public Integer getExtensionId() {
        return 694;
    }

    public DeleteEventDetails(NodeId nodeId, List<PascalByteString> eventIds) {
        this.nodeId = nodeId;
        this.eventIds = eventIds;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public List<PascalByteString> getEventIds() {
        return this.eventIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DeleteEventDetails", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"nodeId", (Object)this.nodeId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfEventIds = this.getEventIds() == null ? -1 : StaticHelper.COUNT(this.getEventIds());
        FieldWriterFactory.writeImplicitField((String)"noOfEventIds", (Object)noOfEventIds, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"eventIds", this.eventIds, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DeleteEventDetails", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DeleteEventDetails _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.nodeId.getLengthInBits();
        lengthInBits += 32;
        if (this.eventIds != null) {
            int i = 0;
            for (PascalByteString element : this.eventIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.eventIds.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DeleteEventDetails", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId nodeId = (NodeId)FieldReaderFactory.readSimpleField((String)"nodeId", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfEventIds = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEventIds", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List eventIds = FieldReaderFactory.readCountArrayField((String)"eventIds", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfEventIds, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DeleteEventDetails", new WithReaderArgs[0]);
        return new DeleteEventDetailsBuilderImpl(nodeId, eventIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteEventDetails)) {
            return false;
        }
        DeleteEventDetails that = (DeleteEventDetails)o;
        return this.getNodeId() == that.getNodeId() && this.getEventIds() == that.getEventIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeId(), this.getEventIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DeleteEventDetailsBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId nodeId;
        private final List<PascalByteString> eventIds;

        public DeleteEventDetailsBuilderImpl(NodeId nodeId, List<PascalByteString> eventIds) {
            this.nodeId = nodeId;
            this.eventIds = eventIds;
        }

        @Override
        public DeleteEventDetails build() {
            DeleteEventDetails deleteEventDetails = new DeleteEventDetails(this.nodeId, this.eventIds);
            return deleteEventDetails;
        }
    }
}

