/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DeleteNodesItem;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DeleteNodesRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final List<DeleteNodesItem> nodesToDelete;

    @Override
    public Integer getExtensionId() {
        return 500;
    }

    public DeleteNodesRequest(RequestHeader requestHeader, List<DeleteNodesItem> nodesToDelete) {
        this.requestHeader = requestHeader;
        this.nodesToDelete = nodesToDelete;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public List<DeleteNodesItem> getNodesToDelete() {
        return this.nodesToDelete;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DeleteNodesRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfNodesToDelete = this.getNodesToDelete() == null ? -1 : StaticHelper.COUNT(this.getNodesToDelete());
        FieldWriterFactory.writeImplicitField((String)"noOfNodesToDelete", (Object)noOfNodesToDelete, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"nodesToDelete", this.nodesToDelete, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DeleteNodesRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DeleteNodesRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.nodesToDelete != null) {
            int i = 0;
            for (DeleteNodesItem element : this.nodesToDelete) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodesToDelete.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DeleteNodesRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNodesToDelete = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNodesToDelete", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List nodesToDelete = FieldReaderFactory.readCountArrayField((String)"nodesToDelete", (DataReader)DataReaderFactory.readComplex(() -> (DeleteNodesItem)ExtensionObjectDefinition.staticParse(readBuffer, 384), (ReadBuffer)readBuffer), (long)noOfNodesToDelete, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DeleteNodesRequest", new WithReaderArgs[0]);
        return new DeleteNodesRequestBuilderImpl(requestHeader, nodesToDelete);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteNodesRequest)) {
            return false;
        }
        DeleteNodesRequest that = (DeleteNodesRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNodesToDelete() == that.getNodesToDelete() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNodesToDelete());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DeleteNodesRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final List<DeleteNodesItem> nodesToDelete;

        public DeleteNodesRequestBuilderImpl(RequestHeader requestHeader, List<DeleteNodesItem> nodesToDelete) {
            this.requestHeader = requestHeader;
            this.nodesToDelete = nodesToDelete;
        }

        @Override
        public DeleteNodesRequest build() {
            DeleteNodesRequest deleteNodesRequest = new DeleteNodesRequest(this.requestHeader, this.nodesToDelete);
            return deleteNodesRequest;
        }
    }
}

